/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb;

import com.fr.third.org.hsqldb.Column;
import com.fr.third.org.hsqldb.HsqlException;
import com.fr.third.org.hsqldb.Session;
import com.fr.third.org.hsqldb.Trace;
import com.fr.third.org.hsqldb.lib.HashSet;
import com.fr.third.org.hsqldb.store.ValuePool;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SetFunction {
    private HashSet distinctValues;
    private boolean isDistinct;
    private int setType;
    private int type;
    private int count;
    private boolean hasNull;
    private boolean every = true;
    private boolean some = false;
    private long currentLong;
    private double currentDouble;
    private BigDecimal currentBigDecimal;
    private Object currentValue;
    static BigInteger multiplier = BigInteger.valueOf(0x100000000L);
    long hi;
    long lo;
    private double sk;
    private double vk;
    private long n;
    private boolean initialized;
    private boolean sample;

    SetFunction(int setType, int type, boolean isDistinct) {
        this.setType = setType;
        this.type = type;
        if (isDistinct) {
            this.isDistinct = true;
            this.distinctValues = new HashSet();
        }
        if (setType == 50 || setType == 48) {
            this.sample = true;
        }
    }

    void add(Session session, Object item) throws HsqlException {
        if (item == null) {
            this.hasNull = true;
            return;
        }
        if (this.isDistinct && !this.distinctValues.add(item)) {
            return;
        }
        ++this.count;
        switch (this.setType) {
            case 40: {
                return;
            }
            case 41: 
            case 44: {
                switch (this.type) {
                    case -6: 
                    case 4: 
                    case 5: {
                        this.currentLong += (long)((Number)item).intValue();
                        return;
                    }
                    case -5: {
                        this.addLong(((Number)item).longValue());
                        return;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        this.currentDouble += ((Number)item).doubleValue();
                        return;
                    }
                    case 2: 
                    case 3: {
                        this.currentBigDecimal = this.currentBigDecimal == null ? (BigDecimal)item : this.currentBigDecimal.add((BigDecimal)item);
                        return;
                    }
                }
                throw Trace.error(15);
            }
            case 42: {
                if (this.currentValue == null) {
                    this.currentValue = item;
                    return;
                }
                if (Column.compare(session.database.collation, this.currentValue, item, this.type) > 0) {
                    this.currentValue = item;
                }
                return;
            }
            case 43: {
                if (this.currentValue == null) {
                    this.currentValue = item;
                    return;
                }
                if (Column.compare(session.database.collation, this.currentValue, item, this.type) < 0) {
                    this.currentValue = item;
                }
                return;
            }
            case 45: {
                if (!(item instanceof Boolean)) {
                    throw Trace.error(16);
                }
                this.every &= ((Boolean)item).booleanValue();
                return;
            }
            case 46: {
                if (!(item instanceof Boolean)) {
                    throw Trace.error(16);
                }
                this.some |= ((Boolean)item).booleanValue();
                return;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                if (!(item instanceof Number)) {
                    throw Trace.error(16);
                }
                this.addDataPoint((Number)item);
                return;
            }
        }
    }

    Object getValue() throws HsqlException {
        if (this.setType == 40) {
            return ValuePool.getInt(this.count);
        }
        if (this.count == 0) {
            return null;
        }
        switch (this.setType) {
            case 44: {
                switch (this.type) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return new Long(this.currentLong / (long)this.count);
                    }
                    case -5: {
                        long value = this.getLongSum().divide(BigInteger.valueOf(this.count)).longValue();
                        return new Long(value);
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return new Double(this.currentDouble / (double)this.count);
                    }
                    case 2: 
                    case 3: {
                        return this.currentBigDecimal.divide(new BigDecimal((double)this.count), 1);
                    }
                }
                throw Trace.error(15);
            }
            case 41: {
                switch (this.type) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return new Long(this.currentLong);
                    }
                    case -5: {
                        return new BigDecimal(this.getLongSum());
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return new Double(this.currentDouble);
                    }
                    case 2: 
                    case 3: {
                        return this.currentBigDecimal;
                    }
                }
                throw Trace.error(15);
            }
            case 42: 
            case 43: {
                return this.currentValue;
            }
            case 45: {
                return this.every ? Boolean.TRUE : Boolean.FALSE;
            }
            case 46: {
                return this.some ? Boolean.TRUE : Boolean.FALSE;
            }
            case 47: 
            case 48: {
                return this.getStdDev();
            }
            case 49: 
            case 50: {
                return this.getVariance();
            }
        }
        throw Trace.error(95);
    }

    static int getType(int setType, int type) throws HsqlException {
        switch (setType) {
            case 40: {
                return 4;
            }
            case 44: {
                switch (type) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        return -5;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return 8;
                    }
                    case 2: 
                    case 3: {
                        return 3;
                    }
                }
                return 0;
            }
            case 41: {
                switch (type) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return -5;
                    }
                    case -5: {
                        return 3;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return 8;
                    }
                    case 2: 
                    case 3: {
                        return 3;
                    }
                }
                return 0;
            }
            case 42: 
            case 43: {
                return type;
            }
            case 45: 
            case 46: {
                return 16;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                return 8;
            }
        }
        throw Trace.error(95);
    }

    void addLong(long value) {
        if (value != 0L) {
            if (value > 0L) {
                this.hi += value >> 32;
                this.lo += value & 0xFFFFFFFFL;
            } else if (value == Long.MIN_VALUE) {
                this.hi -= 0x80000000L;
            } else {
                long temp = (value ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
                this.hi -= temp >> 32;
                this.lo -= temp & 0xFFFFFFFFL;
            }
        }
    }

    BigInteger getLongSum() throws HsqlException {
        BigInteger biglo = BigInteger.valueOf(this.lo);
        BigInteger bighi = BigInteger.valueOf(this.hi);
        BigInteger result = bighi.multiply(multiplier).add(biglo);
        return result;
    }

    private void addDataPoint(Number x) {
        if (x == null) {
            return;
        }
        double xi = x.doubleValue();
        if (!this.initialized) {
            this.n = 1L;
            this.sk = xi;
            this.vk = 0.0;
            this.initialized = true;
            return;
        }
        ++this.n;
        long nm1 = this.n - 1L;
        double xsi = this.sk - xi * (double)nm1;
        this.vk += xsi * xsi / (double)this.n / (double)nm1;
        this.sk += xi;
    }

    private Number getVariance() {
        if (!this.initialized) {
            return null;
        }
        return this.sample ? (this.n == 1L ? null : new Double(this.vk / (double)(this.n - 1L))) : new Double(this.vk / (double)this.n);
    }

    private Number getStdDev() {
        if (!this.initialized) {
            return null;
        }
        return this.sample ? (this.n == 1L ? null : new Double(Math.sqrt(this.vk / (double)(this.n - 1L)))) : new Double(Math.sqrt(this.vk / (double)this.n));
    }
}

