/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class RowRecord
extends Record
implements Comparable {
    public static final short sid = 520;
    private static final int OPTION_BITS_ALWAYS_SET = 256;
    private static final int DEFAULT_HEIGHT_BIT = 32768;
    public static final int MAX_ROW_NUMBER = 65535;
    private int field_1_row_number;
    private short field_2_first_col;
    private short field_3_last_col;
    private short field_4_height;
    private short field_5_optimize;
    private short field_6_reserved;
    private int field_7_option_flags;
    private static final BitField outlineLevel = BitFieldFactory.getInstance(7);
    private static final BitField colapsed = BitFieldFactory.getInstance(16);
    private static final BitField zeroHeight = BitFieldFactory.getInstance(32);
    private static final BitField badFontHeight = BitFieldFactory.getInstance(64);
    private static final BitField formatted = BitFieldFactory.getInstance(128);
    private short field_8_xf_index;

    public RowRecord(int rowNumber) {
        this.field_1_row_number = rowNumber;
        this.field_2_first_col = (short)-1;
        this.field_3_last_col = (short)-1;
        this.field_4_height = Short.MIN_VALUE;
        this.field_4_height = Short.MIN_VALUE;
        this.field_5_optimize = 0;
        this.field_6_reserved = 0;
        this.field_7_option_flags = 256;
        this.field_8_xf_index = (short)15;
    }

    public RowRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 520) {
            throw new RecordFormatException("NOT A valid ROW RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_row_number = in.readUShort();
        this.field_2_first_col = in.readShort();
        this.field_3_last_col = in.readShort();
        this.field_4_height = in.readShort();
        this.field_5_optimize = in.readShort();
        this.field_6_reserved = in.readShort();
        this.field_7_option_flags = in.readShort();
        this.field_8_xf_index = in.readShort();
    }

    public void setRowNumber(int row) {
        this.field_1_row_number = row;
    }

    public void setFirstCol(short col) {
        this.field_2_first_col = col;
    }

    public void setLastCol(short col) {
        this.field_3_last_col = col;
    }

    public void setHeight(short height) {
        this.field_4_height = height;
    }

    public void setOptimize(short optimize) {
        this.field_5_optimize = optimize;
    }

    public void setOptionFlags(short options) {
        this.field_7_option_flags = options | 0x100;
    }

    public void setOutlineLevel(short ol) {
        this.field_7_option_flags = outlineLevel.setValue(this.field_7_option_flags, ol);
    }

    public void setColapsed(boolean c) {
        this.field_7_option_flags = colapsed.setBoolean(this.field_7_option_flags, c);
    }

    public void setZeroHeight(boolean z) {
        this.field_7_option_flags = zeroHeight.setBoolean(this.field_7_option_flags, z);
    }

    public void setBadFontHeight(boolean f) {
        this.field_7_option_flags = badFontHeight.setBoolean(this.field_7_option_flags, f);
    }

    public void setFormatted(boolean f) {
        this.field_7_option_flags = formatted.setBoolean(this.field_7_option_flags, f);
    }

    public void setXFIndex(short index) {
        this.field_8_xf_index = index;
    }

    public int getRowNumber() {
        return this.field_1_row_number;
    }

    public short getFirstCol() {
        return this.field_2_first_col;
    }

    public short getLastCol() {
        return this.field_3_last_col;
    }

    public short getHeight() {
        return this.field_4_height;
    }

    public short getOptimize() {
        return this.field_5_optimize;
    }

    public short getOptionFlags() {
        return (short)this.field_7_option_flags;
    }

    public short getOutlineLevel() {
        return (short)outlineLevel.getValue(this.field_7_option_flags);
    }

    public boolean getColapsed() {
        return colapsed.isSet(this.field_7_option_flags);
    }

    public boolean getZeroHeight() {
        return zeroHeight.isSet(this.field_7_option_flags);
    }

    public boolean getBadFontHeight() {
        return badFontHeight.isSet(this.field_7_option_flags);
    }

    public boolean getFormatted() {
        return formatted.isSet(this.field_7_option_flags);
    }

    public short getXFIndex() {
        return this.field_8_xf_index;
    }

    public boolean isInValueSection() {
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[ROW]\n");
        buffer.append("    .rownumber      = ").append(Integer.toHexString(this.getRowNumber())).append("\n");
        buffer.append("    .firstcol       = ").append(Integer.toHexString(this.getFirstCol())).append("\n");
        buffer.append("    .lastcol        = ").append(Integer.toHexString(this.getLastCol())).append("\n");
        buffer.append("    .height         = ").append(Integer.toHexString(this.getHeight())).append("\n");
        buffer.append("    .optimize       = ").append(Integer.toHexString(this.getOptimize())).append("\n");
        buffer.append("    .reserved       = ").append(Integer.toHexString(this.field_6_reserved)).append("\n");
        buffer.append("    .optionflags    = ").append(Integer.toHexString(this.getOptionFlags())).append("\n");
        buffer.append("        .outlinelvl = ").append(Integer.toHexString(this.getOutlineLevel())).append("\n");
        buffer.append("        .colapsed   = ").append(this.getColapsed()).append("\n");
        buffer.append("        .zeroheight = ").append(this.getZeroHeight()).append("\n");
        buffer.append("        .badfontheig= ").append(this.getBadFontHeight()).append("\n");
        buffer.append("        .formatted  = ").append(this.getFormatted()).append("\n");
        buffer.append("    .xfindex        = ").append(Integer.toHexString(this.getXFIndex())).append("\n");
        buffer.append("[/ROW]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)520);
        LittleEndian.putShort(data, 2 + offset, (short)16);
        LittleEndian.putShort(data, 4 + offset, (short)this.getRowNumber());
        LittleEndian.putShort(data, 6 + offset, this.getFirstCol() == -1 ? (short)0 : this.getFirstCol());
        LittleEndian.putShort(data, 8 + offset, this.getLastCol() == -1 ? (short)0 : this.getLastCol());
        LittleEndian.putShort(data, 10 + offset, this.getHeight());
        LittleEndian.putShort(data, 12 + offset, this.getOptimize());
        LittleEndian.putShort(data, 14 + offset, this.field_6_reserved);
        LittleEndian.putShort(data, 16 + offset, this.getOptionFlags());
        LittleEndian.putShort(data, 18 + offset, this.getXFIndex());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 20;
    }

    public short getSid() {
        return 520;
    }

    public int compareTo(Object obj) {
        RowRecord loc = (RowRecord)obj;
        if (this.getRowNumber() == loc.getRowNumber()) {
            return 0;
        }
        if (this.getRowNumber() < loc.getRowNumber()) {
            return -1;
        }
        if (this.getRowNumber() > loc.getRowNumber()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RowRecord)) {
            return false;
        }
        RowRecord loc = (RowRecord)obj;
        return this.getRowNumber() == loc.getRowNumber();
    }

    public Object clone() {
        RowRecord rec = new RowRecord(this.field_1_row_number);
        rec.field_2_first_col = this.field_2_first_col;
        rec.field_3_last_col = this.field_3_last_col;
        rec.field_4_height = this.field_4_height;
        rec.field_5_optimize = this.field_5_optimize;
        rec.field_6_reserved = this.field_6_reserved;
        rec.field_7_option_flags = this.field_7_option_flags;
        rec.field_8_xf_index = this.field_8_xf_index;
        return rec;
    }
}

