/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.ddf;

import com.fr.third.org.apache.poi.ddf.EscherBlipRecord;
import com.fr.third.org.apache.poi.ddf.EscherRecordFactory;
import com.fr.third.org.apache.poi.ddf.EscherSerializationListener;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;
import com.fr.third.org.apache.poi.util.POILogFactory;
import com.fr.third.org.apache.poi.util.POILogger;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.InflaterInputStream;

public class EscherMetafileBlip
extends EscherBlipRecord {
    private static final POILogger log = POILogFactory.getLogger(EscherMetafileBlip.class);
    public static final short RECORD_ID_EMF = -4070;
    public static final short RECORD_ID_WMF = -4069;
    public static final short RECORD_ID_PICT = -4068;
    public static final short SIGNATURE_EMF = 15680;
    public static final short SIGNATURE_WMF = 8544;
    public static final short SIGNATURE_PICT = 21536;
    private static final int HEADER_SIZE = 8;
    private byte[] field_1_UID;
    private byte[] field_2_UID;
    private int field_2_cb;
    private int field_3_rcBounds_x1;
    private int field_3_rcBounds_y1;
    private int field_3_rcBounds_x2;
    private int field_3_rcBounds_y2;
    private int field_4_ptSize_w;
    private int field_4_ptSize_h;
    private int field_5_cbSave;
    private byte field_6_fCompression;
    private byte field_7_fFilter;
    private byte[] raw_pictureData;

    public int fillFields(byte[] data, int offset, EscherRecordFactory recordFactory) {
        int bytesAfterHeader = this.readHeader(data, offset);
        int pos = offset + 8;
        this.field_1_UID = new byte[16];
        System.arraycopy(data, pos, this.field_1_UID, 0, 16);
        pos += 16;
        if ((this.getOptions() ^ this.getSignature()) == 16) {
            this.field_2_UID = new byte[16];
            System.arraycopy(data, pos, this.field_2_UID, 0, 16);
            pos += 16;
        }
        this.field_2_cb = LittleEndian.getInt(data, pos);
        this.field_3_rcBounds_x1 = LittleEndian.getInt(data, pos += 4);
        this.field_3_rcBounds_y1 = LittleEndian.getInt(data, pos += 4);
        this.field_3_rcBounds_x2 = LittleEndian.getInt(data, pos += 4);
        this.field_3_rcBounds_y2 = LittleEndian.getInt(data, pos += 4);
        this.field_4_ptSize_w = LittleEndian.getInt(data, pos += 4);
        this.field_4_ptSize_h = LittleEndian.getInt(data, pos += 4);
        this.field_5_cbSave = LittleEndian.getInt(data, pos += 4);
        this.field_6_fCompression = data[pos += 4];
        this.field_7_fFilter = data[++pos];
        this.raw_pictureData = new byte[this.field_5_cbSave];
        System.arraycopy(data, ++pos, this.raw_pictureData, 0, this.field_5_cbSave);
        this.field_pictureData = this.field_6_fCompression == 0 ? EscherMetafileBlip.inflatePictureData(this.raw_pictureData) : this.raw_pictureData;
        return bytesAfterHeader + 8;
    }

    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        listener.beforeRecordSerialize(offset, this.getRecordId(), this);
        int pos = offset;
        LittleEndian.putShort(data, pos, this.getOptions());
        LittleEndian.putShort(data, pos += 2, this.getRecordId());
        LittleEndian.putInt(data, pos += 2, this.getRecordSize() - 8);
        System.arraycopy(this.field_1_UID, 0, data, pos += 4, this.field_1_UID.length);
        pos += this.field_1_UID.length;
        if ((this.getOptions() ^ this.getSignature()) == 16) {
            System.arraycopy(this.field_2_UID, 0, data, pos, this.field_2_UID.length);
            pos += this.field_2_UID.length;
        }
        LittleEndian.putInt(data, pos, this.field_2_cb);
        LittleEndian.putInt(data, pos += 4, this.field_3_rcBounds_x1);
        LittleEndian.putInt(data, pos += 4, this.field_3_rcBounds_y1);
        LittleEndian.putInt(data, pos += 4, this.field_3_rcBounds_x2);
        LittleEndian.putInt(data, pos += 4, this.field_3_rcBounds_y2);
        LittleEndian.putInt(data, pos += 4, this.field_4_ptSize_w);
        LittleEndian.putInt(data, pos += 4, this.field_4_ptSize_h);
        LittleEndian.putInt(data, pos += 4, this.field_5_cbSave);
        data[pos += 4] = this.field_6_fCompression;
        data[++pos] = this.field_7_fFilter;
        System.arraycopy(this.raw_pictureData, 0, data, ++pos, this.raw_pictureData.length);
        listener.afterRecordSerialize(offset + this.getRecordSize(), this.getRecordId(), this.getRecordSize(), this);
        return this.getRecordSize();
    }

    private static byte[] inflatePictureData(byte[] data) {
        try {
            int readBytes;
            InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(data));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((readBytes = in.read(buf)) > 0) {
                out.write(buf, 0, readBytes);
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            log.log(5, (Object)"Possibly corrupt compression or non-compressed data", e);
            return data;
        }
    }

    public int getRecordSize() {
        int size = 58 + this.raw_pictureData.length;
        if ((this.getOptions() ^ this.getSignature()) == 16) {
            size += this.field_2_UID.length;
        }
        return size;
    }

    public byte[] getUID() {
        return this.field_1_UID;
    }

    public void setUID(byte[] field_1_UID) {
        this.field_1_UID = field_1_UID;
    }

    public byte[] getPrimaryUID() {
        return this.field_2_UID;
    }

    public void setPrimaryUID(byte[] field_2_UID) {
        this.field_2_UID = field_2_UID;
    }

    public int getUncompressedSize() {
        return this.field_2_cb;
    }

    public void setUncompressedSize(int uncompressedSize) {
        this.field_2_cb = uncompressedSize;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.field_3_rcBounds_x1, this.field_3_rcBounds_y1, this.field_3_rcBounds_x2 - this.field_3_rcBounds_x1, this.field_3_rcBounds_y2 - this.field_3_rcBounds_y1);
    }

    public void setBounds(Rectangle bounds) {
        this.field_3_rcBounds_x1 = bounds.x;
        this.field_3_rcBounds_y1 = bounds.y;
        this.field_3_rcBounds_x2 = bounds.x + bounds.width;
        this.field_3_rcBounds_y2 = bounds.y + bounds.height;
    }

    public Dimension getSizeEMU() {
        return new Dimension(this.field_4_ptSize_w, this.field_4_ptSize_h);
    }

    public void setSizeEMU(Dimension sizeEMU) {
        this.field_4_ptSize_w = sizeEMU.width;
        this.field_4_ptSize_h = sizeEMU.height;
    }

    public int getCompressedSize() {
        return this.field_5_cbSave;
    }

    public void setCompressedSize(int compressedSize) {
        this.field_5_cbSave = compressedSize;
    }

    public boolean isCompressed() {
        return this.field_6_fCompression == 0;
    }

    public void setCompressed(boolean compressed) {
        this.field_6_fCompression = (byte)(compressed ? 0 : -2);
    }

    public String toString() {
        String extraData;
        String nl = System.getProperty("line.separator");
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            HexDump.dump(this.field_pictureData, 0L, b, 0);
            extraData = b.toString();
        }
        catch (Exception e) {
            extraData = e.toString();
        }
        return this.getClass().getName() + ":" + nl + "  RecordId: 0x" + HexDump.toHex(this.getRecordId()) + nl + "  Options: 0x" + HexDump.toHex(this.getOptions()) + nl + "  UID: 0x" + HexDump.toHex(this.field_1_UID) + nl + (this.field_2_UID == null ? "" : "  UID2: 0x" + HexDump.toHex(this.field_2_UID) + nl) + "  Uncompressed Size: " + HexDump.toHex(this.field_2_cb) + nl + "  Bounds: " + this.getBounds() + nl + "  Size in EMU: " + this.getSizeEMU() + nl + "  Compressed Size: " + HexDump.toHex(this.field_5_cbSave) + nl + "  Compression: " + HexDump.toHex(this.field_6_fCompression) + nl + "  Filter: " + HexDump.toHex(this.field_7_fFilter) + nl + "  Extra Data:" + nl + extraData;
    }

    public short getSignature() {
        short sig = 0;
        switch (this.getRecordId()) {
            case -4070: {
                sig = 15680;
                break;
            }
            case -4069: {
                sig = 8544;
                break;
            }
            case -4068: {
                sig = 21536;
                break;
            }
            default: {
                log.log(5, "Unknown metafile: " + this.getRecordId());
            }
        }
        return sig;
    }
}

