/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.layout.renderer;

import com.fr.third.fr.pdf.kernel.pdf.tagutils.TagTreePointer;
import com.fr.third.fr.pdf.layout.Canvas;
import com.fr.third.fr.pdf.layout.layout.LayoutArea;
import com.fr.third.fr.pdf.layout.layout.LayoutResult;
import com.fr.third.fr.pdf.layout.renderer.DrawContext;
import com.fr.third.fr.pdf.layout.renderer.IRenderer;
import com.fr.third.fr.pdf.layout.renderer.RootRenderer;

public class CanvasRenderer
extends RootRenderer {
    protected Canvas canvas;

    public CanvasRenderer(Canvas canvas) {
        this(canvas, true);
    }

    public CanvasRenderer(Canvas canvas, boolean immediateFlush) {
        this.canvas = canvas;
        this.modelElement = canvas;
        this.immediateFlush = immediateFlush;
    }

    protected void flushSingleRenderer(IRenderer resultRenderer) {
        if (!resultRenderer.isFlushed()) {
            boolean toTag = this.canvas.getPdfDocument().isTagged() && this.canvas.isAutoTaggingEnabled();
            TagTreePointer tagPointer = null;
            if (toTag) {
                tagPointer = this.canvas.getPdfDocument().getTagStructureContext().getAutoTaggingPointer();
                tagPointer.setPageForTagging(this.canvas.getPage());
                tagPointer.setContentStreamForTagging(this.canvas.getPdfCanvas().getContentStream());
            }
            resultRenderer.draw(new DrawContext(this.canvas.getPdfDocument(), this.canvas.getPdfCanvas(), toTag));
            if (toTag) {
                tagPointer.setContentStreamForTagging(null);
            }
        }
    }

    protected LayoutArea updateCurrentArea(LayoutResult overflowResult) {
        if (this.currentArea == null) {
            this.currentArea = new LayoutArea(0, this.canvas.getRootArea().clone());
        } else {
            this.setProperty(25, true);
            this.currentArea = null;
        }
        return this.currentArea;
    }

    public IRenderer getNextRenderer() {
        return null;
    }
}

