/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.layout.element;

import com.fr.third.fr.pdf.io.image.ImageData;
import com.fr.third.fr.pdf.kernel.PdfException;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.canvas.wmf.WmfImageData;
import com.fr.third.fr.pdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.fr.third.fr.pdf.kernel.pdf.tagutils.IAccessibleElement;
import com.fr.third.fr.pdf.kernel.pdf.xobject.PdfFormXObject;
import com.fr.third.fr.pdf.kernel.pdf.xobject.PdfImageXObject;
import com.fr.third.fr.pdf.kernel.pdf.xobject.PdfXObject;
import com.fr.third.fr.pdf.layout.element.AbstractElement;
import com.fr.third.fr.pdf.layout.element.ILeafElement;
import com.fr.third.fr.pdf.layout.renderer.IRenderer;
import com.fr.third.fr.pdf.layout.renderer.ImageRenderer;
import com.fr.third.fr.pdf.slf4j.Logger;
import com.fr.third.fr.pdf.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Image
extends AbstractElement<Image>
implements ILeafElement,
IAccessibleElement {
    protected PdfXObject xObject;
    protected PdfName role = PdfName.Figure;
    protected AccessibilityProperties tagProperties;
    private static Float DefaultScale = Float.valueOf(1.0f);

    public Image(PdfImageXObject xObject) {
        this.xObject = xObject;
    }

    public Image(PdfFormXObject xObject) {
        this.xObject = xObject;
    }

    public Image(PdfImageXObject xObject, float width) {
        this.xObject = xObject;
        this.setWidth(width);
    }

    public Image(PdfImageXObject xObject, float x, float y, float width) {
        this.xObject = xObject;
        this.setFloatProperty(79, x);
        this.setFloatProperty(80, y);
        this.setWidth(width);
        this.setProperty(52, 4);
    }

    public Image(PdfImageXObject xObject, float x, float y) {
        this.xObject = xObject;
        this.setFloatProperty(79, x);
        this.setFloatProperty(80, y);
        this.setProperty(52, 4);
    }

    public Image(PdfFormXObject xObject, float x, float y) {
        this.xObject = xObject;
        this.setFloatProperty(79, x);
        this.setFloatProperty(80, y);
        this.setProperty(52, 4);
    }

    public Image(ImageData img) {
        this(new PdfImageXObject(Image.checkImageType(img)));
        this.setProperty(19, true);
    }

    public Image(ImageData img, float x, float y) {
        this(new PdfImageXObject(Image.checkImageType(img)), x, y);
        this.setProperty(19, true);
    }

    public Image(ImageData img, float x, float y, float width) {
        this(new PdfImageXObject(Image.checkImageType(img)), x, y, width);
        this.setProperty(19, true);
    }

    public PdfXObject getXObject() {
        return this.xObject;
    }

    public Image setRotationAngle(double radAngle) {
        this.setFloatProperty(55, (float)radAngle);
        return this;
    }

    public float getMarginLeft() {
        return this.getFloatProperty(44);
    }

    public Image setMarginLeft(float value) {
        this.setFloatProperty(44, value);
        return this;
    }

    public Float getMarginRight() {
        return Float.valueOf(this.getFloatProperty(45));
    }

    public Image setMarginRight(float value) {
        this.setFloatProperty(45, value);
        return this;
    }

    public float getMarginTop() {
        return this.getFloatProperty(46);
    }

    public Image setMarginTop(float value) {
        this.setFloatProperty(46, value);
        return this;
    }

    public float getMarginBottom() {
        return this.getFloatProperty(43);
    }

    public Image setMarginBottom(float value) {
        this.setFloatProperty(43, value);
        return this;
    }

    public Image setMargins(float marginTop, float marginRight, float marginBottom, float marginLeft) {
        return this.setMarginTop(marginTop).setMarginRight(marginRight).setMarginBottom(marginBottom).setMarginLeft(marginLeft);
    }

    public Image scale(float horizontalScaling, float verticalScaling) {
        this.setFloatProperty(29, horizontalScaling);
        this.setFloatProperty(76, verticalScaling);
        return this;
    }

    public Image scaleToFit(float fitWidth, float fitHeight) {
        float horizontalScaling = fitWidth / this.xObject.getWidth();
        float verticalScaling = fitHeight / this.xObject.getHeight();
        return this.scale(Math.min(horizontalScaling, verticalScaling), Math.min(horizontalScaling, verticalScaling));
    }

    public Image scaleAbsolute(float fitWidth, float fitHeight) {
        float horizontalScaling = fitWidth / this.xObject.getWidth();
        float verticalScaling = fitHeight / this.xObject.getHeight();
        return this.scale(horizontalScaling, verticalScaling);
    }

    public Image setAutoScale(boolean autoScale) {
        if (this.hasProperty(5) && this.hasProperty(4) && autoScale && (((Boolean)this.getProperty(5)).booleanValue() || ((Boolean)this.getProperty(4)).booleanValue())) {
            Logger logger = LoggerFactory.getLogger(Image.class);
            logger.warn("The image cannot be auto scaled and scaled by a certain parameter simultaneously");
        }
        this.setProperty(3, autoScale);
        return this;
    }

    public Image setAutoScaleHeight(boolean autoScale) {
        if (this.hasProperty(5) && autoScale && ((Boolean)this.getProperty(5)).booleanValue()) {
            this.setProperty(5, false);
            this.setProperty(4, false);
            this.setProperty(3, true);
        } else {
            this.setProperty(5, autoScale);
        }
        return this;
    }

    public Image setAutoScaleWidth(boolean autoScale) {
        if (this.hasProperty(4) && autoScale && ((Boolean)this.getProperty(4)).booleanValue()) {
            this.setProperty(5, false);
            this.setProperty(4, false);
            this.setProperty(3, true);
        } else {
            this.setProperty(5, autoScale);
        }
        return this;
    }

    public Image setFixedPosition(float x, float y) {
        this.setFixedPosition(x, y, this.getWidth());
        return this;
    }

    public Image setFixedPosition(int pageNumber, float x, float y) {
        this.setFixedPosition(pageNumber, x, y, this.getWidth());
        return this;
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        switch (property) {
            case 3: {
                return (T1)Boolean.FALSE;
            }
            case 29: 
            case 76: {
                return (T1)DefaultScale;
            }
        }
        return super.getDefaultProperty(property);
    }

    @Override
    public float getDefaultFloatProperty(int property) {
        switch (property) {
            case 29: 
            case 76: {
                return 1.0f;
            }
        }
        return ((Float)super.getDefaultProperty(property)).floatValue();
    }

    public float getImageWidth() {
        return this.xObject.getWidth();
    }

    public float getImageHeight() {
        return this.xObject.getHeight();
    }

    public float getImageScaledWidth() {
        return 0.0f == this.getFloatProperty(29) ? this.xObject.getWidth() : this.xObject.getWidth() * this.getFloatProperty(29);
    }

    public float getImageScaledHeight() {
        return 0.0f == this.getFloatProperty(76) ? this.xObject.getHeight() : this.xObject.getHeight() * this.getFloatProperty(76);
    }

    @Override
    public PdfName getRole() {
        return this.role;
    }

    @Override
    public void setRole(PdfName role) {
        this.role = role;
    }

    @Override
    public AccessibilityProperties getAccessibilityProperties() {
        if (this.tagProperties == null) {
            this.tagProperties = new AccessibilityProperties();
        }
        return this.tagProperties;
    }

    @Override
    protected IRenderer makeNewRenderer() {
        return new ImageRenderer(this);
    }

    private static ImageData checkImageType(ImageData image) {
        if (image instanceof WmfImageData) {
            throw new PdfException("Cannot create layout image by WmfImage instance. First convert the image into FormXObject and then use the corresponding layout image constructor");
        }
        return image;
    }
}

