/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf;

import com.fr.third.fr.pdf.kernel.color.Color;
import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import com.fr.third.fr.pdf.kernel.pdf.action.PdfAction;
import com.fr.third.fr.pdf.kernel.pdf.navigation.PdfDestination;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfOutline {
    public static int FLAG_ITALIC = 1;
    public static int FLAG_BOLD = 2;
    private List<PdfOutline> children = new ArrayList<PdfOutline>();
    private String title;
    private PdfDictionary content;
    private PdfDestination destination;
    private PdfOutline parent;
    private PdfDocument pdfDoc;

    public PdfOutline(String title, PdfDictionary content, PdfDocument pdfDocument) {
        this.title = title;
        this.content = content;
        this.pdfDoc = pdfDocument;
    }

    public PdfOutline(String title, PdfDictionary content, PdfOutline parent) {
        this.title = title;
        this.content = content;
        this.parent = parent;
        this.pdfDoc = parent.pdfDoc;
        content.makeIndirect(parent.pdfDoc);
    }

    protected PdfOutline(PdfDocument doc) {
        this.content = new PdfDictionary();
        this.content.put(PdfName.Type, PdfName.Outlines);
        this.pdfDoc = doc;
        this.content.makeIndirect(doc);
        doc.getCatalog().addRootOutline(this);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.content.put(PdfName.Title, new PdfString(title, "UnicodeBig"));
    }

    public void setColor(Color color) {
        this.content.put(PdfName.C, new PdfArray(color.getColorValue()));
    }

    public void setStyle(int style) {
        if (style == FLAG_BOLD || style == FLAG_ITALIC) {
            this.content.put(PdfName.F, new PdfNumber(style));
        }
    }

    public PdfDictionary getContent() {
        return this.content;
    }

    public List<PdfOutline> getAllChildren() {
        return this.children;
    }

    public PdfOutline getParent() {
        return this.parent;
    }

    public PdfDestination getDestination() {
        return this.destination;
    }

    public void addDestination(PdfDestination destination) {
        this.setDestination(destination);
        this.content.put(PdfName.Dest, (PdfObject)destination.getPdfObject());
    }

    public void addAction(PdfAction action) {
        this.content.put(PdfName.A, (PdfObject)action.getPdfObject());
    }

    public PdfOutline addOutline(String title) {
        return this.addOutline(title, -1);
    }

    public PdfOutline addOutline(String title, int position) {
        if (position == -1) {
            position = this.children.size();
        }
        PdfDictionary dictionary = new PdfDictionary();
        PdfOutline outline = new PdfOutline(title, dictionary, this);
        dictionary.put(PdfName.Title, new PdfString(title, "UnicodeBig"));
        dictionary.put(PdfName.Parent, this.content);
        if (!this.children.isEmpty()) {
            if (position != 0) {
                PdfDictionary prevContent = this.children.get(position - 1).getContent();
                dictionary.put(PdfName.Prev, prevContent);
                prevContent.put(PdfName.Next, dictionary);
            }
            if (position != this.children.size()) {
                PdfDictionary nextContent = this.children.get(position).getContent();
                dictionary.put(PdfName.Next, nextContent);
                nextContent.put(PdfName.Prev, dictionary);
            }
        }
        if (position == 0) {
            this.content.put(PdfName.First, dictionary);
        }
        if (position == this.children.size()) {
            this.content.put(PdfName.Last, dictionary);
        }
        if (this.children.size() > 0) {
            int count = this.content.getAsInt(PdfName.Count);
            if (count > 0) {
                this.content.put(PdfName.Count, new PdfNumber(count++));
            } else {
                this.content.put(PdfName.Count, new PdfNumber(count--));
            }
        } else {
            this.content.put(PdfName.Count, new PdfNumber(-1));
        }
        this.children.add(position, outline);
        return outline;
    }

    void clear() {
        this.children.clear();
    }

    void setDestination(PdfDestination destination) {
        this.destination = destination;
    }

    void removeOutline() {
        PdfName type = this.content.getAsName(PdfName.Type);
        if (type != null && type.equals(PdfName.Outlines)) {
            this.pdfDoc.getCatalog().remove(PdfName.Outlines);
            return;
        }
        PdfOutline parent = this.parent;
        List<PdfOutline> children = parent.children;
        children.remove(this);
        PdfDictionary parentContent = parent.content;
        if (children.isEmpty()) {
            parent.removeOutline();
            return;
        }
        parentContent.put(PdfName.First, children.get((int)0).content);
        parentContent.put(PdfName.Last, children.get((int)(children.size() - 1)).content);
        PdfDictionary next = this.content.getAsDictionary(PdfName.Next);
        PdfDictionary prev = this.content.getAsDictionary(PdfName.Prev);
        if (prev != null) {
            if (next != null) {
                prev.put(PdfName.Next, next);
                next.put(PdfName.Prev, prev);
            } else {
                prev.remove(PdfName.Next);
            }
        } else if (next != null) {
            next.remove(PdfName.Prev);
        }
    }

    public PdfOutline addOutline(PdfOutline outline) {
        PdfOutline newOutline = this.addOutline(outline.getTitle());
        newOutline.addDestination(outline.getDestination());
        List<PdfOutline> children = outline.getAllChildren();
        for (PdfOutline child : children) {
            newOutline.addOutline(child);
        }
        return newOutline;
    }
}

