/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.font;

import com.fr.third.fr.pdf.io.font.FontConstants;
import com.fr.third.fr.pdf.io.font.FontProgram;
import com.fr.third.fr.pdf.io.font.otf.Glyph;
import com.fr.third.fr.pdf.io.font.otf.GlyphLine;
import com.fr.third.fr.pdf.io.util.TextUtil;
import com.fr.third.fr.pdf.kernel.PdfException;
import com.fr.third.fr.pdf.kernel.font.PdfFontFactory;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.pdf.PdfObjectWrapper;
import com.fr.third.fr.pdf.kernel.pdf.PdfOutputStream;
import com.fr.third.fr.pdf.kernel.pdf.PdfStream;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PdfFont
extends PdfObjectWrapper<PdfDictionary> {
    private static final long serialVersionUID = -7661159455613720321L;
    protected FontProgram fontProgram;
    protected static final byte[] emptyBytes = new byte[0];
    protected Map<Integer, Glyph> notdefGlyphs = new HashMap<Integer, Glyph>();
    protected boolean newFont = true;
    protected boolean embedded = false;
    protected boolean subset = true;
    protected List<int[]> subsetRanges;
    private int hashCode = super.hashCode();

    public int hashCode() {
        return this.hashCode;
    }

    protected PdfFont(PdfDictionary fontDictionary) {
        super(fontDictionary);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.Font);
    }

    protected PdfFont() {
        super(new PdfDictionary());
        PdfFont.markObjectAsIndirect(this.getPdfObject());
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.Font);
    }

    public abstract Glyph getGlyph(int var1);

    public boolean containsGlyph(char unicode) {
        Glyph glyph = this.getGlyph(unicode);
        if (glyph != null) {
            if (this.getFontProgram() != null && this.getFontProgram().isFontSpecific()) {
                return glyph.getCode() > -1;
            }
            return glyph.getCode() > 0;
        }
        return false;
    }

    public abstract GlyphLine createGlyphLine(String var1);

    public abstract byte[] convertToBytes(String var1);

    public abstract byte[] convertToBytes(GlyphLine var1);

    public abstract String decode(PdfString var1);

    public abstract float getContentWidth(PdfString var1);

    public abstract byte[] convertToBytes(Glyph var1);

    public abstract void writeText(GlyphLine var1, int var2, int var3, PdfOutputStream var4);

    public abstract void writeText(String var1, PdfOutputStream var2);

    public void writeText(GlyphLine text, PdfOutputStream stream) {
        this.writeText(text, 0, text.size() - 1, stream);
    }

    public double[] getFontMatrix() {
        return FontConstants.DefaultFontMatrix;
    }

    public int getWidth(int unicode) {
        Glyph glyph = this.getGlyph(unicode);
        return glyph != null ? glyph.getWidth() : 0;
    }

    public float getWidth(int unicode, float fontSize) {
        return (float)this.getWidth(unicode) * fontSize / 1000.0f;
    }

    public int getWidth(String text) {
        int total = 0;
        for (int i = 0; i < text.length(); ++i) {
            int ch;
            if (TextUtil.isSurrogatePair(text, i)) {
                ch = TextUtil.convertToUtf32(text, i);
                ++i;
            } else {
                ch = text.charAt(i);
            }
            Glyph glyph = this.getGlyph(ch);
            if (glyph == null) continue;
            total += glyph.getWidth();
        }
        return total;
    }

    public float getWidth(String text, float fontSize) {
        return (float)this.getWidth(text) * fontSize / 1000.0f;
    }

    public int getDescent(String text, float fontSize) {
        int min = 0;
        for (int k = 0; k < text.length(); ++k) {
            int ch;
            if (TextUtil.isSurrogatePair(text, k)) {
                ch = TextUtil.convertToUtf32(text, k);
                ++k;
            } else {
                ch = text.charAt(k);
            }
            int[] bbox = this.getGlyph(ch).getBbox();
            if (bbox != null && bbox[1] < min) {
                min = bbox[1];
                continue;
            }
            if (bbox != null || this.getFontProgram().getFontMetrics().getTypoDescender() >= min) continue;
            min = this.getFontProgram().getFontMetrics().getTypoDescender();
        }
        return (int)((float)min * fontSize / 1000.0f);
    }

    public int getDescent(int unicode, float fontSize) {
        int min = 0;
        int[] bbox = this.getGlyph(unicode).getBbox();
        if (bbox != null && bbox[1] < min) {
            min = bbox[1];
        } else if (bbox == null && this.getFontProgram().getFontMetrics().getTypoDescender() < min) {
            min = this.getFontProgram().getFontMetrics().getTypoDescender();
        }
        return (int)((float)min * fontSize / 1000.0f);
    }

    public int getAscent(String text, float fontSize) {
        int max = 0;
        for (int k = 0; k < text.length(); ++k) {
            int ch;
            if (TextUtil.isSurrogatePair(text, k)) {
                ch = TextUtil.convertToUtf32(text, k);
                ++k;
            } else {
                ch = text.charAt(k);
            }
            int[] bbox = this.getGlyph(ch).getBbox();
            if (bbox != null && bbox[3] > max) {
                max = bbox[3];
                continue;
            }
            if (bbox != null || this.getFontProgram().getFontMetrics().getTypoAscender() <= max) continue;
            max = this.getFontProgram().getFontMetrics().getTypoAscender();
        }
        return (int)((float)max * fontSize / 1000.0f);
    }

    public int getAscent(int unicode, float fontSize) {
        int max = 0;
        int[] bbox = this.getGlyph(unicode).getBbox();
        if (bbox != null && bbox[3] > max) {
            max = bbox[3];
        } else if (bbox == null && this.getFontProgram().getFontMetrics().getTypoAscender() > max) {
            max = this.getFontProgram().getFontMetrics().getTypoAscender();
        }
        return (int)((float)max * fontSize / 1000.0f);
    }

    public FontProgram getFontProgram() {
        return this.fontProgram;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public boolean isSubset() {
        return this.subset;
    }

    public void setSubset(boolean subset) {
        this.subset = subset;
    }

    public void addSubsetRange(int[] range) {
        if (this.subsetRanges == null) {
            this.subsetRanges = new ArrayList<int[]>();
        }
        this.subsetRanges.add(range);
    }

    public List<String> splitString(String text, int fontSize, float maxWidth) {
        ArrayList<String> resultString = new ArrayList<String>();
        int lastWhiteSpace = 0;
        int startPos = 0;
        float tokenLength = 0.0f;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (Character.isWhitespace(ch)) {
                lastWhiteSpace = i;
            }
            if (!((tokenLength += this.getWidth(ch, (float)fontSize)) >= maxWidth) && ch != '\n') continue;
            if (startPos < lastWhiteSpace) {
                resultString.add(text.substring(startPos, lastWhiteSpace));
                startPos = lastWhiteSpace + 1;
                tokenLength = 0.0f;
                i = lastWhiteSpace;
                continue;
            }
            resultString.add(text.substring(startPos, i + 1));
            startPos = i + 1;
            tokenLength = 0.0f;
            ++i;
        }
        resultString.add(text.substring(startPos));
        return resultString;
    }

    protected abstract PdfDictionary getFontDescriptor(String var1);

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    protected boolean checkFontDictionary(PdfDictionary fontDic, PdfName fontType) {
        return PdfFontFactory.checkFontDictionary(fontDic, fontType, true);
    }

    protected boolean checkTrueTypeFontDictionary(PdfDictionary fontDic) {
        return this.checkTrueTypeFontDictionary(fontDic, true);
    }

    protected boolean checkTrueTypeFontDictionary(PdfDictionary fontDic, boolean isException) {
        if (fontDic == null || fontDic.get(PdfName.Subtype) == null || !fontDic.get(PdfName.Subtype).equals(PdfName.TrueType) && !fontDic.get(PdfName.Subtype).equals(PdfName.Type1)) {
            if (isException) {
                throw new PdfException("dict.not.contain.font.data").setMessageParams(PdfName.TrueType.getValue());
            }
            return false;
        }
        return true;
    }

    protected static String createSubsetPrefix() {
        StringBuilder s = new StringBuilder("");
        for (int k = 0; k < 6; ++k) {
            s.append((char)(Math.random() * 26.0 + 65.0));
        }
        return s + "+";
    }

    protected PdfStream getPdfFontStream(byte[] fontStreamBytes, int[] fontStreamLengths) {
        if (fontStreamBytes == null) {
            throw new PdfException("font.embedding.issue");
        }
        PdfStream fontStream = new PdfStream(fontStreamBytes);
        for (int k = 0; k < fontStreamLengths.length; ++k) {
            fontStream.put(new PdfName("Length" + (k + 1)), new PdfNumber(fontStreamLengths[k]));
        }
        return fontStream;
    }

    protected static int[] compactRanges(List<int[]> ranges) {
        ArrayList<int[]> simp = new ArrayList<int[]>();
        for (int[] range : ranges) {
            for (int j = 0; j < range.length; j += 2) {
                simp.add(new int[]{Math.max(0, Math.min(range[j], range[j + 1])), Math.min(65535, Math.max(range[j], range[j + 1]))});
            }
        }
        for (int k1 = 0; k1 < simp.size() - 1; ++k1) {
            for (int k2 = k1 + 1; k2 < simp.size(); ++k2) {
                int[] r2;
                int[] r1 = (int[])simp.get(k1);
                if ((r1[0] < (r2 = (int[])simp.get(k2))[0] || r1[0] > r2[1]) && (r1[1] < r2[0] || r1[0] > r2[1])) continue;
                r1[0] = Math.min(r1[0], r2[0]);
                r1[1] = Math.max(r1[1], r2[1]);
                simp.remove(k2);
                --k2;
            }
        }
        int[] s = new int[simp.size() * 2];
        for (int k = 0; k < simp.size(); ++k) {
            int[] r = (int[])simp.get(k);
            s[k * 2] = r[0];
            s[k * 2 + 1] = r[1];
        }
        return s;
    }
}

