/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.io.image;

import com.fr.third.fr.pdf.io.IOException;
import com.fr.third.fr.pdf.io.codec.Jbig2SegmentReader;
import com.fr.third.fr.pdf.io.image.ImageData;
import com.fr.third.fr.pdf.io.image.ImageType;
import com.fr.third.fr.pdf.io.source.IRandomAccessSource;
import com.fr.third.fr.pdf.io.source.RandomAccessFileOrArray;
import com.fr.third.fr.pdf.io.source.RandomAccessSourceFactory;
import com.fr.third.fr.pdf.slf4j.Logger;
import com.fr.third.fr.pdf.slf4j.LoggerFactory;
import java.net.URL;

public class Jbig2ImageData
extends ImageData {
    private int page;

    protected Jbig2ImageData(URL url, int page) {
        super(url, ImageType.JBIG2);
        this.page = page;
    }

    protected Jbig2ImageData(byte[] bytes, int page) {
        super(bytes, ImageType.JBIG2);
        this.page = page;
    }

    public int getPage() {
        return this.page;
    }

    public static int getNumberOfPages(byte[] bytes) {
        IRandomAccessSource ras = new RandomAccessSourceFactory().createSource(bytes);
        return Jbig2ImageData.getNumberOfPages(new RandomAccessFileOrArray(ras));
    }

    public static int getNumberOfPages(RandomAccessFileOrArray raf) {
        try {
            Jbig2SegmentReader sr = new Jbig2SegmentReader(raf);
            sr.read();
            return sr.numberOfPages();
        }
        catch (Exception e) {
            throw new IOException("jbig2.image.exception", e);
        }
    }

    public boolean canImageBeInline() {
        Logger logger = LoggerFactory.getLogger(ImageData.class);
        logger.warn("Image cannot be inline if it has JBIG2Decode filter. It will be added as an ImageXObject");
        return false;
    }
}

