/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider.fastparser;

import cn.com.infosec.jce.provider.fastparser.DerUtil;
import cn.com.infosec.jce.provider.fastparser.Item;
import java.io.FileInputStream;
import java.util.Vector;

public class FX509CRL {
    private Item TBSCertList;
    private Item signatureAlgorithm;
    private Item signatureValue;
    private Item version;
    private Item signature;
    private Item issuer;
    private Item thisUpdate;
    private Item nextUpdate;
    private Item revokedCertificates = new Item();
    private Item crlExtensions = new Item();
    private Vector vsn = new Vector(0);
    private byte[] input = null;

    public FX509CRL() {
    }

    public FX509CRL(byte[] input, Item it) {
        this.parse(input, it.offset, it.length);
    }

    public void parse(byte[] input, int offset, int length) {
        this.input = input;
        int position = 0;
        Item tmpitem = new Item();
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset;
        tmpitem.offset += offset;
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        this.TBSCertList = new Item(tmpitem);
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.signatureAlgorithm = new Item(tmpitem);
        DerUtil.computeOffset(input, tmpitem, offset, position);
        tmpitem.offset += offset;
        this.signatureValue = new Item(tmpitem);
        position = this.TBSCertList.offset - offset;
        DerUtil.computeOffset(input, tmpitem, offset, position);
        this.version = new Item(tmpitem);
        this.version.offset += offset;
        position = tmpitem.offset + tmpitem.length;
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.signature = new Item(tmpitem);
        if (DerUtil.debug) {
            System.out.println("signature:");
            DerUtil.printItem(input, this.signature);
        }
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.issuer = new Item(tmpitem);
        if (DerUtil.debug) {
            System.out.println("issuer:");
            DerUtil.printItem(input, this.issuer);
        }
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.thisUpdate = new Item(tmpitem);
        if (DerUtil.debug) {
            System.out.println("thisUpdate:");
            DerUtil.printItem(input, this.thisUpdate);
        }
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.nextUpdate = new Item(tmpitem);
        if (DerUtil.debug) {
            System.out.println("nextUpdate:");
            DerUtil.printItem(input, this.nextUpdate);
        }
        if (position < length && (input[position] & 0xFF) != 160) {
            DerUtil.computeOffset(input, tmpitem, offset, position);
            position = tmpitem.offset + tmpitem.length;
            tmpitem.offset += offset;
            this.revokedCertificates = new Item(tmpitem);
            if (DerUtil.debug) {
                System.out.println("revokedCertificates:");
            }
            this.fetchSN(input, this.revokedCertificates.offset, this.revokedCertificates.length, this.vsn);
        }
        if (position < length && (input[position] & 0xFF) == 160) {
            DerUtil.computeOffset(input, tmpitem, offset, position);
            tmpitem.offset += offset;
            this.crlExtensions = new Item(tmpitem);
            if (DerUtil.debug) {
                System.out.println("crlExtensions:");
                DerUtil.printItem(input, this.crlExtensions);
            }
        }
    }

    public byte[] getItemData(Item item) {
        if (item == null) {
            return new byte[0];
        }
        byte[] bs = new byte[item.length];
        System.arraycopy(this.input, item.offset, bs, 0, item.length);
        return bs;
    }

    public byte[] getItemDataAndTag(Item item) {
        if (item == null) {
            return new byte[0];
        }
        byte[] bs = new byte[item.length + item.tagsize];
        System.arraycopy(this.input, item.offset - item.tagsize, bs, 0, item.length + item.tagsize);
        return bs;
    }

    private void fetchSN(byte[] input, int offset, int length, Vector vsn) {
        Item tmpitem = new Item();
        int position = 0;
        while (position < length - 2) {
            Item snitem = new Item();
            DerUtil.computeOffset(input, tmpitem, offset, position);
            DerUtil.computeOffset(input, snitem, offset, tmpitem.offset);
            position = tmpitem.offset + tmpitem.length;
            snitem.offset += offset;
            if (DerUtil.debug) {
                DerUtil.printItem(input, snitem);
            }
            vsn.add(snitem);
        }
    }

    public final Item getTBSCertList() {
        return this.TBSCertList;
    }

    public final Item getSignature() {
        return this.signature;
    }

    public final Item getIssuer() {
        return this.issuer;
    }

    public final Item getThisUpdate() {
        return this.thisUpdate;
    }

    public final Item getNextUpdate() {
        return this.nextUpdate;
    }

    public final Vector getRevokedCertificateSNs() {
        return this.vsn;
    }

    public final Item getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public final Item getSignatureValue() {
        return this.signatureValue;
    }

    static byte[] readCRL(String filename) {
        try {
            FileInputStream fis = new FileInputStream(filename);
            int size = fis.available();
            byte[] crl = new byte[size];
            fis.read(crl);
            fis.close();
            return crl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        FX509CRL fcp = new FX509CRL();
        int i = 0;
        while (i < args.length) {
            System.out.println(args[i]);
            ++i;
        }
        byte[] crl = FX509CRL.readCRL("D:/wangzongbin/PKITS_data/crls/BasicSelfIssuedOldKeySelfIssuedCertCRL.crl");
        System.out.println("\nFast:\n");
        fcp.parse(crl, 0, crl.length);
        Vector vrcsn = fcp.getRevokedCertificateSNs();
        int i2 = 0;
        while (i2 < vrcsn.size()) {
            System.out.print("SN[" + (i2 + 1) + "]=");
            Item snitem = new Item((Item)vrcsn.get(i2));
            DerUtil.printItem(crl, snitem);
            ++i2;
        }
    }
}

