/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1OutputStream;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.asn1.util.ASN1Dump;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.CRLDistPoint;
import cn.com.infosec.asn1.x509.CRLNumber;
import cn.com.infosec.asn1.x509.CertificateList;
import cn.com.infosec.asn1.x509.IssuingDistributionPoint;
import cn.com.infosec.asn1.x509.TBSCertList;
import cn.com.infosec.asn1.x509.Time;
import cn.com.infosec.asn1.x509.X509Extension;
import cn.com.infosec.asn1.x509.X509Extensions;
import cn.com.infosec.jce.X509Principal;
import cn.com.infosec.jce.provider.ExtCRLException;
import cn.com.infosec.jce.provider.RFC3280CertPathUtilities;
import cn.com.infosec.jce.provider.X509CRLEntryObject;
import cn.com.infosec.jce.provider.X509SignatureUtil;
import cn.com.infosec.jce.provider.fastparser.DerUtil;
import cn.com.infosec.jce.provider.fastparser.FX509CRL;
import cn.com.infosec.jce.provider.fastparser.Item;
import cn.com.infosec.util.encoders.Hex;
import cn.com.infosec.x509.extension.X509ExtensionUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;

public class X509CRLObjectFX
extends X509CRL {
    private CertificateList c;
    private String sigAlgName;
    private byte[] sigAlgParams;
    private boolean isIndirect;
    boolean isInvokeConstructMethod = false;
    byte[] bsCRL = null;
    FX509CRL fxCRL = null;
    HashMap hmCRLs = new HashMap();
    ArrayList vtRevokedCertSN = null;
    AlgorithmIdentifier signatureAlgorithm = null;
    AlgorithmIdentifier tbsSignatureAlgorithm = null;
    Principal issuerDN = null;
    X500Principal issuerX500Principal = null;
    Date thisUpdate = null;
    Date nextUpdate = null;
    byte[] tbsCertList = null;
    byte[] signature = null;
    String sigAlgOID = null;

    public X509CRLObjectFX(CertificateList c) throws CRLException {
        this.c = c;
        this.parseData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeConstructMethod() {
        if (this.isInvokeConstructMethod) {
            return;
        }
        X509CRLObjectFX x509CRLObjectFX = this;
        synchronized (x509CRLObjectFX) {
            if (this.isInvokeConstructMethod) {
                return;
            }
            this.isInvokeConstructMethod = true;
            if (this.bsCRL != null) {
                try {
                    CertificateList cc;
                    ASN1InputStream ais = new ASN1InputStream(new ByteArrayInputStream(this.bsCRL));
                    DERObject derObj = ais.readObject();
                    this.c = cc = CertificateList.getInstance(derObj);
                    try {
                        this.parseData();
                    }
                    catch (Exception exception) {}
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void parseData() throws CRLException {
        try {
            this.sigAlgName = X509SignatureUtil.getSignatureName(this.c.getSignatureAlgorithm());
            this.sigAlgParams = (byte[])(this.c.getSignatureAlgorithm().getParameters() != null ? ((ASN1Encodable)this.c.getSignatureAlgorithm().getParameters()).getDEREncoded() : null);
            this.isIndirect = this.isIndirectCRL();
        }
        catch (Exception e) {
            throw new CRLException("CRL contents invalid: " + e);
        }
    }

    public X509CRLObjectFX(byte[] bs) throws CRLException {
        this.bsCRL = bs;
        try {
            FX509CRL tmpCRL = new FX509CRL();
            tmpCRL.parse(bs, 0, bs.length);
            this.bsCRL = bs;
            this.fxCRL = tmpCRL;
            tmpCRL = null;
            Vector vt = this.fxCRL.getRevokedCertificateSNs();
            this.vtRevokedCertSN = new ArrayList(vt.size());
            int i = 0;
            while (i < vt.size()) {
                byte[] bsSN = DerUtil.copyByteArray(bs, (Item)vt.get(i));
                this.vtRevokedCertSN.add(new BigInteger(bsSN));
                ++i;
            }
        }
        catch (Exception e) {
            throw new CRLException("CRL contents invalid: " + e);
        }
    }

    private CertificateList getCertificateList() {
        this.invokeConstructMethod();
        if (this.c != null) {
            return this.c;
        }
        if (this.bsCRL != null) {
            try {
                ASN1InputStream ais = new ASN1InputStream(new ByteArrayInputStream(this.bsCRL));
                DERObject derObj = ais.readObject();
                CertificateList cc = CertificateList.getInstance(derObj);
                try {
                    this.parseData();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.c = cc;
                cc = null;
                return this.c;
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public boolean hasUnsupportedCriticalExtension() {
        this.invokeConstructMethod();
        Set extns = this.getCriticalExtensionOIDs();
        if (extns == null) {
            return false;
        }
        extns.remove(RFC3280CertPathUtilities.ISSUING_DISTRIBUTION_POINT);
        extns.remove(RFC3280CertPathUtilities.DELTA_CRL_INDICATOR);
        return !extns.isEmpty();
    }

    private Set getExtensionOIDs(boolean critical) {
        X509Extensions extensions;
        this.invokeConstructMethod();
        if (this.getVersion() == 2 && (extensions = this.getCertificateList().getTBSCertList().getExtensions()) != null) {
            HashSet<String> set = new HashSet<String>();
            Enumeration e = extensions.oids();
            while (e.hasMoreElements()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
                X509Extension ext = extensions.getExtension(oid);
                if (critical != ext.isCritical()) continue;
                set.add(oid.getId());
            }
            return set;
        }
        return null;
    }

    public Set getCriticalExtensionOIDs() {
        this.invokeConstructMethod();
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        this.invokeConstructMethod();
        return this.getExtensionOIDs(false);
    }

    public byte[] getExtensionValue(String oid) {
        X509Extension ext;
        this.invokeConstructMethod();
        X509Extensions exts = this.getCertificateList().getTBSCertList().getExtensions();
        if (exts != null && (ext = exts.getExtension(new DERObjectIdentifier(oid))) != null) {
            try {
                return ext.getValue().getEncoded();
            }
            catch (Exception e) {
                throw new IllegalStateException("error parsing " + e.toString());
            }
        }
        return null;
    }

    public byte[] getEncoded() throws CRLException {
        if (this.bsCRL != null) {
            return this.bsCRL;
        }
        if (this.fxCRL != null) {
            return this.bsCRL;
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        try {
            dOut.writeObject(this.c);
            return bOut.toByteArray();
        }
        catch (IOException e) {
            throw new CRLException(e.toString());
        }
    }

    public void verify(PublicKey key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(key, "INFOSEC");
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        if (this.signatureAlgorithm != null) {
            return this.signatureAlgorithm;
        }
        if (this.fxCRL != null) {
            byte[] bsData = this.fxCRL.getItemDataAndTag(this.fxCRL.getSignatureAlgorithm());
            ASN1InputStream ains = new ASN1InputStream(new ByteArrayInputStream(bsData));
            try {
                this.signatureAlgorithm = AlgorithmIdentifier.getInstance(ains.readObject());
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.signatureAlgorithm;
    }

    public AlgorithmIdentifier getTBSSignature() {
        if (this.tbsSignatureAlgorithm != null) {
            return this.tbsSignatureAlgorithm;
        }
        if (this.fxCRL != null) {
            byte[] bsData = this.fxCRL.getItemDataAndTag(this.fxCRL.getSignature());
            ASN1InputStream ains = new ASN1InputStream(new ByteArrayInputStream(bsData));
            try {
                this.tbsSignatureAlgorithm = AlgorithmIdentifier.getInstance(ains.readObject());
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.tbsSignatureAlgorithm;
    }

    public void verify(PublicKey key, String sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (this.fxCRL != null ? !this.getSignatureAlgorithm().equals(this.getTBSSignature()) : !this.getCertificateList().getSignatureAlgorithm().equals(this.getCertificateList().getTBSCertList().getSignature())) {
            throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
        }
        Signature sig = Signature.getInstance(this.getSigAlgName(), sigProvider);
        sig.initVerify(key);
        sig.update(this.getTBSCertList());
        if (!sig.verify(this.getSignature())) {
            throw new SignatureException("CRL does not verify with supplied public key.");
        }
    }

    public int getVersion() {
        this.invokeConstructMethod();
        return this.getCertificateList().getVersion();
    }

    public Principal getIssuerDN() {
        if (this.issuerDN != null) {
            return this.issuerDN;
        }
        if (this.fxCRL != null) {
            byte[] bsData = this.fxCRL.getItemDataAndTag(this.fxCRL.getIssuer());
            try {
                this.issuerDN = new X509Principal(bsData);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
            return this.issuerDN;
        }
        return new X509Principal(this.getCertificateList().getIssuer());
    }

    public X500Principal getIssuerX500Principal() {
        if (this.issuerX500Principal != null) {
            return this.issuerX500Principal;
        }
        if (this.fxCRL != null) {
            byte[] bsData = this.fxCRL.getItemDataAndTag(this.fxCRL.getIssuer());
            this.issuerX500Principal = new X500Principal(bsData);
            return this.issuerX500Principal;
        }
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(this.getCertificateList().getIssuer());
            return new X500Principal(bOut.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    public Date getThisUpdate() {
        if (this.thisUpdate != null) {
            return this.thisUpdate;
        }
        if (this.fxCRL != null) {
            byte[] bsData = this.fxCRL.getItemDataAndTag(this.fxCRL.getThisUpdate());
            new ByteArrayInputStream(bsData, 0, 11);
            ASN1InputStream ains = new ASN1InputStream(new ByteArrayInputStream(bsData));
            try {
                this.thisUpdate = Time.getInstance(ains.readObject()).getDate();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
            return this.thisUpdate;
        }
        return this.getCertificateList().getThisUpdate().getDate();
    }

    public Date getNextUpdate() {
        if (this.nextUpdate != null) {
            return this.nextUpdate;
        }
        if (this.fxCRL != null) {
            byte[] bsData = this.fxCRL.getItemDataAndTag(this.fxCRL.getNextUpdate());
            ASN1InputStream ains = new ASN1InputStream(new ByteArrayInputStream(bsData));
            try {
                this.nextUpdate = Time.getInstance(ains.readObject()).getDate();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
            return this.nextUpdate;
        }
        if (this.getCertificateList().getNextUpdate() != null) {
            return this.getCertificateList().getNextUpdate().getDate();
        }
        return null;
    }

    private Set loadCRLEntries() {
        this.invokeConstructMethod();
        HashSet<X509CRLEntryObject> entrySet = new HashSet<X509CRLEntryObject>();
        Enumeration certs = this.getCertificateList().getRevokedCertificateEnumeration();
        X500Principal previousCertificateIssuer = this.getIssuerX500Principal();
        while (certs.hasMoreElements()) {
            TBSCertList.CRLEntry entry = (TBSCertList.CRLEntry)certs.nextElement();
            X509CRLEntryObject crlEntry = new X509CRLEntryObject(entry, this.isIndirect, previousCertificateIssuer);
            entrySet.add(crlEntry);
            previousCertificateIssuer = crlEntry.getCertificateIssuer();
        }
        return entrySet;
    }

    public X509CRLEntry getRevokedCertificate(BigInteger serialNumber) {
        this.invokeConstructMethod();
        Enumeration certs = this.getCertificateList().getRevokedCertificateEnumeration();
        X500Principal previousCertificateIssuer = this.getIssuerX500Principal();
        while (certs.hasMoreElements()) {
            TBSCertList.CRLEntry entry = (TBSCertList.CRLEntry)certs.nextElement();
            X509CRLEntryObject crlEntry = new X509CRLEntryObject(entry, this.isIndirect, previousCertificateIssuer);
            if (serialNumber.equals(entry.getUserCertificate().getValue())) {
                return crlEntry;
            }
            previousCertificateIssuer = crlEntry.getCertificateIssuer();
        }
        return null;
    }

    public Set getRevokedCertificates() {
        this.invokeConstructMethod();
        Set entrySet = this.loadCRLEntries();
        if (!entrySet.isEmpty()) {
            return Collections.unmodifiableSet(entrySet);
        }
        return null;
    }

    public byte[] getTBSCertList() throws CRLException {
        if (this.tbsCertList != null) {
            return this.tbsCertList;
        }
        if (this.fxCRL != null) {
            byte[] bsData = this.fxCRL.getItemDataAndTag(this.fxCRL.getTBSCertList());
            this.tbsCertList = bsData;
            return this.tbsCertList;
        }
        try {
            return this.getCertificateList().getTBSCertList().getEncoded("DER");
        }
        catch (IOException e) {
            throw new CRLException(e.toString());
        }
    }

    public byte[] getSignature() {
        if (this.signature != null) {
            return this.signature;
        }
        if (this.fxCRL != null) {
            byte[] bsData = this.fxCRL.getItemData(this.fxCRL.getSignatureValue());
            byte[] bytes = new byte[bsData.length - 1];
            System.arraycopy(bsData, 1, bytes, 0, bsData.length - 1);
            this.signature = bytes;
            return this.signature;
        }
        return this.getCertificateList().getSignature().getBytes();
    }

    public String getSigAlgName() {
        if (this.sigAlgName != null) {
            return this.sigAlgName;
        }
        if (this.fxCRL != null) {
            this.sigAlgName = X509SignatureUtil.getSignatureName(this.getSignatureAlgorithm());
        }
        return this.sigAlgName;
    }

    public String getSigAlgOID() {
        if (this.sigAlgOID != null) {
            return this.sigAlgOID;
        }
        if (this.fxCRL != null) {
            byte[] bsData = this.fxCRL.getItemData(this.fxCRL.getSignatureAlgorithm());
            try {
                AlgorithmIdentifier sigAlg = AlgorithmIdentifier.getInstance(DerUtil.getDerObject(bsData));
                this.sigAlgOID = sigAlg.getObjectId().getId();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
            return this.sigAlgOID;
        }
        return this.getCertificateList().getSignatureAlgorithm().getObjectId().getId();
    }

    public byte[] getSigAlgParams() {
        this.invokeConstructMethod();
        if (this.sigAlgParams != null) {
            byte[] tmp = new byte[this.sigAlgParams.length];
            System.arraycopy(this.sigAlgParams, 0, tmp, 0, tmp.length);
            return tmp;
        }
        return null;
    }

    public String toString() {
        Set set;
        this.invokeConstructMethod();
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append("              Version: ").append(this.getVersion()).append(nl);
        buf.append("             IssuerDN: ").append(this.getIssuerDN()).append(nl);
        buf.append("          This update: ").append(this.getThisUpdate()).append(nl);
        buf.append("          Next update: ").append(this.getNextUpdate()).append(nl);
        buf.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(nl);
        byte[] sig = this.getSignature();
        buf.append("            Signature: ").append(new String(Hex.encode(sig, 0, 20))).append(nl);
        int i = 20;
        while (i < sig.length) {
            if (i < sig.length - 20) {
                buf.append("                       ").append(new String(Hex.encode(sig, i, 20))).append(nl);
            } else {
                buf.append("                       ").append(new String(Hex.encode(sig, i, sig.length - i))).append(nl);
            }
            i += 20;
        }
        X509Extensions extensions = this.getCertificateList().getTBSCertList().getExtensions();
        if (extensions != null) {
            Enumeration e = extensions.oids();
            if (e.hasMoreElements()) {
                buf.append("           Extensions: ").append(nl);
            }
            while (e.hasMoreElements()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
                X509Extension ext = extensions.getExtension(oid);
                if (ext.getValue() != null) {
                    byte[] octs = ext.getValue().getOctets();
                    ASN1InputStream dIn = new ASN1InputStream(octs);
                    buf.append("                       critical(").append(ext.isCritical()).append(") ");
                    try {
                        if (oid.equals(X509Extensions.CRLNumber)) {
                            buf.append(new CRLNumber(DERInteger.getInstance(dIn.readObject()).getPositiveValue())).append(nl);
                            continue;
                        }
                        if (oid.equals(X509Extensions.DeltaCRLIndicator)) {
                            buf.append("Base CRL: " + new CRLNumber(DERInteger.getInstance(dIn.readObject()).getPositiveValue())).append(nl);
                            continue;
                        }
                        if (oid.equals(X509Extensions.IssuingDistributionPoint)) {
                            buf.append(new IssuingDistributionPoint((ASN1Sequence)dIn.readObject())).append(nl);
                            continue;
                        }
                        if (oid.equals(X509Extensions.CRLDistributionPoints)) {
                            buf.append(new CRLDistPoint((ASN1Sequence)dIn.readObject())).append(nl);
                            continue;
                        }
                        if (oid.equals(X509Extensions.FreshestCRL)) {
                            buf.append(new CRLDistPoint((ASN1Sequence)dIn.readObject())).append(nl);
                            continue;
                        }
                        buf.append(oid.getId());
                        buf.append(" value = ").append(ASN1Dump.dumpAsString(dIn.readObject())).append(nl);
                    }
                    catch (Exception ex) {
                        buf.append(oid.getId());
                        buf.append(" value = ").append("*****").append(nl);
                    }
                    continue;
                }
                buf.append(nl);
            }
        }
        if ((set = this.getRevokedCertificates()) != null) {
            Iterator it = set.iterator();
            while (it.hasNext()) {
                buf.append(it.next());
                buf.append(nl);
            }
        }
        return buf.toString();
    }

    public boolean isRevoked(Certificate cert) {
        if (!cert.getType().equals("X.509")) {
            throw new RuntimeException("X.509 CRL used with non X.509 Cert");
        }
        TBSCertList.CRLEntry[] certs = this.getCertificateList().getRevokedCertificates();
        if (certs != null) {
            BigInteger serial = ((X509Certificate)cert).getSerialNumber();
            int i = 0;
            while (i < certs.length) {
                if (this.vtRevokedCertSN != null ? this.vtRevokedCertSN.contains(serial) : certs[i].getUserCertificate().getValue().equals(serial)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isIndirectCRL() throws CRLException {
        this.invokeConstructMethod();
        byte[] idp = this.getExtensionValue(X509Extensions.IssuingDistributionPoint.getId());
        boolean isIndirect = false;
        try {
            if (idp != null) {
                isIndirect = IssuingDistributionPoint.getInstance(X509ExtensionUtil.fromExtensionValue(idp)).isIndirectCRL();
            }
        }
        catch (Exception e) {
            throw new ExtCRLException("Exception reading IssuingDistributionPoint", e);
        }
        return isIndirect;
    }
}

