/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.tls;

import cn.com.infosec.crypto.tls.CombinedHash;
import cn.com.infosec.crypto.tls.TlsCipherSuite;
import cn.com.infosec.crypto.tls.TlsNullCipherSuite;
import cn.com.infosec.crypto.tls.TlsProtocolHandler;
import cn.com.infosec.crypto.tls.TlsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RecordStream {
    private TlsProtocolHandler handler;
    private InputStream is;
    private OutputStream os;
    protected CombinedHash hash1;
    protected CombinedHash hash2;
    protected TlsCipherSuite readSuite = null;
    protected TlsCipherSuite writeSuite = null;

    protected RecordStream(TlsProtocolHandler handler, InputStream is, OutputStream os) {
        this.handler = handler;
        this.is = is;
        this.os = os;
        this.hash1 = new CombinedHash();
        this.hash2 = new CombinedHash();
        this.writeSuite = this.readSuite = new TlsNullCipherSuite();
    }

    public void readData() throws IOException {
        short type = TlsUtils.readUint8(this.is);
        TlsUtils.checkVersion(this.is, this.handler);
        int size = TlsUtils.readUint16(this.is);
        byte[] buf = this.decodeAndVerify(type, this.is, size);
        this.handler.processData(type, buf, 0, buf.length);
    }

    protected byte[] decodeAndVerify(short type, InputStream is, int len) throws IOException {
        byte[] buf = new byte[len];
        TlsUtils.readFully(buf, is);
        byte[] result = this.readSuite.decodeCiphertext(type, buf, 0, buf.length, this.handler);
        return result;
    }

    protected void writeMessage(short type, byte[] message, int offset, int len) throws IOException {
        if (type == 22) {
            this.hash1.update(message, offset, len);
            this.hash2.update(message, offset, len);
        }
        byte[] ciphertext = this.writeSuite.encodePlaintext(type, message, offset, len);
        byte[] writeMessage = new byte[ciphertext.length + 5];
        TlsUtils.writeUint8(type, writeMessage, 0);
        TlsUtils.writeUint8((short)3, writeMessage, 1);
        TlsUtils.writeUint8((short)1, writeMessage, 2);
        TlsUtils.writeUint16(ciphertext.length, writeMessage, 3);
        System.arraycopy(ciphertext, 0, writeMessage, 5, ciphertext.length);
        this.os.write(writeMessage);
        this.os.flush();
    }

    protected void close() throws IOException {
        IOException e = null;
        try {
            this.is.close();
        }
        catch (IOException ex) {
            e = ex;
        }
        try {
            this.os.close();
        }
        catch (IOException ex) {
            e = ex;
        }
        if (e != null) {
            throw e;
        }
    }

    protected void flush() throws IOException {
        this.os.flush();
    }
}

