/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.misc;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DERSequence;

public class CAST5CBCParameters
extends ASN1Encodable {
    DERInteger keyLength;
    ASN1OctetString iv;

    public static CAST5CBCParameters getInstance(Object o) {
        if (o instanceof CAST5CBCParameters) {
            return (CAST5CBCParameters)o;
        }
        if (o instanceof ASN1Sequence) {
            return new CAST5CBCParameters((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("unknown object in CAST5CBCParameter factory");
    }

    public CAST5CBCParameters(byte[] iv, int keyLength) {
        this.iv = new DEROctetString(iv);
        this.keyLength = new DERInteger(keyLength);
    }

    public CAST5CBCParameters(ASN1Sequence seq) {
        this.iv = (ASN1OctetString)seq.getObjectAt(0);
        this.keyLength = (DERInteger)seq.getObjectAt(1);
    }

    public byte[] getIV() {
        return this.iv.getOctets();
    }

    public int getKeyLength() {
        return this.keyLength.getValue().intValue();
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.iv);
        v.add(this.keyLength);
        return new DERSequence(v);
    }
}

