/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.cms;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1Set;
import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.BERSequence;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.cms.EncryptedContentInfo;
import cn.com.infosec.asn1.cms.OriginatorInfo;
import cn.com.infosec.asn1.cms.RecipientInfo;
import java.util.Enumeration;

public class EnvelopedData
extends ASN1Encodable {
    private DERInteger version;
    private OriginatorInfo originatorInfo;
    private ASN1Set recipientInfos;
    private EncryptedContentInfo encryptedContentInfo;
    private ASN1Set unprotectedAttrs;

    public EnvelopedData(OriginatorInfo originatorInfo, ASN1Set recipientInfos, EncryptedContentInfo encryptedContentInfo, ASN1Set unprotectedAttrs) {
        if (originatorInfo != null || unprotectedAttrs != null) {
            this.version = new DERInteger(2);
        } else {
            this.version = new DERInteger(0);
            Enumeration e = recipientInfos.getObjects();
            while (e.hasMoreElements()) {
                RecipientInfo ri = RecipientInfo.getInstance(e.nextElement());
                if (ri.getVersion().equals(this.version)) continue;
                this.version = new DERInteger(2);
                break;
            }
        }
        this.originatorInfo = originatorInfo;
        this.recipientInfos = recipientInfos;
        this.encryptedContentInfo = encryptedContentInfo;
        this.unprotectedAttrs = unprotectedAttrs;
    }

    public EnvelopedData(ASN1Sequence seq) {
        int index = 0;
        this.version = (DERInteger)seq.getObjectAt(index++);
        DEREncodable tmp = seq.getObjectAt(index++);
        if (tmp instanceof ASN1TaggedObject) {
            this.originatorInfo = OriginatorInfo.getInstance((ASN1TaggedObject)tmp, false);
            tmp = seq.getObjectAt(index++);
        }
        this.recipientInfos = ASN1Set.getInstance(tmp);
        this.encryptedContentInfo = EncryptedContentInfo.getInstance(seq.getObjectAt(index++));
        if (seq.size() > index) {
            this.unprotectedAttrs = ASN1Set.getInstance((ASN1TaggedObject)seq.getObjectAt(index), false);
        }
    }

    public static EnvelopedData getInstance(ASN1TaggedObject obj, boolean explicit) {
        return EnvelopedData.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static EnvelopedData getInstance(Object obj) {
        if (obj == null || obj instanceof EnvelopedData) {
            return (EnvelopedData)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new EnvelopedData((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Invalid EnvelopedData: " + obj.getClass().getName());
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.originatorInfo;
    }

    public ASN1Set getRecipientInfos() {
        return this.recipientInfos;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public ASN1Set getUnprotectedAttrs() {
        return this.unprotectedAttrs;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.version);
        if (this.originatorInfo != null) {
            v.add(new DERTaggedObject(false, 0, this.originatorInfo));
        }
        v.add(this.recipientInfos);
        v.add(this.encryptedContentInfo);
        if (this.unprotectedAttrs != null) {
            v.add(new DERTaggedObject(false, 1, this.unprotectedAttrs));
        }
        return new BERSequence(v);
    }
}

