/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1Object;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.util.Arrays;
import java.io.IOException;

public class DERApplicationSpecific
extends ASN1Object {
    private final boolean isConstructed;
    private final int tag;
    private final byte[] octets;

    DERApplicationSpecific(boolean isConstructed, int tag, byte[] octets) {
        this.isConstructed = isConstructed;
        this.tag = tag;
        this.octets = octets;
    }

    public DERApplicationSpecific(int tag, byte[] octets) {
        this(false, tag, octets);
    }

    public DERApplicationSpecific(int tag, DEREncodable object) throws IOException {
        this(true, tag, object);
    }

    public DERApplicationSpecific(boolean explicit, int tag, DEREncodable object) throws IOException {
        if (tag >= 31) {
            throw new IOException("unsupported tag number");
        }
        byte[] data = object.getDERObject().getDEREncoded();
        this.isConstructed = explicit;
        this.tag = tag;
        if (explicit) {
            this.octets = data;
        } else {
            int lenBytes = this.getLengthOfLength(data);
            byte[] tmp = new byte[data.length - lenBytes];
            System.arraycopy(data, lenBytes, tmp, 0, tmp.length);
            this.octets = tmp;
        }
    }

    private int getLengthOfLength(byte[] data) {
        int count = 2;
        while ((data[count - 1] & 0x80) != 0) {
            ++count;
        }
        return count;
    }

    public boolean isConstructed() {
        return this.isConstructed;
    }

    public byte[] getContents() {
        return this.octets;
    }

    public int getApplicationTag() {
        return this.tag;
    }

    public DERObject getObject() throws IOException {
        return new ASN1InputStream(this.getContents()).readObject();
    }

    public DERObject getObject(int derTagNo) throws IOException {
        if (this.tag >= 31) {
            throw new IOException("unsupported tag number");
        }
        byte[] tmp = this.getEncoded();
        tmp[0] = (byte)derTagNo;
        return new ASN1InputStream(tmp).readObject();
    }

    void encode(DEROutputStream out) throws IOException {
        int classBits = 64;
        if (this.isConstructed) {
            classBits |= 0x20;
        }
        if (this.tag < 31) {
            out.writeEncoded(classBits | this.tag, this.octets);
        } else {
            out.writeEncodedHigh(classBits | 0x1F, this.tag, this.octets);
        }
    }

    boolean asn1Equals(DERObject o) {
        if (!(o instanceof DERApplicationSpecific)) {
            return false;
        }
        DERApplicationSpecific other = (DERApplicationSpecific)o;
        return this.isConstructed == other.isConstructed && this.tag == other.tag && Arrays.areEqual(this.octets, other.octets);
    }

    public int hashCode() {
        return (this.isConstructed ? 1 : 0) ^ this.tag ^ Arrays.hashCode(this.octets);
    }
}

