/*
 * Decompiled with CFR 0.152.
 */
package com.fr.write.config;

import com.fr.cache.list.IntList;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.Delete;
import com.fr.data.core.db.dml.InsertOrUpdate;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.dml.Where;
import com.fr.general.FRLogger;
import com.fr.script.Calculator;
import com.fr.stable.StableUtils;
import com.fr.write.config.ColumnConfig;
import com.fr.write.config.DMLConfig;
import com.fr.write.config.DeleteConfig;
import com.fr.write.config.InsertConfig;
import com.fr.write.config.UpdateConfig;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class IntelliDMLConfig
extends DMLConfig {
    private InsertConfig insertConfig = null;
    protected Map pstmtMap = new HashMap();
    private DeleteConfig deleteConfig = null;
    private UpdateConfig updateConfig = null;

    protected int dmlSubmit(Connection connection, Calculator calculator, Object[] objectArray, Map map) throws SQLException {
        int n = this.getColumnConfigCount();
        if (n == 0 || this.table == null) {
            return -1;
        }
        Dialect dialect = DialectFactory.generateDialect(connection);
        Where where = this.generateWhere(connection, objectArray);
        if (Where.validate(where)) {
            if (this.doDelete(calculator)) {
                Delete delete = new Delete(this.getTable(calculator), where, dialect);
                return delete.execute(connection);
            }
            int n2 = this.tryUpdate(connection, calculator, objectArray, dialect, where, map);
            if (n2 != -1) {
                return n2;
            }
        }
        if (this.isDeleted(calculator)) {
            return -1;
        }
        if (this.insertConfig == null) {
            this.insertConfig = new InsertConfig();
            this.copyConfig(this.insertConfig);
        }
        return this.insertConfig.dmlSubmit(connection, calculator, objectArray, map);
    }

    protected int dmlSubmitBatch(int n, Connection connection, Calculator calculator, Object[] objectArray, Map map) throws SQLException {
        return this.dmlSubmit(connection, calculator, objectArray, map);
    }

    public void simpleSubmit(Connection connection, Dialect dialect, Object[] objectArray) throws SQLException {
        int n;
        int n2 = this.getColumnConfigCount();
        if (n2 == 0 || this.table == null) {
            return;
        }
        Where where = this.generateWhere(connection, objectArray);
        if (Where.validate(where) && (n = this.tryUpdate(connection, null, objectArray, dialect, where, null)) != -1) {
            return;
        }
        if (this.insertConfig == null) {
            this.insertConfig = new InsertConfig();
            this.copyConfig(this.insertConfig);
        }
        this.insertConfig.simpleSubmit(connection, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int tryUpdate(Connection connection, Calculator calculator, Object[] objectArray, Dialect dialect, Where where, Map map) throws SQLException {
        PreparedStatement preparedStatement;
        ResultSet resultSet;
        block8: {
            int n;
            int n2;
            if (this.updateConfig == null) {
                this.updateConfig = new UpdateConfig();
                this.copyConfig(this.updateConfig);
            }
            if ((n2 = this.updateConfig.dmlSubmit(connection, calculator, objectArray, map)) > 0) {
                return n2;
            }
            Select select = new Select(this.table, where, dialect);
            resultSet = null;
            preparedStatement = null;
            try {
                try {
                    preparedStatement = select.createPreparedStatement(connection);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) break block8;
                    n = 0;
                    Object var13_13 = null;
                }
                catch (SQLException sQLException) {
                    FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                    Object var13_15 = null;
                    DBUtils.closeResultSet(resultSet);
                    DBUtils.closeStatement(preparedStatement);
                    return -1;
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(preparedStatement);
                throw throwable;
            }
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(preparedStatement);
            return n;
        }
        Object var13_14 = null;
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(preparedStatement);
        return -1;
    }

    private void copyConfig(DMLConfig dMLConfig) {
        dMLConfig.table = this.table;
        dMLConfig.columnConfigList = this.columnConfigList;
        dMLConfig.submitJobList = this.submitJobList;
        dMLConfig.setUpdateSelected(this.isUpdateSelected());
    }

    public void setTable(Table table) {
        this.table = table;
        if (this.insertConfig != null) {
            this.insertConfig.table = table;
        }
        if (this.deleteConfig != null) {
            this.deleteConfig.table = table;
        }
        if (this.updateConfig != null) {
            this.updateConfig.table = table;
        }
    }

    protected void closeStatement(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = (PreparedStatement)this.pstmtMap.get(connection);
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (this.insertConfig != null) {
            this.insertConfig.closeStatement(connection);
        }
        if (this.deleteConfig != null) {
            this.deleteConfig.closeStatement(connection);
        }
        if (this.updateConfig != null) {
            this.updateConfig.closeStatement(connection);
        }
    }

    protected PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
        IntList intList = new IntList();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Dialect dialect = DialectFactory.generateDialect(connection);
        int n = this.getColumnConfigCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(dialect.column2SQL(this.getColumnConfig(i).getColumnName()));
            arrayList2.add("?");
            intList.add(i);
        }
        if (arrayList2.isEmpty()) {
            return null;
        }
        String string = "INSERT INTO " + this.getTable().toStatementSQLString(dialect) + " (" + StableUtils.join(arrayList, ",") + ") VALUES (" + StableUtils.join(arrayList2, ",") + ")";
        PreparedStatement preparedStatement = connection.prepareStatement(string.toString());
        return preparedStatement;
    }

    private void fillInsertedPreparedStatement(PreparedStatement preparedStatement, Connection connection, Object[] objectArray) throws SQLException {
        for (int i = 0; i < this.getColumnConfigCount(); ++i) {
            DBUtils.applyColumnTypeValue(DialectFactory.generateDialect(connection), connection, this.getTable(), this.getColumnName(i), this.getColumnDefValue(i), preparedStatement, i + 1, this.getColumnType(this.getColumnName(i), connection), objectArray[i]);
        }
    }

    private int insert(Connection connection, Object[] objectArray) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedStatement(connection);
        this.fillInsertedPreparedStatement(preparedStatement, connection, objectArray);
        return preparedStatement.executeUpdate();
    }

    private boolean doDelete(Calculator calculator) {
        for (int i = 0; i < this.getColumnConfigCount(); ++i) {
            ColumnConfig columnConfig = this.getColumnConfig(i);
            if (!columnConfig.isKey() || !columnConfig.isDeleted(calculator)) continue;
            return true;
        }
        return false;
    }

    private boolean isDeleted(Calculator calculator) {
        for (int i = 0; i < this.getColumnConfigCount(); ++i) {
            ColumnConfig columnConfig = this.getColumnConfig(i);
            if (!columnConfig.isDeletedColumnRow(calculator)) continue;
            return true;
        }
        return false;
    }

    private void addColumn2InsertOrUpdate(InsertOrUpdate insertOrUpdate, Calculator calculator, Object[] objectArray, Connection connection) {
        int n = this.getColumnConfigCount();
        for (int i = 0; i < n; ++i) {
            ColumnConfig columnConfig = this.getColumnConfig(i);
            if (columnConfig.isKey() && insertOrUpdate.isUpdate() || insertOrUpdate.isUpdate() && columnConfig.isSkipUnmodified() && !columnConfig.isModified(calculator)) continue;
            String string = columnConfig.getColumnName();
            int n2 = this.getColumnType(string, connection);
            insertOrUpdate.addColumn(string, n2, objectArray[i]);
        }
    }

    public String toString() {
        return "update/insert into " + (this.table == null ? "null" : this.table.toString()) + " " + super.toString();
    }

    protected PreparedStatement getPreparedStatement(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = (PreparedStatement)this.pstmtMap.get(connection);
        if (preparedStatement == null) {
            preparedStatement = this.createPreparedStatement(connection);
            this.pstmtMap.put(connection, preparedStatement);
        }
        return preparedStatement;
    }

    protected boolean isIgnoreUpdate(Calculator calculator) {
        if (this.updateConfig == null) {
            this.updateConfig = new UpdateConfig();
            this.copyConfig(this.updateConfig);
        }
        return this.updateConfig.isIgnoreUpdate(calculator);
    }
}

