/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.cluster;

import com.fr.base.FRContext;
import com.fr.file.BaseClusterHelper;
import com.fr.file.ClusterConfigManager;
import com.fr.file.ClusterService;
import com.fr.general.GeneralContext;
import com.fr.general.http.HttpClient;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StringUtils;
import com.fr.web.utils.WebUtils;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class ClusterManager {
    public static final String ACTIONOP = "fr_cluster";
    private boolean isInit = false;
    private String localIp = null;
    private String localPort = null;
    private ClusterService selfService = null;
    private ClusterService mainService = null;
    private static ClusterManager clusterManager = new ClusterManager();

    public static ClusterManager getInstance() {
        return clusterManager;
    }

    public ClusterService getSelfService() {
        return this.selfService;
    }

    public String getLocalIp() {
        return this.localIp;
    }

    public String getLocalPort() {
        return this.localPort;
    }

    public ClusterService getMainService() {
        if (this.mainService == null) {
            this.mainService = ClusterConfigManager.getInstance().resolveMainServices();
        }
        return this.mainService;
    }

    public void initClusterServiceConfig(HttpServletRequest httpServletRequest) {
        if (!ClusterManager.clusterManager.isInit) {
            this.selfService = ClusterConfigManager.getInstance().resolveSelfServices();
            if (this.selfService == null) {
                this.initSelfService(httpServletRequest);
            }
            this.mainService = ClusterConfigManager.getInstance().resolveMainServices();
            ClusterManager.clusterManager.isInit = true;
        } else if (this.selfService == null && WebUtils.getHTTPRequestParameter(httpServletRequest, "__redirect_from") == null) {
            this.initSelfService(httpServletRequest);
        }
    }

    public void resetMain() {
        this.mainService = null;
    }

    private void initSelfService(HttpServletRequest httpServletRequest) {
        try {
            this.localIp = BaseClusterHelper.getLocalIP();
            this.localIp = this.localIp == null ? httpServletRequest.getLocalAddr() : this.localIp.trim();
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
        this.localPort = String.valueOf(httpServletRequest.getLocalPort()).trim();
        if (StringUtils.isNotEmpty(this.localIp) && StringUtils.isNotEmpty(this.localPort)) {
            this.selfService = ClusterConfigManager.getInstance().resolveSelfServicesByIPAndPort(this.localIp, this.localPort);
            this.identitySelf();
        }
    }

    private void identitySelf() {
        if (this.selfService != null) {
            ClusterConfigManager.getInstance().getService(this.selfService.getServiceName()).setSelf(true);
            if (this.selfService.isMain()) {
                this.reinitMain();
            }
            return;
        }
        List list = ClusterConfigManager.getInstance().getOtherServices(this.selfService);
        for (ClusterService clusterService : list) {
            String string = ClusterConfigManager.getDefaultUrl(clusterService);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("op", "fs");
            HttpClient httpClient = new HttpClient(string, hashMap);
            if (!httpClient.isServerAlive()) continue;
            httpClient.getResponseStream();
        }
    }

    private void reinitMain() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ClusterConfigManager.waitForMainService();
            }
        });
        thread.start();
    }

    public static String clusterHelp(String string) {
        ClusterService clusterService = ClusterManager.getInstance().getSelfService();
        if (clusterService != null && clusterService.getServiceName() != null) {
            string = clusterService.getServiceName() + "_" + string;
        }
        return string;
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                clusterManager.resetMain();
            }
        });
    }
}

