/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.plugin.event;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginChangeEvent {
    private String pluginID;
    private boolean active;
    private Map<String, Set<String>> moduleInterfaceMap;
    private Set<String> concernedModuleTags;
    private Set<String> concernedInterfaceTags;

    public boolean containsInterface(String string, String string2) {
        return this.moduleInterfaceMap.containsKey(string) && this.moduleInterfaceMap.get(string).contains(string2);
    }

    public PluginChangeEvent(String string, boolean bl, Map<String, Set<String>> map) {
        this.pluginID = string;
        this.active = bl;
        this.initModuleInterfaceMap(map);
    }

    public String getPluginID() {
        return this.pluginID;
    }

    public PluginChangeEvent setPluginID(String string) {
        this.pluginID = string == null ? "" : string;
        return this;
    }

    public boolean isActive() {
        return this.active;
    }

    public PluginChangeEvent setActive(boolean bl) {
        this.active = bl;
        return this;
    }

    public Map<String, Set<String>> getModuleInterfaceMap() {
        return this.moduleInterfaceMap;
    }

    private PluginChangeEvent initModuleInterfaceMap(Map<String, Set<String>> map) {
        this.moduleInterfaceMap = map;
        if (this.moduleInterfaceMap == null) {
            this.moduleInterfaceMap = new HashMap<String, Set<String>>();
        }
        this.initConcernedModules();
        this.initConcernedInterfaces();
        return this;
    }

    public Set<String> getConcernedModuleTags() {
        return this.concernedModuleTags;
    }

    public Set<String> getConcernedInterfaceTags() {
        return this.concernedInterfaceTags;
    }

    private synchronized void initConcernedModules() {
        if (this.concernedModuleTags != null) {
            return;
        }
        this.concernedModuleTags = new HashSet<String>();
        for (Map.Entry<String, Set<String>> entry : this.moduleInterfaceMap.entrySet()) {
            if (entry.getValue().size() == 0) continue;
            this.concernedModuleTags.add(entry.getKey());
        }
    }

    private synchronized void initConcernedInterfaces() {
        if (this.concernedInterfaceTags != null) {
            return;
        }
        this.concernedInterfaceTags = new HashSet<String>();
        for (Map.Entry<String, Set<String>> entry : this.moduleInterfaceMap.entrySet()) {
            this.concernedInterfaceTags.addAll((Collection<String>)entry.getValue());
        }
    }
}

