/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.utils.reflect;

import com.fr.stable.collections.utils.reflect.Annotation;
import com.fr.stable.collections.utils.reflect.Constructor;
import com.fr.stable.collections.utils.reflect.Field;
import com.fr.stable.collections.utils.reflect.Method;
import com.fr.stable.collections.utils.reflect.ReflectionException;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassReflection {
    public static Class forName(String string) throws ReflectionException {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException("Class not found: " + string, classNotFoundException);
        }
    }

    public static String getSimpleName(Class clazz) {
        return clazz.getSimpleName();
    }

    public static boolean isInstance(Class clazz, Object object) {
        return clazz.isInstance(object);
    }

    public static boolean isAssignableFrom(Class clazz, Class clazz2) {
        return clazz.isAssignableFrom(clazz2);
    }

    public static boolean isMemberClass(Class clazz) {
        return clazz.isMemberClass();
    }

    public static boolean isStaticClass(Class clazz) {
        return Modifier.isStatic(clazz.getModifiers());
    }

    public static boolean isArray(Class clazz) {
        return clazz.isArray();
    }

    public static <T> T newInstance(Class<T> clazz) throws ReflectionException {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectionException("Could not instantiate instance of class: " + clazz.getName(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException("Could not instantiate instance of class: " + clazz.getName(), illegalAccessException);
        }
    }

    public static Constructor[] getConstructors(Class clazz) {
        java.lang.reflect.Constructor<?>[] constructorArray = clazz.getConstructors();
        Constructor[] constructorArray2 = new Constructor[constructorArray.length];
        int n = constructorArray.length;
        for (int i = 0; i < n; ++i) {
            constructorArray2[i] = new Constructor(constructorArray[i]);
        }
        return constructorArray2;
    }

    public static Constructor getConstructor(Class clazz, Class ... classArray) throws ReflectionException {
        try {
            return new Constructor(clazz.getConstructor(classArray));
        }
        catch (SecurityException securityException) {
            throw new ReflectionException("Security violation occurred while getting constructor for class: '" + clazz.getName() + "'.", securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException("Constructor not found for class: " + clazz.getName(), noSuchMethodException);
        }
    }

    public static Constructor getDeclaredConstructor(Class clazz, Class ... classArray) throws ReflectionException {
        try {
            return new Constructor(clazz.getDeclaredConstructor(classArray));
        }
        catch (SecurityException securityException) {
            throw new ReflectionException("Security violation while getting constructor for class: " + clazz.getName(), securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException("Constructor not found for class: " + clazz.getName(), noSuchMethodException);
        }
    }

    public static Method[] getMethods(Class clazz) {
        java.lang.reflect.Method[] methodArray = clazz.getMethods();
        Method[] methodArray2 = new Method[methodArray.length];
        int n = methodArray.length;
        for (int i = 0; i < n; ++i) {
            methodArray2[i] = new Method(methodArray[i]);
        }
        return methodArray2;
    }

    public static Method getMethod(Class clazz, String string, Class ... classArray) throws ReflectionException {
        try {
            return new Method(clazz.getMethod(string, classArray));
        }
        catch (SecurityException securityException) {
            throw new ReflectionException("Security violation while getting method: " + string + ", for class: " + clazz.getName(), securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException("Method not found: " + string + ", for class: " + clazz.getName(), noSuchMethodException);
        }
    }

    public static Method[] getDeclaredMethods(Class clazz) {
        java.lang.reflect.Method[] methodArray = clazz.getDeclaredMethods();
        Method[] methodArray2 = new Method[methodArray.length];
        int n = methodArray.length;
        for (int i = 0; i < n; ++i) {
            methodArray2[i] = new Method(methodArray[i]);
        }
        return methodArray2;
    }

    public static Method getDeclaredMethod(Class clazz, String string, Class ... classArray) throws ReflectionException {
        try {
            return new Method(clazz.getDeclaredMethod(string, classArray));
        }
        catch (SecurityException securityException) {
            throw new ReflectionException("Security violation while getting method: " + string + ", for class: " + clazz.getName(), securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException("Method not found: " + string + ", for class: " + clazz.getName(), noSuchMethodException);
        }
    }

    public static Field[] getFields(Class clazz) {
        java.lang.reflect.Field[] fieldArray = clazz.getFields();
        Field[] fieldArray2 = new Field[fieldArray.length];
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            fieldArray2[i] = new Field(fieldArray[i]);
        }
        return fieldArray2;
    }

    public static Field getField(Class clazz, String string) throws ReflectionException {
        try {
            return new Field(clazz.getField(string));
        }
        catch (SecurityException securityException) {
            throw new ReflectionException("Security violation while getting field: " + string + ", for class: " + clazz.getName(), securityException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ReflectionException("Field not found: " + string + ", for class: " + clazz.getName(), noSuchFieldException);
        }
    }

    public static Field[] getDeclaredFields(Class clazz) {
        java.lang.reflect.Field[] fieldArray = clazz.getDeclaredFields();
        Field[] fieldArray2 = new Field[fieldArray.length];
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            fieldArray2[i] = new Field(fieldArray[i]);
        }
        return fieldArray2;
    }

    public static Field getDeclaredField(Class clazz, String string) throws ReflectionException {
        try {
            return new Field(clazz.getDeclaredField(string));
        }
        catch (SecurityException securityException) {
            throw new ReflectionException("Security violation while getting field: " + string + ", for class: " + clazz.getName(), securityException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ReflectionException("Field not found: " + string + ", for class: " + clazz.getName(), noSuchFieldException);
        }
    }

    public static boolean isAnnotationPresent(Class clazz, Class<? extends java.lang.annotation.Annotation> clazz2) {
        return clazz.isAnnotationPresent(clazz2);
    }

    public static Annotation[] getAnnotations(Class clazz) {
        java.lang.annotation.Annotation[] annotationArray = clazz.getAnnotations();
        Annotation[] annotationArray2 = new Annotation[annotationArray.length];
        for (int i = 0; i < annotationArray.length; ++i) {
            annotationArray2[i] = new Annotation(annotationArray[i]);
        }
        return annotationArray2;
    }

    public static Annotation getAnnotation(Class clazz, Class<? extends java.lang.annotation.Annotation> clazz2) {
        java.lang.annotation.Annotation annotation = clazz.getAnnotation(clazz2);
        if (annotation != null) {
            return new Annotation(annotation);
        }
        return null;
    }

    public static Annotation[] getDeclaredAnnotations(Class clazz) {
        java.lang.annotation.Annotation[] annotationArray = clazz.getDeclaredAnnotations();
        Annotation[] annotationArray2 = new Annotation[annotationArray.length];
        for (int i = 0; i < annotationArray.length; ++i) {
            annotationArray2[i] = new Annotation(annotationArray[i]);
        }
        return annotationArray2;
    }

    public static Annotation getDeclaredAnnotation(Class clazz, Class<? extends java.lang.annotation.Annotation> clazz2) {
        java.lang.annotation.Annotation[] annotationArray;
        for (java.lang.annotation.Annotation annotation : annotationArray = clazz.getDeclaredAnnotations()) {
            if (!annotation.annotationType().equals(clazz2)) continue;
            return new Annotation(annotation);
        }
        return null;
    }

    public static Class[] getInterfaces(Class clazz) {
        return clazz.getInterfaces();
    }
}

