/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.map;

import com.fr.stable.collections.array.Array;
import com.fr.stable.collections.map.ObjectSet;
import com.fr.stable.collections.utils.GdxRuntimeException;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedSet<T>
extends ObjectSet<T> {
    final Array<T> items;
    OrderedSetIterator iterator1;
    OrderedSetIterator iterator2;

    public OrderedSet() {
        this.items = new Array();
    }

    public OrderedSet(int n, float f) {
        super(n, f);
        this.items = new Array(this.capacity);
    }

    public OrderedSet(int n) {
        super(n);
        this.items = new Array(this.capacity);
    }

    public OrderedSet(OrderedSet orderedSet) {
        super(orderedSet);
        this.items = new Array(this.capacity);
        this.items.addAll(orderedSet.items);
    }

    @Override
    public boolean add(T t) {
        if (!this.contains(t)) {
            this.items.add(t);
        }
        return super.add(t);
    }

    @Override
    public boolean remove(T t) {
        this.items.removeValue(t, false);
        return super.remove(t);
    }

    @Override
    public void clear(int n) {
        this.items.clear();
        super.clear(n);
    }

    @Override
    public void clear() {
        this.items.clear();
        super.clear();
    }

    public Array<T> orderedItems() {
        return this.items;
    }

    @Override
    public OrderedSetIterator<T> iterator() {
        if (this.iterator1 == null) {
            this.iterator1 = new OrderedSetIterator(this);
            this.iterator2 = new OrderedSetIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    @Override
    public String toString() {
        if (this.size == 0) {
            return "{}";
        }
        T[] TArray = this.items.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('{');
        stringBuilder.append(TArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(TArray[i]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public String toString(String string) {
        return this.items.toString(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OrderedSetIterator<T>
    extends ObjectSet.ObjectSetIterator<T> {
        private Array<T> items;

        public OrderedSetIterator(OrderedSet<T> orderedSet) {
            super(orderedSet);
            this.items = orderedSet.items;
        }

        @Override
        public void reset() {
            this.nextIndex = 0;
            this.hasNext = this.set.size > 0;
        }

        @Override
        public T next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            T t = this.items.get(this.nextIndex);
            ++this.nextIndex;
            this.hasNext = this.nextIndex < this.set.size;
            return t;
        }

        @Override
        public void remove() {
            if (this.nextIndex < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            --this.nextIndex;
            this.set.remove(this.items.get(this.nextIndex));
        }
    }
}

