/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.map;

import com.fr.stable.collections.array.Array;
import com.fr.stable.collections.array.FloatArray;
import com.fr.stable.collections.utils.GdxRuntimeException;
import com.fr.stable.collections.utils.MathUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFloatMap<K>
implements Iterable<Entry<K>> {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    public int size;
    K[] keyTable;
    float[] valueTable;
    int capacity;
    int stashSize;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;
    private Entries entries1;
    private Entries entries2;
    private Values values1;
    private Values values2;
    private Keys keys1;
    private Keys keys2;

    public ObjectFloatMap() {
        this(51, 0.8f);
    }

    public ObjectFloatMap(int n) {
        this(n, 0.8f);
    }

    public ObjectFloatMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + n);
        }
        if ((n = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / f))) > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + n);
        }
        this.capacity = n;
        if (f <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + f);
        }
        this.loadFactor = f;
        this.threshold = (int)((float)this.capacity * f);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new Object[this.capacity + this.stashCapacity];
        this.valueTable = new float[this.keyTable.length];
    }

    public ObjectFloatMap(ObjectFloatMap<? extends K> objectFloatMap) {
        this((int)Math.floor((float)objectFloatMap.capacity * objectFloatMap.loadFactor), objectFloatMap.loadFactor);
        this.stashSize = objectFloatMap.stashSize;
        System.arraycopy(objectFloatMap.keyTable, 0, this.keyTable, 0, objectFloatMap.keyTable.length);
        System.arraycopy(objectFloatMap.valueTable, 0, this.valueTable, 0, objectFloatMap.valueTable.length);
        this.size = objectFloatMap.size;
    }

    public void put(K k, float f) {
        int n;
        if (k == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        K[] KArray = this.keyTable;
        int n2 = k.hashCode();
        int n3 = n2 & this.mask;
        K k2 = KArray[n3];
        if (k.equals(k2)) {
            this.valueTable[n3] = f;
            return;
        }
        int n4 = this.hash2(n2);
        K k3 = KArray[n4];
        if (k.equals(k3)) {
            this.valueTable[n4] = f;
            return;
        }
        int n5 = this.hash3(n2);
        K k4 = KArray[n5];
        if (k.equals(k4)) {
            this.valueTable[n5] = f;
            return;
        }
        int n6 = n + this.stashSize;
        for (n = this.capacity; n < n6; ++n) {
            if (!k.equals(KArray[n])) continue;
            this.valueTable[n] = f;
            return;
        }
        if (k2 == null) {
            KArray[n3] = k;
            this.valueTable[n3] = f;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (k3 == null) {
            KArray[n4] = k;
            this.valueTable[n4] = f;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (k4 == null) {
            KArray[n5] = k;
            this.valueTable[n5] = f;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(k, f, n3, k2, n4, k3, n5, k4);
    }

    public void putAll(ObjectFloatMap<K> objectFloatMap) {
        for (Entry entry : objectFloatMap.entries()) {
            this.put(entry.key, entry.value);
        }
    }

    private void putResize(K k, float f) {
        int n = k.hashCode();
        int n2 = n & this.mask;
        K k2 = this.keyTable[n2];
        if (k2 == null) {
            this.keyTable[n2] = k;
            this.valueTable[n2] = f;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n3 = this.hash2(n);
        K k3 = this.keyTable[n3];
        if (k3 == null) {
            this.keyTable[n3] = k;
            this.valueTable[n3] = f;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n4 = this.hash3(n);
        K k4 = this.keyTable[n4];
        if (k4 == null) {
            this.keyTable[n4] = k;
            this.valueTable[n4] = f;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(k, f, n2, k2, n3, k3, n4, k4);
    }

    private void push(K k, float f, int n, K k2, int n2, K k3, int n3, K k4) {
        float f2;
        K k5;
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n4 = this.mask;
        int n5 = 0;
        int n6 = this.pushIterations;
        while (true) {
            switch (MathUtils.random(2)) {
                case 0: {
                    k5 = k2;
                    f2 = fArray[n];
                    KArray[n] = k;
                    fArray[n] = f;
                    break;
                }
                case 1: {
                    k5 = k3;
                    f2 = fArray[n2];
                    KArray[n2] = k;
                    fArray[n2] = f;
                    break;
                }
                default: {
                    k5 = k4;
                    f2 = fArray[n3];
                    KArray[n3] = k;
                    fArray[n3] = f;
                }
            }
            int n7 = k5.hashCode();
            n = n7 & n4;
            k2 = KArray[n];
            if (k2 == null) {
                KArray[n] = k5;
                fArray[n] = f2;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n2 = this.hash2(n7);
            k3 = KArray[n2];
            if (k3 == null) {
                KArray[n2] = k5;
                fArray[n2] = f2;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n3 = this.hash3(n7);
            k4 = KArray[n3];
            if (k4 == null) {
                KArray[n3] = k5;
                fArray[n3] = f2;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n5 == n6) break;
            k = k5;
            f = f2;
        }
        this.putStash(k5, f2);
    }

    private void putStash(K k, float f) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.put(k, f);
            return;
        }
        int n = this.capacity + this.stashSize;
        this.keyTable[n] = k;
        this.valueTable[n] = f;
        ++this.stashSize;
        ++this.size;
    }

    public float get(K k, float f) {
        int n = k.hashCode();
        int n2 = n & this.mask;
        if (!(k.equals(this.keyTable[n2]) || k.equals(this.keyTable[n2 = this.hash2(n)]) || k.equals(this.keyTable[n2 = this.hash3(n)]))) {
            return this.getStash(k, f);
        }
        return this.valueTable[n2];
    }

    private float getStash(K k, float f) {
        int n;
        K[] KArray = this.keyTable;
        int n2 = n + this.stashSize;
        for (n = this.capacity; n < n2; ++n) {
            if (!k.equals(KArray[n])) continue;
            return this.valueTable[n];
        }
        return f;
    }

    public float getAndIncrement(K k, float f, float f2) {
        int n = k.hashCode();
        int n2 = n & this.mask;
        if (!(k.equals(this.keyTable[n2]) || k.equals(this.keyTable[n2 = this.hash2(n)]) || k.equals(this.keyTable[n2 = this.hash3(n)]))) {
            return this.getAndIncrementStash(k, f, f2);
        }
        float f3 = this.valueTable[n2];
        this.valueTable[n2] = f3 + f2;
        return f3;
    }

    private float getAndIncrementStash(K k, float f, float f2) {
        int n;
        K[] KArray = this.keyTable;
        int n2 = n + this.stashSize;
        for (n = this.capacity; n < n2; ++n) {
            if (!k.equals(KArray[n])) continue;
            float f3 = this.valueTable[n];
            this.valueTable[n] = f3 + f2;
            return f3;
        }
        this.put(k, f + f2);
        return f;
    }

    public float remove(K k, float f) {
        int n = k.hashCode();
        int n2 = n & this.mask;
        if (k.equals(this.keyTable[n2])) {
            this.keyTable[n2] = null;
            float f2 = this.valueTable[n2];
            --this.size;
            return f2;
        }
        n2 = this.hash2(n);
        if (k.equals(this.keyTable[n2])) {
            this.keyTable[n2] = null;
            float f3 = this.valueTable[n2];
            --this.size;
            return f3;
        }
        n2 = this.hash3(n);
        if (k.equals(this.keyTable[n2])) {
            this.keyTable[n2] = null;
            float f4 = this.valueTable[n2];
            --this.size;
            return f4;
        }
        return this.removeStash(k, f);
    }

    float removeStash(K k, float f) {
        int n;
        K[] KArray = this.keyTable;
        int n2 = n + this.stashSize;
        for (n = this.capacity; n < n2; ++n) {
            if (!k.equals(KArray[n])) continue;
            float f2 = this.valueTable[n];
            this.removeStashIndex(n);
            --this.size;
            return f2;
        }
        return f;
    }

    void removeStashIndex(int n) {
        --this.stashSize;
        int n2 = this.capacity + this.stashSize;
        if (n < n2) {
            this.keyTable[n] = this.keyTable[n2];
            this.valueTable[n] = this.valueTable[n2];
        }
    }

    public void shrink(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + n);
        }
        if (this.size > n) {
            n = this.size;
        }
        if (this.capacity <= n) {
            return;
        }
        n = MathUtils.nextPowerOfTwo(n);
        this.resize(n);
    }

    public void clear(int n) {
        if (this.capacity <= n) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(n);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        K[] KArray = this.keyTable;
        int n = this.capacity + this.stashSize;
        while (n-- > 0) {
            KArray[n] = null;
        }
        this.size = 0;
        this.stashSize = 0;
    }

    public boolean containsValue(float f) {
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n = this.capacity + this.stashSize;
        while (n-- > 0) {
            if (KArray[n] == null || fArray[n] != f) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(K k) {
        int n = k.hashCode();
        int n2 = n & this.mask;
        if (!(k.equals(this.keyTable[n2]) || k.equals(this.keyTable[n2 = this.hash2(n)]) || k.equals(this.keyTable[n2 = this.hash3(n)]))) {
            return this.containsKeyStash(k);
        }
        return true;
    }

    private boolean containsKeyStash(K k) {
        int n;
        K[] KArray = this.keyTable;
        int n2 = n + this.stashSize;
        for (n = this.capacity; n < n2; ++n) {
            if (!k.equals(KArray[n])) continue;
            return true;
        }
        return false;
    }

    public K findKey(float f) {
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n = this.capacity + this.stashSize;
        while (n-- > 0) {
            if (KArray[n] == null || fArray[n] != f) continue;
            return KArray[n];
        }
        return null;
    }

    public void ensureCapacity(int n) {
        int n2 = this.size + n;
        if (n2 >= this.threshold) {
            this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n2 / this.loadFactor)));
        }
    }

    private void resize(int n) {
        int n2 = this.capacity + this.stashSize;
        this.capacity = n;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(n)) * 2);
        this.pushIterations = Math.max(Math.min(n, 8), (int)Math.sqrt(n) / 8);
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        this.keyTable = new Object[n + this.stashCapacity];
        this.valueTable = new float[n + this.stashCapacity];
        int n3 = this.size;
        this.size = 0;
        this.stashSize = 0;
        if (n3 > 0) {
            for (int i = 0; i < n2; ++i) {
                K k = KArray[i];
                if (k == null) continue;
                this.putResize(k, fArray[i]);
            }
        }
    }

    private int hash2(int n) {
        return ((n *= -1262997959) ^ n >>> this.hashShift) & this.mask;
    }

    private int hash3(int n) {
        return ((n *= -825114047) ^ n >>> this.hashShift) & this.mask;
    }

    public int hashCode() {
        int n = 0;
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        for (int i = 0; i < n2; ++i) {
            K k = KArray[i];
            if (k == null) continue;
            n += k.hashCode() * 31;
            float f = fArray[i];
            n += Float.floatToIntBits(f);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ObjectFloatMap)) {
            return false;
        }
        ObjectFloatMap objectFloatMap = (ObjectFloatMap)object;
        if (objectFloatMap.size != this.size) {
            return false;
        }
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n = this.capacity + this.stashSize;
        for (int i = 0; i < n; ++i) {
            K k = KArray[i];
            if (k == null) continue;
            float f = objectFloatMap.get(k, 0.0f);
            if (f == 0.0f && !objectFloatMap.containsKey(k)) {
                return false;
            }
            float f2 = fArray[i];
            if (f == f2) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        K k;
        if (this.size == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('{');
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n = KArray.length;
        while (n-- > 0) {
            k = KArray[n];
            if (k == null) continue;
            stringBuilder.append(k);
            stringBuilder.append('=');
            stringBuilder.append(fArray[n]);
            break;
        }
        while (n-- > 0) {
            k = KArray[n];
            if (k == null) continue;
            stringBuilder.append(", ");
            stringBuilder.append(k);
            stringBuilder.append('=');
            stringBuilder.append(fArray[n]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public Entries<K> iterator() {
        return this.entries();
    }

    public Entries<K> entries() {
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.reset();
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    public Values values() {
        if (this.values1 == null) {
            this.values1 = new Values((ObjectFloatMap<?>)this);
            this.values2 = new Values((ObjectFloatMap<?>)this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.reset();
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    public Keys<K> keys() {
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.reset();
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Keys<K>
    extends MapIterator<K>
    implements Iterable<K>,
    Iterator<K> {
        public Keys(ObjectFloatMap<K> objectFloatMap) {
            super(objectFloatMap);
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public K next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            Object k = this.map.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return k;
        }

        @Override
        public Keys<K> iterator() {
            return this;
        }

        public Array<K> toArray() {
            Array<K> array = new Array<K>(true, this.map.size);
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }

        public Array<K> toArray(Array<K> array) {
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Values
    extends MapIterator<Object> {
        public Values(ObjectFloatMap<?> objectFloatMap) {
            super(objectFloatMap);
        }

        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        public float next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            float f = this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return f;
        }

        public FloatArray toArray() {
            FloatArray floatArray = new FloatArray(true, this.map.size);
            while (this.hasNext) {
                floatArray.add(this.next());
            }
            return floatArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entries<K>
    extends MapIterator<K>
    implements Iterable<Entry<K>>,
    Iterator<Entry<K>> {
        private Entry<K> entry = new Entry();

        public Entries(ObjectFloatMap<K> objectFloatMap) {
            super(objectFloatMap);
        }

        @Override
        public Entry<K> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            K[] KArray = this.map.keyTable;
            this.entry.key = KArray[this.nextIndex];
            this.entry.value = this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public Entries<K> iterator() {
            return this;
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapIterator<K> {
        public boolean hasNext;
        final ObjectFloatMap<K> map;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public MapIterator(ObjectFloatMap<K> objectFloatMap) {
            this.map = objectFloatMap;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        void findNextIndex() {
            this.hasNext = false;
            K[] KArray = this.map.keyTable;
            int n = this.map.capacity + this.map.stashSize;
            while (++this.nextIndex < n) {
                if (KArray[this.nextIndex] == null) continue;
                this.hasNext = true;
                break;
            }
        }

        public void remove() {
            if (this.currentIndex < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            if (this.currentIndex >= this.map.capacity) {
                this.map.removeStashIndex(this.currentIndex);
                this.nextIndex = this.currentIndex - 1;
                this.findNextIndex();
            } else {
                this.map.keyTable[this.currentIndex] = null;
            }
            this.currentIndex = -1;
            --this.map.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<K> {
        public K key;
        public float value;

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

