/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.array;

import com.fr.stable.collections.utils.MathUtils;
import java.util.Arrays;

public class CharArray {
    public char[] items;
    public int size;
    public boolean ordered;

    public CharArray() {
        this(true, 16);
    }

    public CharArray(int n) {
        this(true, n);
    }

    public CharArray(boolean bl, int n) {
        this.ordered = bl;
        this.items = new char[n];
    }

    public CharArray(CharArray charArray) {
        this.ordered = charArray.ordered;
        this.size = charArray.size;
        this.items = new char[this.size];
        System.arraycopy(charArray.items, 0, this.items, 0, this.size);
    }

    public CharArray(char[] cArray) {
        this(true, cArray, 0, cArray.length);
    }

    public CharArray(boolean bl, char[] cArray, int n, int n2) {
        this(bl, n2);
        this.size = n2;
        System.arraycopy(cArray, n, this.items, 0, n2);
    }

    public void add(char c) {
        char[] cArray = this.items;
        if (this.size == cArray.length) {
            cArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        cArray[this.size++] = c;
    }

    public void addAll(CharArray charArray) {
        this.addAll(charArray, 0, charArray.size);
    }

    public void addAll(CharArray charArray, int n, int n2) {
        if (n + n2 > charArray.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + n + " + " + n2 + " <= " + charArray.size);
        }
        this.addAll(charArray.items, n, n2);
    }

    public void addAll(char ... cArray) {
        this.addAll(cArray, 0, cArray.length);
    }

    public void addAll(char[] cArray, int n, int n2) {
        int n3 = this.size + n2;
        char[] cArray2 = this.items;
        if (n3 > cArray2.length) {
            cArray2 = this.resize(Math.max(8, (int)((float)n3 * 1.75f)));
        }
        System.arraycopy(cArray, n, cArray2, this.size, n2);
        this.size += n2;
    }

    public char get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        return this.items[n];
    }

    public void set(int n, char c) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        this.items[n] = c;
    }

    public void incr(int n, char c) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        int n2 = n;
        this.items[n2] = (char)(this.items[n2] + c);
    }

    public void mul(int n, char c) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        int n2 = n;
        this.items[n2] = (char)(this.items[n2] * c);
    }

    public void insert(int n, char c) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + n + " > " + this.size);
        }
        char[] cArray = this.items;
        if (this.size == cArray.length) {
            cArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(cArray, n, cArray, n + 1, this.size - n);
        } else {
            cArray[this.size] = cArray[n];
        }
        ++this.size;
        cArray[n] = c;
    }

    public void swap(int n, int n2) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + n + " >= " + this.size);
        }
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + n2 + " >= " + this.size);
        }
        char[] cArray = this.items;
        char c = cArray[n];
        cArray[n] = cArray[n2];
        cArray[n2] = c;
    }

    public boolean contains(char c) {
        int n = this.size - 1;
        char[] cArray = this.items;
        while (n >= 0) {
            if (cArray[n--] != c) continue;
            return true;
        }
        return false;
    }

    public int indexOf(char c) {
        char[] cArray = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] != c) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char c) {
        char[] cArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (cArray[i] != c) continue;
            return i;
        }
        return -1;
    }

    public boolean removeValue(char c) {
        char[] cArray = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] != c) continue;
            this.removeIndex(i);
            return true;
        }
        return false;
    }

    public char removeIndex(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        char[] cArray = this.items;
        char c = cArray[n];
        --this.size;
        if (this.ordered) {
            System.arraycopy(cArray, n + 1, cArray, n, this.size - n);
        } else {
            cArray[n] = cArray[this.size];
        }
        return c;
    }

    public void removeRange(int n, int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + n2 + " >= " + this.size);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("start can't be > end: " + n + " > " + n2);
        }
        char[] cArray = this.items;
        int n3 = n2 - n + 1;
        if (this.ordered) {
            System.arraycopy(cArray, n + n3, cArray, n, this.size - (n + n3));
        } else {
            int n4 = this.size - 1;
            for (int i = 0; i < n3; ++i) {
                cArray[n + i] = cArray[n4 - i];
            }
        }
        this.size -= n3;
    }

    public boolean removeAll(CharArray charArray) {
        int n;
        int n2 = n = this.size;
        char[] cArray = this.items;
        int n3 = charArray.size;
        block0: for (int i = 0; i < n3; ++i) {
            char c = charArray.get(i);
            for (int j = 0; j < n; ++j) {
                if (c != cArray[j]) continue;
                this.removeIndex(j);
                --n;
                continue block0;
            }
        }
        return n != n2;
    }

    public char pop() {
        return this.items[--this.size];
    }

    public char peek() {
        return this.items[this.size - 1];
    }

    public char first() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[0];
    }

    public void clear() {
        this.size = 0;
    }

    public char[] shrink() {
        if (this.items.length != this.size) {
            this.resize(this.size);
        }
        return this.items;
    }

    public char[] ensureCapacity(int n) {
        int n2 = this.size + n;
        if (n2 > this.items.length) {
            this.resize(Math.max(8, n2));
        }
        return this.items;
    }

    public char[] setSize(int n) {
        if (n > this.items.length) {
            this.resize(Math.max(8, n));
        }
        this.size = n;
        return this.items;
    }

    protected char[] resize(int n) {
        char[] cArray = new char[n];
        char[] cArray2 = this.items;
        System.arraycopy(cArray2, 0, cArray, 0, Math.min(this.size, cArray.length));
        this.items = cArray;
        return cArray;
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public void reverse() {
        char[] cArray = this.items;
        int n = this.size - 1;
        int n2 = this.size / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - i;
            char c = cArray[i];
            cArray[i] = cArray[n3];
            cArray[n3] = c;
        }
    }

    public void shuffle() {
        char[] cArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            int n = MathUtils.random(i);
            char c = cArray[i];
            cArray[i] = cArray[n];
            cArray[n] = c;
        }
    }

    public void truncate(int n) {
        if (this.size > n) {
            this.size = n;
        }
    }

    public char random() {
        if (this.size == 0) {
            return '\u0000';
        }
        return this.items[MathUtils.random(0, this.size - 1)];
    }

    public char[] toArray() {
        char[] cArray = new char[this.size];
        System.arraycopy(this.items, 0, cArray, 0, this.size);
        return cArray;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        char[] cArray = this.items;
        int n = 1;
        int n2 = this.size;
        for (int i = 0; i < n2; ++i) {
            n = n * 31 + cArray[i];
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof CharArray)) {
            return false;
        }
        CharArray charArray = (CharArray)object;
        if (!charArray.ordered) {
            return false;
        }
        int n = this.size;
        if (n != charArray.size) {
            return false;
        }
        char[] cArray = this.items;
        char[] cArray2 = charArray.items;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        char[] cArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(cArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(cArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String string) {
        if (this.size == 0) {
            return "";
        }
        char[] cArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(cArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(cArray[i]);
        }
        return stringBuilder.toString();
    }

    public static CharArray with(char ... cArray) {
        return new CharArray(cArray);
    }
}

