/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable;

import com.fr.stable.ArrayUtils;
import com.fr.stable.DebugAssistant;
import com.fr.stable.FCloneable;
import com.fr.stable.FormulaProvider;
import com.fr.stable.LicUtils;
import com.fr.stable.ListMap;
import com.fr.stable.Mapper;
import com.fr.stable.OperationUtils;
import com.fr.stable.Primitive;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.collections.map.IntMap;
import com.fr.stable.collections.map.ObjectIntMap;
import com.fr.stable.fun.WebLocaleProvider;
import com.fr.stable.plugin.ExtraClassManagerProvider;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.CalculatorProviderContext;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freehep.graphicsio.swf.SWFGraphics2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StableUtils {
    public static final String RESOURCE_ENCODER = "UTF-8";
    private static ClassLoader coreLoader;
    private static final int KEY_LENGTH = 26;
    private static final int DECIMAL_TEN = 10;
    private static final int HEX_STRING_MIN_LEN = 4;
    private static int[] charPosition;
    private static final char[] DIGITS;
    private static final char[] DIGITS_CASE_SENSITIVE;
    private static transient IntMap<String> TEMP_ABC_COLUMN_MAP;
    private static transient ObjectIntMap<String> TEMP_INT_COLUMN_MAP;
    private static char ZERO;
    private static char NINE;
    private static char NA;
    private static char PL;
    private static char DOT;
    private static char UE;
    private static char LE;
    private static final int MAJOR_JAVA_VERSION;

    private StableUtils() {
    }

    public static boolean checkDesignerActive(String string) {
        return string != null && string.length() == 26 && string.charAt(charPosition[0]) == 'A' && string.charAt(charPosition[1]) == 'F';
    }

    public static String[] pathSplit(String string) {
        return string.split("[/\\\\]");
    }

    public static String join(Collection collection, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            stringBuffer.append(e);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String join(Object[] objectArray, String string) {
        return StableUtils.join(Arrays.asList(objectArray), string);
    }

    public static String join(Object[] objectArray) {
        return StableUtils.join(objectArray, "");
    }

    public static String doubleToString(double d) {
        return StableUtils.convertNumberStringToString(d);
    }

    public static String convertNumberStringToString(Number number) {
        return StableUtils.convertNumberStringToString(number, false);
    }

    public static String checkInfinity(Object object) {
        if (OperationUtils.POSITIVE_INFINITY.equals(object)) {
            return "\u221e";
        }
        if (OperationUtils.NEGATIVE_INFINITY.equals(object)) {
            return "-\u221e";
        }
        return "";
    }

    public static String checkInfinity(double d) {
        if (Double.POSITIVE_INFINITY == d) {
            return "\u221e";
        }
        if (Double.NEGATIVE_INFINITY == d) {
            return "-\u221e";
        }
        return "";
    }

    public static String checkDoubleInfinity(double d) {
        if (Double.POSITIVE_INFINITY == d) {
            return "\u221e";
        }
        if (Double.NEGATIVE_INFINITY == d) {
            return "-\u221e";
        }
        return null;
    }

    public static String convertNumberStringToString(double d) {
        String string = StableUtils.checkDoubleInfinity(d);
        if (string != null) {
            return string;
        }
        String string2 = Double.toString(d);
        int n = string2.indexOf(46);
        if (n < 0) {
            return string2;
        }
        int n2 = string2.indexOf(69);
        if ((n = (string2 = StableUtils.stringAfterCheckE(string2, n, n2)).indexOf(".")) == -1) {
            if (string2.endsWith(".0")) {
                string2 = string2.substring(0, string2.length() - 2);
            }
            return string2;
        }
        String string3 = string2.substring(n + 1);
        int n3 = string3.indexOf("9999");
        if (n3 >= 0) {
            return StableUtils.processCalPrecision(d, string2, n, n3);
        }
        n3 = string3.indexOf("0000");
        if (n3 >= 0 && n2 == -1) {
            string2 = string2.substring(0, n + Math.max(n3, 1) + 1);
        }
        if (string2.endsWith(".0")) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        return string2;
    }

    private static String processCalPrecision(double d, String string, int n, int n2) {
        double d2 = d;
        if (n2 == 0) {
            return Long.toString(Math.round(d2));
        }
        if (Math.abs(d2) > 9.223372036854776E18) {
            String string2 = string;
            int n3 = n;
            if (n3 > 0 && string2.length() - n3 - 1 > n2) {
                string2 = string2.substring(0, n3 + n2 + 1);
            }
            if (string2.endsWith(".0")) {
                return string2.substring(0, string2.length() - 2);
            }
            return string2;
        }
        return StableUtils.getLongNumberString(string, n2, d2);
    }

    public static String convertNumberStringToString(Number number, boolean bl) {
        String string = StableUtils.checkInfinity(number);
        if (StringUtils.isNotEmpty(string)) {
            return string;
        }
        String string2 = number.toString();
        int n = string2.indexOf(46);
        if (n < 0) {
            return string2;
        }
        int n2 = string2.indexOf(69);
        string2 = StableUtils.stringAfterCheckE(string2, n, n2);
        n = string2.indexOf(46);
        if (bl || n == -1 || number instanceof BigDecimal) {
            if (string2.endsWith(".0")) {
                string2 = string2.substring(0, string2.length() - 2);
            }
            return string2;
        }
        String string3 = string2.substring(n + 1);
        int n3 = string3.indexOf("9999");
        if (n3 >= 0) {
            return StableUtils.processCalPrecisionCheckE(number, string2, n3);
        }
        n3 = string3.indexOf("0000");
        if (n3 >= 0 && n2 == -1) {
            string2 = string2.substring(0, n + Math.max(n3, 1) + 1);
        }
        if (string2.endsWith(".0")) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        return string2;
    }

    private static String processCalPrecisionCheckE(Number number, String string, int n) {
        double d = number.doubleValue();
        if (n == 0) {
            return Long.toString(Math.round(d));
        }
        if (Math.abs(d) > 9.223372036854776E18) {
            String string2 = Double.toString(d);
            int n2 = string2.indexOf(".");
            if (n2 > 0 && string2.length() - n2 - 1 > n) {
                string2 = string2.substring(0, n2 + n + 1);
            }
            if (string2.endsWith(".0")) {
                return string2.substring(0, string2.length() - 2);
            }
            return string2;
        }
        return StableUtils.getLongNumberString(string, n, d);
    }

    private static String getLongNumberString(String string, int n, double d) {
        long l;
        String string2 = d < 0.0 ? "-" : "";
        long l2 = (long)Math.pow(10.0, n - 1);
        long l3 = l2 * 10L;
        if (l2 == Long.MAX_VALUE || l3 == Long.MAX_VALUE) {
            return string;
        }
        d = Math.abs(d);
        long l4 = Math.round(d * (double)l3);
        String string3 = string2 + Long.toString(l4 / l3);
        long l5 = l = l3 == 0L ? 0L : l4 % l3;
        if (l < 0L) {
            return string;
        }
        if (l == 0L) {
            StringBuffer stringBuffer = new StringBuffer("");
            for (int i = n; i > 0; --i) {
                stringBuffer.insert(0, "0");
            }
            return string3 + "." + stringBuffer;
        }
        StringBuffer stringBuffer = new StringBuffer(Long.toString(l));
        while (l < l2) {
            l *= 10L;
            stringBuffer.insert(0, "0");
        }
        return string3 + "." + stringBuffer;
    }

    private static String stringAfterCheckE(String string, int n, int n2) {
        if (StableUtils.needConvert(n, n2, string)) {
            int n3;
            String string2 = string.substring(0, n2);
            StringBuffer stringBuffer = new StringBuffer(string2.substring(n + 1));
            stringBuffer.insert(0, string2.substring(0, n));
            String string3 = string.substring(n2 + 1);
            if (string3.startsWith("+")) {
                string3 = string3.substring(1);
            }
            if ((n3 = Integer.parseInt(string3)) <= 0) {
                while (stringBuffer.charAt(stringBuffer.length() - 1) == '0') {
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                }
                for (int i = 0; i < -n3; ++i) {
                    stringBuffer.insert(n - 1, "0");
                }
                stringBuffer.insert(n, ".");
            } else if (stringBuffer.length() - n > n3) {
                stringBuffer.insert(n3 + n, '.');
            } else {
                while (stringBuffer.length() - n < n3) {
                    stringBuffer.append('0');
                }
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private static boolean needConvert(int n, int n2, String string) {
        return n == 1 && n2 > 0 || n == 2 && n2 > 0 && (string.startsWith("-") || string.startsWith("+"));
    }

    public static boolean isNum(char c) {
        return c >= ZERO && c <= NINE;
    }

    public static boolean isNumber(String string) {
        int n = string.length();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == DOT) {
                if (bl) {
                    return false;
                }
                bl = true;
            }
            if (c == UE || c == LE) {
                if (bl2) {
                    return false;
                }
                bl2 = true;
            }
            if (c == PL) {
                if (bl3) {
                    return false;
                }
                bl3 = true;
                if (!bl2) {
                    return false;
                }
            }
            if (StableUtils.isNum(c) || c == DOT || c == UE || c == LE || c == NA || c == PL) continue;
            return false;
        }
        return true;
    }

    public static Number string2Number(String string) {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        if (StableUtils.isStartWithZeroAndCannotbeDecimal(string = StableUtils.getString(string))) {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == DOT) {
                if (bl || i == n - 1) {
                    return null;
                }
                bl = true;
            }
            if (c == UE || c == LE) {
                if (bl2) {
                    return null;
                }
                bl2 = true;
            }
            if (c == PL) {
                if (bl3) {
                    return null;
                }
                bl3 = true;
                if (!bl2) {
                    return null;
                }
            }
            if (c == NA) {
                bl4 = true;
            }
            if (StableUtils.isNum(c) || c == DOT || c == UE || c == LE || c == NA || c == PL) continue;
            return null;
        }
        return StableUtils.getNumber(string, bl, bl2, bl4, n);
    }

    private static String getString(String string) {
        if (string.startsWith("+")) {
            string = string.substring(1, string.length());
        }
        return string;
    }

    private static Number getNumber(String string, boolean bl, boolean bl2, boolean bl3, int n) {
        boolean bl4;
        if (bl2) {
            try {
                return new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (bl) {
            try {
                return new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        boolean bl5 = bl4 = n < 10 || n == 10 && bl3;
        if (bl4) {
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return new BigInteger(string);
                }
                catch (NumberFormatException numberFormatException2) {
                    return null;
                }
            }
        }
        try {
            return new BigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static boolean isStartWithZeroAndCannotbeDecimal(String string) {
        return string.startsWith("0") && string.length() > 1 && !string.startsWith("0E") && !string.startsWith("0.") || string.startsWith("-0") && string.length() > 2 && !string.startsWith("-0E") && !string.startsWith("-0.");
    }

    public static String replaceAllString(String string, String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            string = StableUtils.replaceAllString(string, stringArray[i], stringArray2[i]);
        }
        return string;
    }

    public static String replaceAllString(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("\\Q" + string2 + "\\E", StableUtils.filterString(string3));
    }

    private static String filterString(String string) {
        if (string.indexOf(36) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '$') {
                stringBuffer.append("\\$");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String javaColorToCSSColor(Color color) {
        if (color == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("rgb(");
        stringBuffer.append(color.getRed());
        stringBuffer.append(',');
        stringBuffer.append(color.getGreen());
        stringBuffer.append(',');
        stringBuffer.append(color.getBlue());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String javaColor2JSColorWithAlpha(Color color) {
        if (color == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("rgba(");
        stringBuffer.append(color.getRed());
        stringBuffer.append(',');
        stringBuffer.append(color.getGreen());
        stringBuffer.append(',');
        stringBuffer.append(color.getBlue());
        stringBuffer.append(',');
        stringBuffer.append((double)color.getAlpha() / 255.0);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String javaColor2String(Color color) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((double)color.getRed() / 255.0);
        stringBuffer.append(",");
        stringBuffer.append((double)color.getGreen() / 255.0);
        stringBuffer.append(",");
        stringBuffer.append((double)color.getBlue() / 255.0);
        stringBuffer.append(",");
        stringBuffer.append((double)color.getAlpha() / 255.0);
        stringBuffer.append(",");
        return stringBuffer.toString();
    }

    public static int changeImageLayout4Draw(Image image, int n, int n2, int n3) {
        if (image != null && n == 1 && (image.getWidth(null) > n2 || image.getHeight(null) > n3)) {
            n = 0;
        }
        return n;
    }

    public static String readSpecailString(String string) throws Exception {
        if (string == null) {
            return "";
        }
        Pattern pattern = Pattern.compile("\\\\");
        Matcher matcher = pattern.matcher(string);
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find(n)) {
            n = matcher.start();
            stringBuffer.append(string.substring(n2, n));
            n2 = matcher.end();
            String string2 = string.substring(n2);
            if (string2.length() == 0) {
                throw new Exception("\\ can't be parsed.");
            }
            n = n2 = StableUtils.endOffsetByFirstChar(string, n2, stringBuffer, string2);
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    private static int endOffsetByDefaultFirstChar(String string, int n, StringBuffer stringBuffer, String string2) throws Exception {
        int n2 = 0;
        if (string2.matches("[0-3][0-7][0-7].*")) {
            n2 = 3;
        } else if (string2.matches("[0-7][0-7].*")) {
            n2 = 2;
        } else if (string2.matches("[0-7].*")) {
            n2 = 1;
        }
        if (n2 <= 0) {
            throw new Exception("\\" + string2 + " can't be parsed.");
        }
        stringBuffer.append(StableUtils.parseOctal(string.substring(n, n + n2)));
        return n += n2;
    }

    private static int endOffsetByFirstChar(String string, int n, StringBuffer stringBuffer, String string2) throws Exception {
        char c = string2.charAt(0);
        switch (c) {
            case 'n': {
                stringBuffer.append('\n');
                ++n;
                break;
            }
            case 'r': {
                stringBuffer.append('\r');
                ++n;
                break;
            }
            case 't': {
                stringBuffer.append('\t');
                ++n;
                break;
            }
            case 'b': {
                stringBuffer.append('\b');
                ++n;
                break;
            }
            case 'f': {
                stringBuffer.append('\f');
                ++n;
                break;
            }
            case '\"': {
                stringBuffer.append('\"');
                ++n;
                break;
            }
            case '\'': {
                stringBuffer.append('\'');
                ++n;
                break;
            }
            case '\\': {
                stringBuffer.append('\\');
                ++n;
                break;
            }
            case 'u': {
                String string3 = string.substring(n);
                if (string3.length() < 4) {
                    throw new Exception("\\u" + string3 + " can't be parsed.");
                }
                stringBuffer.append(StableUtils.parseHex(string3.substring(0, 4)));
                n = n + 4 + 1;
                break;
            }
            default: {
                n = StableUtils.endOffsetByDefaultFirstChar(string, n, stringBuffer, string2);
            }
        }
        return n;
    }

    private static char parseHex(String string) {
        return (char)Integer.decode("0x" + string).intValue();
    }

    private static char parseOctal(String string) {
        return (char)Integer.decode('0' + string).intValue();
    }

    public static String writeSpecialString(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block10: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block10;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block10;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block10;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block10;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block10;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block10;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block10;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block10;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static Method getDeclaredMethod(Class clazz, String string, Class[] classArray) {
        try {
            return clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            clazz = clazz.getSuperclass();
            if (clazz != null) {
                return StableUtils.getDeclaredMethod(clazz, string, classArray);
            }
            return null;
        }
    }

    public static String pathJoin(String ... stringArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n = stringArray == null ? 0 : stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (string == null) {
                string = "";
            }
            if (i > 0 && (string.startsWith("/") || string.startsWith("\\"))) {
                string = string.substring(1);
            }
            stringBuffer.append(string);
            if (i + 1 >= n || string.endsWith("/") || string.endsWith("\\")) continue;
            stringBuffer.append("/");
        }
        return stringBuffer.toString();
    }

    public static String[] splitString(String string, String string2) {
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        return string.split("\\Q" + string2 + "\\E");
    }

    public static String[] splitString(String string, char c) {
        return StableUtils.splitString(string, "" + c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int convertABCToInt(String string) {
        int n = TEMP_INT_COLUMN_MAP.get(string, -1);
        if (n == -1) {
            ObjectIntMap<String> objectIntMap = TEMP_INT_COLUMN_MAP;
            synchronized (objectIntMap) {
                n = TEMP_INT_COLUMN_MAP.get(string, -1);
                if (n == -1) {
                    int n2 = 0;
                    Character c = new Character('A');
                    string = string.toUpperCase();
                    int n3 = string.length();
                    for (int i = 0; i < n3; ++i) {
                        n2 = Character.getNumericValue(string.charAt(i)) - Character.getNumericValue(c.charValue()) + 26 * n2 + 1;
                        if (n2 <= (0x7FFFFFFE - Character.getNumericValue(string.charAt(i)) + Character.getNumericValue(c.charValue())) / 26) continue;
                        n2 = 0;
                        break;
                    }
                    n = n2;
                    TEMP_INT_COLUMN_MAP.put(string, n);
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertIntToABC(int n) {
        String string = TEMP_ABC_COLUMN_MAP.get(n);
        if (string == null) {
            IntMap<String> intMap = TEMP_ABC_COLUMN_MAP;
            synchronized (intMap) {
                string = TEMP_ABC_COLUMN_MAP.get(n);
                if (string == null) {
                    int n2 = n;
                    StringBuffer stringBuffer = new StringBuffer();
                    if (n2 == 0) {
                        string = "";
                    } else {
                        while (n2 != 0) {
                            int n3 = n2 % 26;
                            if (n3 == 0) {
                                n3 = 26;
                            }
                            stringBuffer.insert(0, DIGITS[n3 - 1]);
                            n2 = (n2 - n3) / 26;
                        }
                        string = stringBuffer.toString();
                    }
                    TEMP_ABC_COLUMN_MAP.put(n, string);
                }
            }
        }
        return string;
    }

    public static String replaceScript4Xss(String string) {
        if (StringUtils.isEmpty(string)) {
            return "";
        }
        Pattern pattern = Pattern.compile("<[^>]+>", 2);
        Matcher matcher = pattern.matcher(string);
        string = matcher.replaceAll("");
        pattern = Pattern.compile("<[/s]*?script[^>]*?>[/s/S]*?<[/s]*?//[/s]*?script[/s]*?>", 2);
        matcher = pattern.matcher(string);
        string = matcher.replaceAll("");
        return string;
    }

    public static boolean isDebug() {
        DebugAssistant debugAssistant = StableFactory.getMarkedObject(DebugAssistant.class.getName(), DebugAssistant.class);
        return debugAssistant != null && debugAssistant.requireDebug();
    }

    public static String getInstallHome() {
        String string = System.getProperty("user.dir");
        if (string == null) {
            return ".";
        }
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            String[] stringArray;
            for (String string2 : stringArray = file.list()) {
                if (!string2.contains("designer.exe") && !string2.contains("designer.app")) continue;
                return file.getParent();
            }
        }
        return ".";
    }

    public static <T> T getInstance(Class<? extends T> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("getInstance", new Class[0]);
            method.setAccessible(true);
            return (T)method.invoke(clazz, new Object[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static void clearInstance(Class clazz) {
        try {
            Method method = clazz.getDeclaredMethod("clear", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)clazz, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static <T> T construct(Class<? extends T> clazz, Object ... objectArray) {
        try {
            if (objectArray == null) {
                return null;
            }
            Class[] classArray = new Class[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                classArray[i] = objectArray[i].getClass();
            }
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                Constructor<?> constructor = constructorArray[i];
                Class<?>[] classArray2 = constructor.getParameterTypes();
                if (!StableUtils.classesTypeEquals(classArray2, classArray)) continue;
                constructor.setAccessible(true);
                return (T)constructor.newInstance(objectArray);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static boolean classesTypeEquals(Class<?>[] classArray, Class<?>[] classArray2) {
        if (classArray == classArray2) {
            return true;
        }
        if (classArray == null || classArray2 == null) {
            return false;
        }
        if (classArray.length != classArray2.length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (StableUtils.classTypeEquals(classArray[i], classArray2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean classTypeEquals(Class<?> clazz, Class<?> clazz2) {
        if (clazz == clazz2) {
            return true;
        }
        return StableUtils.dealWithBaseType(clazz) == StableUtils.dealWithBaseType(clazz2);
    }

    private static Class<?> dealWithBaseType(Class<?> clazz) {
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        return clazz;
    }

    public static boolean deleteFile(File file) {
        if (file == null || !file.exists()) {
            return true;
        }
        boolean bl = true;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (StableUtils.deleteFile(fileArray[i]) || !bl) continue;
                bl = false;
            }
        }
        bl = file.delete() && bl;
        return bl;
    }

    public static void forceDelete(File file) {
    }

    public static boolean mkdirs(File file) {
        return file.exists() || file.mkdirs();
    }

    public static boolean makesureFileExist(File file) throws IOException {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return true;
        }
        StableUtils.mkdirs(file.getParentFile());
        file.createNewFile();
        return true;
    }

    public static File createDistinctFile(String string, String string2) throws IOException {
        int n = 0;
        File file = new File(string, string2);
        while (file.exists()) {
            file = new File(string, StableUtils.getFileNameWithOutPostfix(string2) + "(" + ++n + ")" + StableUtils.getFileNamePostfix(string2));
        }
        StableUtils.mkdirs(file.getParentFile());
        file.createNewFile();
        return file;
    }

    public static String getFileNameWithOutPostfix(String string) throws IOException {
        int n;
        if (StringUtils.isNotEmpty(string) && (n = string.lastIndexOf(".")) != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String getFileNamePostfix(String string) throws IOException {
        int n;
        if (StringUtils.isNotEmpty(string) && (n = string.lastIndexOf(".")) != -1) {
            return string.substring(n);
        }
        return "";
    }

    public static List map(List list, Mapper mapper) {
        int n = list.size();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = mapper.map(i, list.get(i), list);
        }
        return Arrays.asList(objectArray);
    }

    public static boolean maybeFormula(String string) {
        return StringUtils.isNotBlank(string) && string.startsWith("=");
    }

    public static int getMajorJavaVersion() {
        return MAJOR_JAVA_VERSION;
    }

    public static boolean isNotSupportARGB(Graphics graphics) {
        return graphics instanceof SWFGraphics2D;
    }

    public static Object invokeMethod(ClassLoader classLoader, String string, String string2, Class[] classArray, Object[] objectArray) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return null;
        }
        try {
            Class<?> clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
            Method method = clazz.getMethod(string2, classArray);
            method.setAccessible(true);
            return method.invoke(clazz, objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object invokeMethod(String string, String string2, Class[] classArray, Object[] objectArray) {
        return StableUtils.invokeMethod(null, string, string2, classArray, objectArray);
    }

    public static Object invokeMethod(ClassLoader classLoader, String string, String string2) {
        return StableUtils.invokeMethod(classLoader, string, string2, new Class[0], new Object[0]);
    }

    public static Object invokeMethod(String string, String string2) {
        return StableUtils.invokeMethod(string, string2, new Class[0], new Object[0]);
    }

    public static byte[] getBytes() {
        return LicUtils.getBytes();
    }

    public static String getFileTypeFromBytes(byte[] byArray) {
        String string = new String(byArray);
        if (string.startsWith("GIF")) {
            return ".gif";
        }
        if (string.startsWith("PNG", 1)) {
            return ".png";
        }
        if (string.indexOf("PDF") >= 0) {
            return ".pdf";
        }
        if (string.startsWith("Rar")) {
            return ".rar";
        }
        if (string.startsWith("PK")) {
            return ".zip";
        }
        if (string.indexOf("Exif") >= 0 || string.indexOf("JFIF") >= 0) {
            return ".jpg";
        }
        if (string.startsWith("BM")) {
            return ".bmp";
        }
        return ".txt";
    }

    public static String inputStream2String(InputStream inputStream, String string) throws IOException {
        String string2;
        if (inputStream == null) {
            return "";
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static void dealFormulaValue(Object object, CalculatorProvider calculatorProvider) {
        Object object2 = null;
        if (object instanceof FormulaProvider) {
            FormulaProvider formulaProvider = (FormulaProvider)object;
            String string = formulaProvider.getContent();
            if (string.startsWith("=")) {
                string = string.substring(1);
            }
            if (StringUtils.isEmpty(string) || StringUtils.isBlank(string)) {
                return;
            }
            if (calculatorProvider == null) {
                calculatorProvider = CalculatorProviderContext.getCalculatorProvider();
            }
            try {
                object2 = calculatorProvider.evalValue(string);
            }
            catch (UtilEvalError utilEvalError) {
                String string2 = "Formula Error";
                object2 = string;
            }
            formulaProvider.setResult(object2);
        }
    }

    public static Object cloneObject(Object object) throws CloneNotSupportedException {
        if (object instanceof FCloneable) {
            return ((FCloneable)object).clone();
        }
        if (object instanceof Cloneable) {
            Method method = StableUtils.getDeclaredMethod(object.getClass(), "clone", new Class[0]);
            method.setAccessible(true);
            try {
                return method.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object;
    }

    public static HashSet<String> cloneHashSet(HashSet<String> hashSet) {
        if (hashSet == null) {
            return null;
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        for (String string : hashSet) {
            hashSet2.add(string);
        }
        return hashSet2;
    }

    public static HashMap<String, Object> cloneHashMap(HashMap<String, Object> hashMap) {
        if (hashMap == null) {
            return null;
        }
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : hashMap.entrySet()) {
            hashMap2.put(entry.getKey(), entry.getValue());
        }
        return hashMap2;
    }

    public static ListMap cloneListMap(ListMap listMap) throws CloneNotSupportedException {
        if (listMap == null) {
            return null;
        }
        ListMap<Object, Object> listMap2 = new ListMap<Object, Object>();
        for (Object e : listMap.entrySet()) {
            Map.Entry entry = (Map.Entry)e;
            listMap2.put(StableUtils.cloneObject(entry.getKey()), StableUtils.cloneObject(entry.getValue()));
        }
        return listMap2;
    }

    public static boolean isArray(Object object) {
        return object != null && object.getClass().isArray();
    }

    public static boolean isNull(Object object) {
        return object == null || object == Primitive.NULL || object instanceof FormulaProvider && StableUtils.isNull(((FormulaProvider)object).getResult());
    }

    public static void setPrivateFieldValue(Object object, String string, Object object2) throws Exception {
        Class<?> clazz = object.getClass();
        while (!clazz.equals(Object.class)) {
            try {
                Field field = clazz.getDeclaredField(string);
                field.setAccessible(true);
                field.set(object, object2);
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (!(clazz = clazz.getSuperclass()).equals(Object.class)) continue;
                throw noSuchFieldException;
            }
        }
    }

    public static Object getPrivateFieldValue(Object object, String string) throws Exception {
        Class<?> clazz = object.getClass();
        Object object2 = null;
        while (!clazz.equals(Object.class)) {
            try {
                Field field = clazz.getDeclaredField(string);
                field.setAccessible(true);
                object2 = field.get(object);
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (!(clazz = clazz.getSuperclass()).equals(Object.class)) continue;
                throw noSuchFieldException;
            }
        }
        return object2;
    }

    public static boolean canBeFormula(Object object) {
        return object != null && object.toString().trim().startsWith("=");
    }

    public static void executeContextTimer() {
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            public void run() {
                StableUtils.invokeMethod(coreLoader, "com.fr.general.GeneralUtils", "checkContext");
                timer.cancel();
            }
        }, 1000L);
    }

    public static String getRandomStr(int n) {
        Random random = new Random();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            int n2 = random.nextInt(52);
            cArray[i] = DIGITS_CASE_SENSITIVE[n2];
        }
        return new String(cArray);
    }

    public static Locale createLocale(String string) {
        String[] stringArray;
        Locale locale = null;
        ExtraClassManagerProvider extraClassManagerProvider = StableFactory.getMarkedObject("ExtraClassManager", ExtraClassManagerProvider.class);
        if (extraClassManagerProvider != null) {
            stringArray = extraClassManagerProvider.getArray("WebLocaleProvider");
            for (WebLocaleProvider webLocaleProvider : stringArray) {
                locale = webLocaleProvider.dispatchLocale(string);
                if (locale == null) continue;
                return locale;
            }
        }
        if (StringUtils.isNotBlank(string)) {
            stringArray = string.split("_");
            locale = stringArray.length > 1 ? new Locale(stringArray[0], stringArray[1]) : new Locale(stringArray[0], "");
        }
        return locale;
    }

    public static boolean classInstanceOf(Class clazz, Class clazz2) {
        if (clazz == null || clazz2 == null) {
            return false;
        }
        return clazz2.isAssignableFrom(clazz);
    }

    public static boolean objectInstanceOf(Object object, Class clazz) {
        if (object == null || clazz == null) {
            return false;
        }
        return clazz.isInstance(object);
    }

    public static boolean isMatchOnline() {
        return LicUtils.isMatchOnline();
    }

    static {
        charPosition = new int[]{5, 15};
        DIGITS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        DIGITS_CASE_SENSITIVE = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        TEMP_ABC_COLUMN_MAP = new IntMap();
        TEMP_INT_COLUMN_MAP = new ObjectIntMap();
        String[] stringArray = StableUtils.class.getResource("StableUtils.class");
        coreLoader = stringArray.toString().startsWith("jar:file") ? StableUtils.class.getClassLoader() : StableUtils.class.getClassLoader();
        ZERO = "0".charAt(0);
        NINE = "9".charAt(0);
        NA = "-".charAt(0);
        PL = "+".charAt(0);
        DOT = ".".charAt(0);
        UE = "E".charAt(0);
        LE = "e".charAt(0);
        stringArray = System.getProperty("java.version").split("\\.");
        MAJOR_JAVA_VERSION = ArrayUtils.getLength(stringArray) > 1 ? Integer.parseInt(stringArray[1]) : 1;
    }
}

