/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin;

import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.fun.Level;
import com.fr.stable.plugin.PluginErrorCollectorProvider;
import java.util.HashSet;
import java.util.Set;

public class PluginCollector
implements PluginErrorCollectorProvider {
    private static PluginCollector collector;
    private Set<String> errors = new HashSet<String>();

    public static PluginCollector getCollector() {
        return collector;
    }

    private void envChanged() {
        this.errors.clear();
    }

    public boolean isCorrect(Level level, int n, String string) {
        return !this.isError(level, n, string);
    }

    public boolean isError(Level level, int n, String string) {
        if (level.currentAPILevel() < n) {
            this.collect(string);
            return true;
        }
        return false;
    }

    private void collect(String string) {
        this.errors.add(string);
    }

    public String[] getErrorPlugins() {
        return this.errors.toArray(new String[this.errors.size()]);
    }

    static {
        GeneralContext.addEnvWillChangedListener(PluginCollector.class.getName(), new EnvChangedListener(){

            public void envChanged() {
                collector.envChanged();
            }
        });
        collector = new PluginCollector();
    }
}

