/*
 * Decompiled with CFR 0.152.
 */
package com.fr.module;

import com.fr.base.DefaultNameSpace;
import com.fr.general.ModuleContext;
import com.fr.module.TopModule;
import com.fr.plugin.ExtraClassManager;
import com.fr.stable.ArrayUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.bridge.event.StableFactoryMessageTransponder;
import com.fr.stable.bridge.event.StableFactoryProducer;
import com.fr.stable.bridge.event.StableFactoryResourceType;
import com.fr.stable.fun.CssFileHandler;
import com.fr.stable.fun.JavaScriptFileHandler;
import com.fr.stable.fun.Service;
import com.fr.stable.web.WebletCreator;
import com.fr.web.core.A.AD;
import com.fr.web.core.ReportDispatcher;
import com.fr.web.factory.WebUnitManager;
import com.fr.web.factory.WebletFactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class ServerModule
extends TopModule {
    private Set<StableFactoryProducer> producers = new HashSet<StableFactoryProducer>();

    public void start() {
        super.start();
        StableFactory.registerMarkedObject("com.fr.stable.script.NameSpace", DefaultNameSpace.getInstance());
        Service[] serviceArray = ArrayUtils.addAll(ExtraClassManager.getInstance().getServices(), this.service4Register());
        ReportDispatcher.registerGroupService(serviceArray);
        WebletCreator[] webletCreatorArray = this.webletCreator4Register();
        int n = webletCreatorArray.length;
        for (int i = 0; i < n; ++i) {
            WebletFactory.registerWebletCreator(webletCreatorArray[i]);
        }
        StableFactory.registerMarkedObject("AttachmentIDCreator", new AD());
        this.registerStableFactoryProducer();
        this.registerJavaScriptFiles();
        this.registerStyleFiles();
        StableFactory.registerStyleFiles("finereport.css", this.getCssFiles4WebClient());
        StableFactory.registerStyleFiles("finereport.css", this.getExtraCssFiles());
        WebUnitManager.getInstance().registerFiles4WebUnitTest(this.getFiles4WebUnitTest());
        StableFactory.registerLocaleFile(this.getLocaleFile());
        ModuleContext.registerStartedModule(ServerModule.class.getName(), this);
    }

    private void registerStyleFiles() {
        StableFactory.registerStyleFiles("finereport.css", this.getCssFiles4WebClient());
        StableFactory.registerStyleFiles("finereport.css", this.getExtraCssFiles());
    }

    private void registerJavaScriptFiles() {
        StableFactory.registerJavaScriptFiles("finereport.js", this.getFiles4WebClient());
        StableFactory.registerJavaScriptFiles("finereport.js", this.getExtraJavaScriptFiles());
        StableFactory.registerJavaScriptFiles("finereport.chart.js", this.getChartFiles4WebClient());
        StableFactory.registerJavaScriptFiles("chart_ie", this.getChartFiles4IEWebClient());
    }

    protected void registerStableFactoryProducer(StableFactoryProducer stableFactoryProducer, StableFactoryResourceType[] stableFactoryResourceTypeArray) {
        this.producers.add(stableFactoryProducer);
        StableFactoryMessageTransponder.getInstance().addProducer(stableFactoryProducer, stableFactoryResourceTypeArray);
    }

    public void stop() {
        this.removeRegisteredProducers();
    }

    protected void removeRegisteredProducers() {
        for (StableFactoryProducer stableFactoryProducer : this.producers) {
            StableFactoryMessageTransponder.getInstance().removeProducer(stableFactoryProducer);
        }
    }

    private void registerStableFactoryProducer() {
        this.registerStableFactoryProducer(new StableFactoryProducer(){

            public void reInject(StableFactoryResourceType stableFactoryResourceType) {
                if (StableFactoryResourceType.TYPE_JS.equals((Object)stableFactoryResourceType)) {
                    ServerModule.this.registerJavaScriptFiles();
                } else if (StableFactoryResourceType.TYPE_CSS.equals((Object)stableFactoryResourceType)) {
                    ServerModule.this.registerStyleFiles();
                }
            }
        }, new StableFactoryResourceType[]{StableFactoryResourceType.TYPE_JS, StableFactoryResourceType.TYPE_CSS});
    }

    private String[] getExtraJavaScriptFiles() {
        Set set = ExtraClassManager.getInstance().getArray("JavaScriptFileHandler");
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (JavaScriptFileHandler javaScriptFileHandler : set) {
            linkedHashSet.addAll(Arrays.asList(javaScriptFileHandler.pathsForFiles()));
        }
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    private String[] getExtraCssFiles() {
        Set set = ExtraClassManager.getInstance().getArray("CssFileHandler");
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (CssFileHandler cssFileHandler : set) {
            linkedHashSet.addAll(Arrays.asList(cssFileHandler.pathsForFiles()));
        }
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    public abstract Service[] service4Register();

    public abstract WebletCreator[] webletCreator4Register();

    public abstract String[] getFiles4WebUnitTest();

    public abstract String[] getFiles4WebClient();

    public abstract String[] getChartFiles4WebClient();

    public abstract String[] getChartFiles4IEWebClient();

    public abstract String[] getCssFiles4WebClient();
}

