/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.GraphHelper;
import com.fr.general.ComparatorUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;

public class Connector
implements XMLable {
    private int unit = 5;
    private static final long serialVersionUID = 4289688454029774161L;
    private ArrayList pointList = new ArrayList();
    private int code;

    public Connector addAll(ArrayList arrayList) {
        this.pointList.clear();
        this.pointList.addAll(arrayList);
        return this;
    }

    public Point getStartPoint() {
        return (Point)this.pointList.get(0);
    }

    public Point getEndPoint() {
        return (Point)this.pointList.get(this.pointList.size() - 1);
    }

    public int getPointCount() {
        return this.pointList.size();
    }

    public void addPoint(int n, Point point) {
        this.pointList.add(n, point);
    }

    public Point getPointIndex(int n) {
        return (Point)this.pointList.get(n);
    }

    public void checkPoint() {
        Point point;
        Point point2;
        int n;
        int n2 = this.pointList.size();
        for (n = 1; n < n2; ++n) {
            point2 = (Point)this.pointList.get(n - 1);
            point = (Point)this.pointList.get(n);
            if (point2.x != point.x || point2.y != point.y || !this.pointList.remove(point2)) continue;
            --n2;
        }
        for (n = 2; n < n2; ++n) {
            point2 = (Point)this.pointList.get(n - 2);
            point = (Point)this.pointList.get(n - 1);
            Point point3 = (Point)this.pointList.get(n);
            if ((point2.x != point.x || point2.x != point3.x) && (point2.y != point.y || point2.y != point3.y) || !this.pointList.remove(point)) continue;
            --n2;
        }
    }

    private boolean between(int n, int n2, int n3) {
        if (n2 > n3) {
            int n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        return n >= n2 && n <= n3;
    }

    private boolean isOverGo(Point point, Point point2, Rectangle rectangle) {
        if (point.x != point2.x && point.y != point2.y) {
            return false;
        }
        return point.x == point2.x && this.between(point.x, rectangle.x, rectangle.x + rectangle.width) && (this.between(rectangle.y, point.y, point2.y) || this.between(rectangle.y + rectangle.height, point.y, point2.y)) || point.y == point2.y && this.between(point.y, rectangle.y, rectangle.y + rectangle.height) && (this.between(rectangle.x, point.x, point2.x) || this.between(rectangle.x + rectangle.width, point.x, point2.x));
    }

    public boolean nearPoint(Point point) {
        int n = this.pointList.size();
        Point point2 = (Point)this.pointList.get(0);
        for (int i = 1; i < n; ++i) {
            Point point3 = (Point)this.pointList.get(i);
            if (this.isNear(point2, point3, point)) {
                return true;
            }
            point2 = point3;
        }
        return false;
    }

    private boolean isNear(Point point, Point point2, Point point3) {
        return point.x == point2.x && this.between(point3.x, point.x - this.unit, point.x + this.unit) && this.between(point3.y, point.y, point2.y) || point.y == point2.y && this.between(point3.y, point.y - this.unit, point.y + this.unit) && this.between(point3.x, point.x, point2.x);
    }

    public boolean coveredByRectangle(Rectangle rectangle) {
        int n = this.pointList.size();
        Point point = (Point)this.pointList.get(0);
        for (int i = 1; i < n; ++i) {
            Point point2 = (Point)this.pointList.get(i);
            if (this.isOverGo(point, point2, rectangle)) {
                return true;
            }
            point = point2;
        }
        return false;
    }

    public Rectangle[] getEditableLineRectangle() {
        int n = this.pointList.size();
        if (n <= 1) {
            return new Rectangle[0];
        }
        Rectangle[] rectangleArray = new Rectangle[n - 1];
        Point point = (Point)this.pointList.get(0);
        for (int i = 0; i < n - 1; ++i) {
            Point point2 = (Point)this.pointList.get(i + 1);
            rectangleArray[i] = new Rectangle(point.x, point.y, point2.x, point2.y);
            point = point2;
        }
        return rectangleArray;
    }

    public Point getMidPoint(Point point, Point point2) {
        if (point.x == point2.x) {
            return new Point(point.x, (point.y + point2.y) / 2);
        }
        return new Point((point.x + point2.x) / 2, point.y);
    }

    public Point[] getEditAblePoint() {
        int n = this.pointList.size();
        if (n <= 1) {
            return new Point[0];
        }
        ArrayList<Point> arrayList = new ArrayList<Point>();
        arrayList.add(this.getStartPoint());
        Point point = (Point)this.pointList.get(0);
        for (int i = 0; i < n - 1; ++i) {
            Point point2 = (Point)this.pointList.get(i + 1);
            arrayList.add(this.getMidPoint(point, point2));
            point = point2;
        }
        arrayList.add(this.getEndPoint());
        return arrayList.toArray(new Point[arrayList.size()]);
    }

    public void draw(Graphics graphics) {
        Point[] pointArray = this.pointList.toArray(new Point[this.pointList.size()]);
        for (int i = 0; i < pointArray.length - 1; ++i) {
            GraphHelper.drawLine(graphics, pointArray[i].x, pointArray[i].y, pointArray[i + 1].x, pointArray[i + 1].y);
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && "point".equals(xMLableReader.getTagName())) {
            this.pointList.add(new Point(xMLableReader.getAttrAsInt("x", 0), xMLableReader.getAttrAsInt("y", 0)));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        for (int i = 0; i < this.pointList.size(); ++i) {
            xMLPrintWriter.startTAG("point").attr("x", ((Point)this.pointList.get((int)i)).x).attr("y", ((Point)this.pointList.get((int)i)).y).end();
        }
    }

    public int hashCode() {
        if (this.code == 0) {
            int n;
            int n2 = 20;
            int n3 = this.pointList.get(0).hashCode();
            if (n3 > (n = this.pointList.get(this.pointList.size() - 1).hashCode())) {
                int n4 = n3;
                n3 = n;
                n = n4;
            }
            n2 = 89 * n2 + n3;
            this.code = n2 = 89 * n2 + n;
        }
        return this.code;
    }

    public boolean equals(Object object) {
        return object instanceof Connector && this.pointList.size() > 1 && ((Connector)object).pointList.size() > 1 && ComparatorUtils.equals(((Connector)object).getStartPoint(), this.getStartPoint()) && ComparatorUtils.equals(((Connector)object).getEndPoint(), this.getEndPoint());
    }

    public Object clone() throws CloneNotSupportedException {
        return null;
    }
}

