/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl.excelplus;

import com.fr.data.impl.excelplus.ExcelUtil;
import com.fr.general.DateUtils;
import com.fr.general.FRLogger;
import com.fr.stable.ColumnRow;
import com.fr.stable.Primitive;
import com.fr.third.v2.org.apache.poi.hssf.eventusermodel.EventWorkbookBuilder;
import com.fr.third.v2.org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import com.fr.third.v2.org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import com.fr.third.v2.org.apache.poi.hssf.eventusermodel.HSSFListener;
import com.fr.third.v2.org.apache.poi.hssf.eventusermodel.HSSFRequest;
import com.fr.third.v2.org.apache.poi.hssf.eventusermodel.MissingRecordAwareHSSFListener;
import com.fr.third.v2.org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import com.fr.third.v2.org.apache.poi.hssf.eventusermodel.dummyrecord.MissingCellDummyRecord;
import com.fr.third.v2.org.apache.poi.hssf.model.HSSFFormulaParser;
import com.fr.third.v2.org.apache.poi.hssf.record.BOFRecord;
import com.fr.third.v2.org.apache.poi.hssf.record.BlankRecord;
import com.fr.third.v2.org.apache.poi.hssf.record.BoolErrRecord;
import com.fr.third.v2.org.apache.poi.hssf.record.CellValueRecordInterface;
import com.fr.third.v2.org.apache.poi.hssf.record.FormulaRecord;
import com.fr.third.v2.org.apache.poi.hssf.record.LabelRecord;
import com.fr.third.v2.org.apache.poi.hssf.record.LabelSSTRecord;
import com.fr.third.v2.org.apache.poi.hssf.record.MergeCellsRecord;
import com.fr.third.v2.org.apache.poi.hssf.record.NumberRecord;
import com.fr.third.v2.org.apache.poi.hssf.record.Record;
import com.fr.third.v2.org.apache.poi.hssf.record.RowRecord;
import com.fr.third.v2.org.apache.poi.hssf.record.SSTRecord;
import com.fr.third.v2.org.apache.poi.hssf.record.StringRecord;
import com.fr.third.v2.org.apache.poi.hssf.usermodel.HSSFDateUtil;
import com.fr.third.v2.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.v2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.Ptg;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Excel2003Util
extends ExcelUtil
implements HSSFListener {
    private int columnCount;
    private List<Object[]> rowDataList;
    private List<List<Object[]>> mutiSheetDataList;
    private List<List<Object>> tempDataList;
    private List<Object> currentRowData = new ArrayList<Object>();
    private Map<ColumnRow, ColumnRow> mergeCells = new HashMap<ColumnRow, ColumnRow>();
    private List<Map<ColumnRow, ColumnRow>> mutiMergeCells = new ArrayList<Map<ColumnRow, ColumnRow>>();
    private List<Object> tempData = new ArrayList<Object>();
    private boolean preview = false;
    private POIFSFileSystem fs;
    private int lastRowNumber;
    private boolean outputFormulaValues = true;
    private EventWorkbookBuilder.SheetRecordCollectingListener workbookBuildingListener;
    private HSSFWorkbook stubWorkbook;
    private SSTRecord sstRecord;
    private FormatTrackingHSSFListener formatListener;
    private int sheetIndex = -1;
    private boolean readMutiSheet = false;
    private int nextRow;
    private int nextColumn;
    private boolean outputNextStringRecord;
    private int thisRow = -1;
    private int thisColumn = -1;
    private Object thisObj = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Excel2003Util(String string, boolean bl) throws Exception {
        this.preview = bl;
        this.readMutiSheet = false;
        this.resetValues();
        if (!string.startsWith("http")) {
            Object object;
            Object object2 = object = ExcelUtil.ExcelFileLock.getFileLock(string);
            synchronized (object2) {
                this.fs = new POIFSFileSystem((InputStream)new FileInputStream(string));
                this.process();
            }
        } else {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            this.fs = new POIFSFileSystem(uRLConnection.getInputStream());
            this.process();
        }
        this.copyDataList();
        this.mergeCells();
    }

    public Excel2003Util(InputStream inputStream, boolean bl) throws Exception {
        this(inputStream, bl, false);
    }

    private Excel2003Util(InputStream inputStream, boolean bl, boolean bl2) throws Exception {
        this.preview = bl;
        this.readMutiSheet = bl2;
        this.resetValues();
        this.fs = new POIFSFileSystem(inputStream);
        this.readMutiSheet = bl2;
        this.process();
        this.copyDataList();
        this.mergeCells();
    }

    public static List<List<Object[]>> createMutiSheetExcel(InputStream inputStream) throws Exception {
        Excel2003Util excel2003Util = new Excel2003Util(inputStream, false, true);
        return excel2003Util.mutiSheetDataList;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public List<Object[]> getRowDataList() {
        return this.rowDataList;
    }

    public void resetValuesSheet() {
        this.columnCount = 0;
        this.rowDataList = new ArrayList<Object[]>();
        this.tempDataList = new ArrayList<List<Object>>();
        this.mergeCells = new HashMap<ColumnRow, ColumnRow>();
    }

    public void resetValues() {
        this.resetValuesSheet();
        this.mutiSheetDataList = new ArrayList<List<Object[]>>();
        this.mutiMergeCells = new ArrayList<Map<ColumnRow, ColumnRow>>();
    }

    public void process() throws IOException {
        MissingRecordAwareHSSFListener missingRecordAwareHSSFListener = new MissingRecordAwareHSSFListener((HSSFListener)this);
        this.formatListener = new FormatTrackingHSSFListener((HSSFListener)missingRecordAwareHSSFListener);
        HSSFEventFactory hSSFEventFactory = new HSSFEventFactory();
        HSSFRequest hSSFRequest = new HSSFRequest();
        if (this.outputFormulaValues) {
            hSSFRequest.addListenerForAllRecords((HSSFListener)this.formatListener);
        } else {
            this.workbookBuildingListener = new EventWorkbookBuilder.SheetRecordCollectingListener((HSSFListener)this.formatListener);
            hSSFRequest.addListenerForAllRecords((HSSFListener)this.workbookBuildingListener);
        }
        hSSFEventFactory.processWorkbookEvents(hSSFRequest, this.fs);
    }

    public void processFirstSheet() throws Exception {
        this.process();
    }

    public void processRecord(Record record) {
        boolean bl;
        this.initValue();
        boolean bl2 = bl = this.preview && this.nextRow > 50;
        if (this.isContinueToRead(bl)) {
            return;
        }
        this.switchRecordType(record);
        this.doOtherThing(record);
    }

    private boolean isContinueToRead(boolean bl) {
        return this.sheetIndex > 0 && !this.readMutiSheet || bl;
    }

    public void switchRecordType(Record record) {
        switch (record.getSid()) {
            case 2057: {
                this.processBOFRecord(record);
                break;
            }
            case 520: {
                this.processRowRecord(record);
                break;
            }
            case 252: {
                this.sstRecord = (SSTRecord)record;
                break;
            }
            case 513: {
                this.processBlankRecord(record);
                break;
            }
            case 517: {
                this.processBoolRecord(record);
                break;
            }
            case 6: {
                this.processFormulaRecord(record);
                break;
            }
            case 519: {
                this.processStringRecord(record);
                break;
            }
            case 516: {
                this.processLabelRecord(record);
                break;
            }
            case 253: {
                this.processLabelSSTRecord(record);
                break;
            }
            case 515: {
                this.processNumberRecord(record);
                break;
            }
            case 229: {
                this.processMergeRecord(record);
                break;
            }
        }
    }

    public void doOtherThing(Record record) {
        if (record instanceof MissingCellDummyRecord) {
            MissingCellDummyRecord missingCellDummyRecord = (MissingCellDummyRecord)record;
            this.thisRow = missingCellDummyRecord.getRow();
            this.thisColumn = missingCellDummyRecord.getColumn();
            this.thisObj = Primitive.NULL;
        }
        if (this.thisObj != null) {
            this.tempData.add(this.thisObj);
        }
        if (this.thisRow > -1) {
            this.lastRowNumber = this.thisRow;
        }
        if (record instanceof LastCellOfRowDummyRecord) {
            this.addOneRow();
        }
    }

    public void processBOFRecord(Record record) {
        BOFRecord bOFRecord = (BOFRecord)record;
        if (bOFRecord.getType() == 16) {
            if (this.workbookBuildingListener != null && this.stubWorkbook == null) {
                this.stubWorkbook = this.workbookBuildingListener.getStubHSSFWorkbook();
            }
            ++this.sheetIndex;
            if (this.sheetIndex > 0) {
                if (!this.readMutiSheet) {
                    return;
                }
                this.copyDataList();
                this.resetValuesSheet();
            }
        }
    }

    private void processRowRecord(Record record) {
        this.columnCount = ((RowRecord)record).getLastCol();
    }

    public void processBlankRecord(Record record) {
        BlankRecord blankRecord = (BlankRecord)record;
        this.thisRow = blankRecord.getRow();
        this.thisColumn = blankRecord.getColumn();
        this.thisObj = Primitive.NULL;
    }

    public void processBoolRecord(Record record) {
        BoolErrRecord boolErrRecord = (BoolErrRecord)record;
        this.thisRow = boolErrRecord.getRow();
        this.thisColumn = boolErrRecord.getColumn();
        this.thisObj = String.valueOf(boolErrRecord.getBooleanValue());
    }

    public void processFormulaRecord(Record record) {
        FormulaRecord formulaRecord = (FormulaRecord)record;
        this.thisRow = formulaRecord.getRow();
        this.thisColumn = formulaRecord.getColumn();
        if (this.outputFormulaValues) {
            if (formulaRecord.hasCachedResultString()) {
                this.outputNextStringRecord = true;
                this.nextRow = formulaRecord.getRow();
                this.nextColumn = formulaRecord.getColumn();
            } else {
                this.thisObj = this.formatListener.formatNumberDateCell((CellValueRecordInterface)formulaRecord);
            }
        } else {
            this.thisObj = HSSFFormulaParser.toFormulaString((HSSFWorkbook)this.stubWorkbook, (Ptg[])formulaRecord.getParsedExpression());
        }
    }

    public void processStringRecord(Record record) {
        if (this.outputNextStringRecord) {
            StringRecord stringRecord = (StringRecord)record;
            this.thisObj = stringRecord.getString();
            this.thisRow = this.nextRow;
            this.thisColumn = this.nextColumn;
            this.outputNextStringRecord = false;
        }
    }

    public void processLabelRecord(Record record) {
        LabelRecord labelRecord = (LabelRecord)record;
        this.thisRow = labelRecord.getRow();
        this.thisColumn = labelRecord.getColumn();
        this.thisObj = labelRecord.getValue();
    }

    public void processLabelSSTRecord(Record record) {
        LabelSSTRecord labelSSTRecord = (LabelSSTRecord)record;
        this.thisRow = labelSSTRecord.getRow();
        this.thisColumn = labelSSTRecord.getColumn();
        this.thisObj = this.sstRecord == null ? Primitive.NULL : this.sstRecord.getString(labelSSTRecord.getSSTIndex()).toString();
    }

    public void processNumberRecord(Record record) {
        NumberRecord numberRecord = (NumberRecord)record;
        this.thisRow = numberRecord.getRow();
        this.thisColumn = numberRecord.getColumn();
        String string = this.formatListener.getFormatString((CellValueRecordInterface)numberRecord);
        String string2 = this.formatListener.formatNumberDateCell((CellValueRecordInterface)numberRecord);
        try {
            boolean bl;
            boolean bl2 = bl = string != null && (string.contains("yy") || string.contains("dd") || string.contains("mm"));
            if (bl) {
                Date date = HSSFDateUtil.getJavaDate((double)numberRecord.getValue());
                this.thisObj = DateUtils.getDate2LStr(date);
            } else {
                this.thisObj = this.hasSpecialChar(string2) ? String.valueOf(numberRecord.getValue()) : string2;
            }
        }
        catch (Exception exception) {
            this.thisObj = string2;
        }
    }

    private boolean hasSpecialChar(String string) {
        Pattern pattern = Pattern.compile("[,()]");
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    public void processMergeRecord(Record record) {
        MergeCellsRecord mergeCellsRecord = (MergeCellsRecord)record;
        int n = mergeCellsRecord.getNumAreas();
        for (int i = 0; i < n; ++i) {
            try {
                String string = mergeCellsRecord.getAreaAt(i).formatAsString();
                String[] stringArray = string.split(":");
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                ColumnRow columnRow = ColumnRow.valueOf(string2);
                ColumnRow columnRow2 = ColumnRow.valueOf(string3);
                this.mergeCells.put(columnRow, columnRow2);
                continue;
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage());
            }
        }
    }

    public void initValue() {
        this.thisRow = -1;
        this.thisColumn = -1;
        this.thisObj = null;
    }

    public void addOneRow() {
        int n = this.tempData.size();
        this.columnCount = Math.max(this.columnCount, n);
        for (int i = 0; i < n; ++i) {
            try {
                this.currentRowData.add(this.tempData.get(i));
                continue;
            }
            catch (Exception exception) {
                this.currentRowData.add(Primitive.NULL);
            }
        }
        this.tempDataList.add(this.currentRowData);
        this.currentRowData = new ArrayList<Object>();
        this.tempData = new ArrayList<Object>();
    }

    public void mergeCells() {
        if (!this.readMutiSheet) {
            this.mergeCells(this.mergeCells, this.rowDataList);
        } else {
            for (int i = 0; i < this.mutiSheetDataList.size(); ++i) {
                this.mergeCells(this.mutiMergeCells.get(i), this.mutiSheetDataList.get(i));
            }
        }
    }

    private void copyDataList() {
        for (int i = 0; i < this.tempDataList.size(); ++i) {
            List<Object> list = this.tempDataList.get(i);
            while (list.size() < this.columnCount) {
                list.add(Primitive.NULL);
            }
            this.rowDataList.add(list.toArray());
        }
        if (this.readMutiSheet) {
            this.mutiMergeCells.add(this.mergeCells);
            this.mutiSheetDataList.add(this.rowDataList);
        }
    }
}

