/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.Parameter;
import com.fr.data.impl.DirectoryConnectionContainer;
import com.fr.data.impl.FileTableData;
import com.fr.data.impl.TextDataModel;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralContext;
import com.fr.general.data.DataModel;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.fun.SpecialCharProcessor;
import com.fr.stable.plugin.ExtraClassManagerProvider;
import com.fr.stable.xml.StableXMLUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;

public class TextTableData
extends FileTableData
implements XMLable,
DirectoryConnectionContainer {
    private String delimiter = null;
    private String charset = "";
    private Parameter[] params;
    private boolean isIgnoreOneMoreDelimiter = true;
    private String filePath = null;
    private boolean needColumnName = false;

    public Parameter[] getParams() {
        return this.params;
    }

    public void setParams(Parameter[] parameterArray) {
        this.params = parameterArray;
    }

    public Parameter[] getParameters(Calculator calculator) {
        return this.params == null ? new Parameter[]{} : this.params;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String string) {
        this.filePath = string;
    }

    public boolean needColumnName() {
        return this.needColumnName;
    }

    public void setNeedColumnName(boolean bl) {
        this.needColumnName = bl;
    }

    public String getDelimiter() {
        SpecialCharProcessor specialCharProcessor;
        ExtraClassManagerProvider extraClassManagerProvider = StableFactory.getMarkedObject("ExtraClassManager", ExtraClassManagerProvider.class);
        if (extraClassManagerProvider != null && (specialCharProcessor = (SpecialCharProcessor)extraClassManagerProvider.getSingle("SpecialCharProcessor")) != null) {
            return specialCharProcessor.processChar(this.delimiter);
        }
        return this.delimiter;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public DataModel createDataModel(Calculator calculator) {
        Object[] objectArray = Parameter.providers2Parameter(Calculator.processParameters(calculator, this.params));
        this.params = ArrayUtils.isEmpty(objectArray) ? this.params : objectArray;
        return new TextDataModel(this.getAppendFilePath(), this.getDelimiter(), this.needColumnName, this.isIgnoreOneMoreDelimiter, this.params, this.charset);
    }

    private String getAppendFilePath() {
        if (this.filePath.indexOf("http") != -1) {
            return this.filePath;
        }
        String string = GeneralContext.getEnvProvider().getPath();
        return StableUtils.pathJoin(string, this.filePath);
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public boolean isIgnoreOneMoreDelimiter() {
        return this.isIgnoreOneMoreDelimiter;
    }

    public void setIgnoreOneMoreDelimiter(boolean bl) {
        this.isIgnoreOneMoreDelimiter = bl;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("TextTableDataAttr".equals(string)) {
                String string2 = xMLableReader.getAttrAsString("delimiter", null);
                if (string2 != null) {
                    if (string2.equals("TTT")) {
                        this.setDelimiter("\t");
                    } else {
                        this.setDelimiter(string2);
                    }
                }
                this.charset = xMLableReader.getAttrAsString("charset", "");
                string2 = xMLableReader.getAttrAsString("filePath", null);
                if (string2 != null) {
                    this.filePath = string2;
                }
                if ((string2 = xMLableReader.getAttrAsString("needColumnName", null)) != null) {
                    this.setNeedColumnName(Boolean.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttrAsString("isIgnoreOneMoreDelimiter", null)) != null) {
                    if (string2.equals("true")) {
                        this.setIgnoreOneMoreDelimiter(true);
                    } else {
                        this.setIgnoreOneMoreDelimiter(false);
                    }
                }
            } else if ("Parameters".equals(string)) {
                final ArrayList arrayList = new ArrayList();
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if ("Parameter".equals(xMLableReader.getTagName())) {
                            arrayList.add(StableXMLUtils.readParameter(xMLableReader));
                        }
                    }
                });
                if (!arrayList.isEmpty()) {
                    this.params = new Parameter[arrayList.size()];
                    arrayList.toArray(this.params);
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        String string = this.delimiter;
        if (string.equals("\t")) {
            string = "TTT";
        }
        xMLPrintWriter.startTAG("TextTableDataAttr").attr("delimiter", string).attr("charset", this.charset).attr("needColumnName", this.needColumnName()).attr("isIgnoreOneMoreDelimiter", this.isIgnoreOneMoreDelimiter()).attr("filePath", this.getFilePath()).end();
        StableXMLUtils.writeParameters(xMLPrintWriter, this.params);
    }

    public boolean equals(Object object) {
        return object instanceof TextTableData && this.isIgnoreOneMoreDelimiter == ((TextTableData)object).isIgnoreOneMoreDelimiter && this.needColumnName == ((TextTableData)object).needColumnName && ComparatorUtils.equals(this.delimiter, ((TextTableData)object).delimiter) && ComparatorUtils.equals(this.charset, ((TextTableData)object).charset) && ComparatorUtils.equals(this.filePath, ((TextTableData)object).filePath);
    }
}

