/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cache.concurrentlinkedhashmap;

import com.fr.cache.concurrentlinkedhashmap.Weigher;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Weighers {
    private Weighers() {
        throw new AssertionError();
    }

    public static <V> Weigher<V> singleton() {
        return SingletonWeigher.INSTANCE;
    }

    public static Weigher<byte[]> byteArray() {
        return ByteArrayWeigher.INSTANCE;
    }

    public static <E> Weigher<? super Iterable<E>> iterable() {
        return IterableWeigher.INSTANCE;
    }

    public static <E> Weigher<? super Collection<E>> collection() {
        return CollectionWeigher.INSTANCE;
    }

    public static <E> Weigher<? super List<E>> list() {
        return ListWeigher.INSTANCE;
    }

    public static <E> Weigher<? super Set<E>> set() {
        return SetWeigher.INSTANCE;
    }

    public static <A, B> Weigher<? super Map<A, B>> map() {
        return MapWeigher.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MapWeigher implements Weigher<Map<?, ?>>
    {
        INSTANCE;


        @Override
        public int weightOf(Map<?, ?> map) {
            return map.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SetWeigher implements Weigher<Set<?>>
    {
        INSTANCE;


        @Override
        public int weightOf(Set<?> set) {
            return set.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ListWeigher implements Weigher<List<?>>
    {
        INSTANCE;


        @Override
        public int weightOf(List<?> list) {
            return list.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CollectionWeigher implements Weigher<Collection<?>>
    {
        INSTANCE;


        @Override
        public int weightOf(Collection<?> collection) {
            return collection.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum IterableWeigher implements Weigher<Iterable<?>>
    {
        INSTANCE;


        @Override
        public int weightOf(Iterable<?> iterable) {
            if (iterable instanceof Collection) {
                return ((Collection)iterable).size();
            }
            int n = 0;
            for (Object obj : iterable) {
                ++n;
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ByteArrayWeigher implements Weigher<byte[]>
    {
        INSTANCE;


        @Override
        public int weightOf(byte[] byArray) {
            return byArray.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SingletonWeigher implements Weigher<Object>
    {
        INSTANCE;


        @Override
        public int weightOf(Object object) {
            return 1;
        }
    }
}

