/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.DataModelCreator;
import com.fr.base.TableData;
import com.fr.data.TableDataSource;
import com.fr.data.impl.AbstractDBDataModel;
import com.fr.data.impl.DBTableData;
import com.fr.data.impl.SharedDBDataModel;
import com.fr.data.impl.storeproc.ProcedureDataModel;
import com.fr.data.impl.storeproc.StoreProcedure;
import com.fr.data.index.DefaultIndexDataModel;
import com.fr.file.DatasourceManager;
import com.fr.file.DatasourceManagerProvider;
import com.fr.general.FRLogger;
import com.fr.general.ManagerFactory;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.performance.PerformanceManager;
import com.fr.script.Calculator;
import com.fr.stable.bridge.ObjectHolder;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.fun.DataSourcePoolProcessor;
import com.fr.stable.fun.SessionCachedDataModelProcessor;
import com.fr.stable.plugin.ExtraClassManagerProvider;
import com.fr.stable.script.CalculatorKey;
import com.fr.stable.script.NameSpace;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedLiveDataModelUtils {
    public static final CalculatorKey CUR_LIVE_RS = CalculatorKey.createKey("CURRENT_LIVE_RS");
    private static ThreadLocal<DataModelCreator> tlOfSheetExecutor = new ThreadLocal();

    public static DataModelCreator getSheetExecutor() {
        return tlOfSheetExecutor.get();
    }

    public static void put(DataModelCreator dataModelCreator) {
        tlOfSheetExecutor.set(dataModelCreator);
    }

    public static DataModel getSELiveDataModel4Share(Calculator calculator, String string) {
        TableDataSource tableDataSource;
        if (calculator == null) {
            return null;
        }
        Map map = (Map)calculator.getAttribute(CUR_LIVE_RS);
        if (map != null && (tableDataSource = (TableDataSource)calculator.getAttribute(TableDataSource.KEY)) != null) {
            return SynchronizedLiveDataModelUtils.getLiveDataModel(map, calculator, tableDataSource, string);
        }
        return null;
    }

    public static DataModel getLiveDataModel(Map<String, DataModel> map, Calculator calculator, TableDataSource tableDataSource, String string) {
        TableData tableData;
        Object object;
        if (map.containsKey(string)) {
            return map.get(string);
        }
        boolean bl = false;
        DataModel dataModel = null;
        ExtraClassManagerProvider extraClassManagerProvider = StableFactory.getMarkedObject("ExtraClassManager", ExtraClassManagerProvider.class);
        if (extraClassManagerProvider != null) {
            object = (DataSourcePoolProcessor)extraClassManagerProvider.getSingle("DataSourcePoolProcessor");
            SessionCachedDataModelProcessor sessionCachedDataModelProcessor = (SessionCachedDataModelProcessor)extraClassManagerProvider.getSingle("SessionCachedDataModelProcessor");
            if (object != null && sessionCachedDataModelProcessor == null) {
                dataModel = object.getDataModel(new ObjectHolder(calculator), string).get(DataModel.class);
            }
            if (sessionCachedDataModelProcessor != null && sessionCachedDataModelProcessor.isSupportedType(new ObjectHolder(calculator))) {
                tableData = SynchronizedLiveDataModelUtils.getSourceTableData(tableDataSource, string);
                dataModel = tableData.createDataModel(calculator);
                NameSpace nameSpace = (NameSpace)Calculator.getSavedSessionNameSpace();
                String string2 = (String)nameSpace.getVariable("sessionID", null);
                if (string2 != null) {
                    dataModel = sessionCachedDataModelProcessor.getOrCreate(string2, string, new ObjectHolder(dataModel)).get(DataModel.class);
                }
            }
        }
        if (dataModel == null || dataModel == DataModel.EMPTY_DATAMODEL) {
            long l = System.currentTimeMillis();
            tableData = SynchronizedLiveDataModelUtils.getSourceTableData(tableDataSource, string);
            dataModel = tableData.createDataModel(calculator);
            PerformanceManager.getRecorder().beginDataSourceRecord(string);
            if (dataModel == DataModel.EMPTY_DATAMODEL) {
                dataModel = SynchronizedLiveDataModelUtils.getProcedureDataModel(map, calculator, tableDataSource, string);
                bl = true;
            }
            if (!bl) {
                SynchronizedLiveDataModelUtils.recordDataModel(string, dataModel);
            }
            FRLogger.getLogger().info("SQL TIME:" + (System.currentTimeMillis() - l) + "ms!");
            PerformanceManager.getRecorder().endDataSourceRecord(string);
        }
        object = new DefaultIndexDataModel(dataModel);
        map.put(string, (DataModel)object);
        return object;
    }

    private static DataModel getProcedureDataModel(Map<String, DataModel> map, Calculator calculator, TableDataSource tableDataSource, String string) {
        DatasourceManagerProvider datasourceManagerProvider = DatasourceManager.getProviderInstance();
        List<String> list = datasourceManagerProvider.getProcedureNames();
        boolean bl = datasourceManagerProvider.isProcedureName(string);
        boolean bl2 = false;
        StoreProcedure storeProcedure = null;
        String string2 = null;
        if (bl) {
            string2 = string;
            storeProcedure = datasourceManagerProvider.getProcedure(string);
        } else {
            String[] stringArray = string.split("_");
            bl2 = stringArray.length == 1;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i == 0) {
                    stringBuffer.append(stringArray[i]);
                } else {
                    stringBuffer.append("_" + stringArray[i]);
                }
                if (list.contains(stringBuffer.toString())) {
                    string2 = stringBuffer.toString();
                    storeProcedure = datasourceManagerProvider.getProcedure(stringBuffer.toString());
                    break;
                }
                if (SynchronizedLiveDataModelUtils.getSourceTableData(tableDataSource, stringBuffer.toString()) == TableData.EMPTY_TABLEDATA) continue;
                string2 = stringBuffer.toString();
                storeProcedure = (StoreProcedure)SynchronizedLiveDataModelUtils.getSourceTableData(tableDataSource, stringBuffer.toString());
                break;
            }
        }
        DataModel dataModel = SynchronizedLiveDataModelUtils.getStoreProcedureDataModel(storeProcedure, string, calculator, map, string2, bl || bl2);
        return dataModel;
    }

    private static void recordDataModel(String string, DataModel dataModel) {
        try {
            if (PerformanceManager.isUsePerformanceRecorder()) {
                long l = System.nanoTime();
                int n = dataModel.getColumnCount();
                long l2 = System.nanoTime();
                int n2 = dataModel.getRowCount();
                PerformanceManager.getRecorder().recordSqlExecuteTime(string, l2 - l);
                PerformanceManager.getRecorder().recordDataModelColCount(string, n);
                PerformanceManager.getRecorder().recordDataModelRowCount(string, n2);
            } else {
                dataModel.getColumnCount();
                dataModel.getRowCount();
            }
        }
        catch (TableDataException tableDataException) {
            // empty catch block
        }
    }

    protected static DataModel getStoreProcedureDataModel(StoreProcedure storeProcedure, String string, Calculator calculator, Map<String, DataModel> map, String string2, boolean bl) {
        DataModel dataModel = DataModel.EMPTY_DATAMODEL;
        if (storeProcedure == null) {
            storeProcedure = DatasourceManager.getProviderInstance().getProcedureBy_dsName(string);
        }
        if (storeProcedure == null) {
            return dataModel;
        }
        ProcedureDataModel[] procedureDataModelArray = storeProcedure.creatDataModel(calculator);
        int n = procedureDataModelArray.length;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                ProcedureDataModel procedureDataModel = procedureDataModelArray[i];
                map.put(string2 + "_" + procedureDataModel.getName(), procedureDataModel);
            }
            if (bl) {
                return procedureDataModelArray[0];
            }
            DataModel dataModel2 = map.get(string);
            return dataModel2 == null ? DataModel.EMPTY_DATAMODEL : dataModel2;
        }
        return dataModel;
    }

    public static TableData getSourceTableData(TableDataSource tableDataSource, String string) {
        TableData tableData = tableDataSource.getTableData(string);
        if (tableData == null && (tableData = DatasourceManager.getProviderInstance().getTableData(string)) == null) {
            tableData = TableData.EMPTY_TABLEDATA;
        }
        return tableData;
    }

    public static DataModel createDefaultDBDataModel(DBTableData dBTableData, String string, int n) {
        if (dBTableData == null) {
            return null;
        }
        if (dBTableData.isShareTableData()) {
            AbstractDBDataModel abstractDBDataModel = (AbstractDBDataModel)ManagerFactory.getCacheProvider().get(dBTableData.getDatabase(), string, dBTableData.getMaxMemRowCount());
            abstractDBDataModel.setTimeoutSeconds(n);
            SharedDBDataModel sharedDBDataModel = new SharedDBDataModel(abstractDBDataModel);
            abstractDBDataModel.register(sharedDBDataModel);
            return sharedDBDataModel;
        }
        if (FRLogger.getLogger().isLoggable(Level.CONFIG)) {
            FRLogger.getLogger().info("SQL: " + string);
        }
        return DBTableData.createCacheableDBResultSet(dBTableData.getDatabase(), string, dBTableData.getMaxMemRowCount());
    }

    public static DataModel createDefaultDBDataModel(DBTableData dBTableData, String string) {
        return SynchronizedLiveDataModelUtils.createDefaultDBDataModel(dBTableData, string, 0);
    }
}

