/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.scatter;

import com.fr.base.chart.chartdata.model.DataProcessor;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.chartattr.Chart;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.design.mainframe.chart.gui.type.ChartImagePane;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.attr.plot.VanChartRectanglePlot;
import com.fr.plugin.chart.base.VanChartAttrLine;
import com.fr.plugin.chart.designer.type.AbstractVanChartTypePane;
import com.fr.plugin.chart.range.LegendType;
import com.fr.plugin.chart.scatter.ScatterIndependentVanChart;
import com.fr.plugin.chart.scatter.VanChartScatterLegend;
import com.fr.plugin.chart.scatter.VanChartScatterPlot;

public class VanChartScatterPlotPane
extends AbstractVanChartTypePane {
    private static final long serialVersionUID = -3481633368542654247L;

    protected String[] getTypeIconPath() {
        return new String[]{"/com/fr/plugin/chart/scatter/images/scatter.png", "/com/fr/plugin/chart/scatter/images/large.png"};
    }

    protected String[] getTypeTipName() {
        return new String[]{Inter.getLocText((String)"FR-Chart-Type_XYScatter"), Inter.getLocText((String)"Plugin-ChartF_NewScatter_LargerData")};
    }

    public String title4PopupWindow() {
        return Inter.getLocText((String)"Plugin-ChartF_NewScatter");
    }

    public void populateBean(Chart chart) {
        for (ChartImagePane chartImagePane : this.typeDemo) {
            chartImagePane.isPressing = false;
        }
        this.lastTypeIndex = chart.getDataProcessor().getMark();
        ((ChartImagePane)this.typeDemo.get((int)this.lastTypeIndex)).isPressing = true;
        this.checkDemosBackground();
    }

    @Override
    public void updateBean(Chart chart) {
        super.updateBean(chart);
        Chart[] chartArray = ScatterIndependentVanChart.ScatterVanChartTypes;
        int n = chartArray.length;
        for (int i = 0; i < n; ++i) {
            if (!((ChartImagePane)this.typeDemo.get((int)i)).isPressing) continue;
            try {
                chart.setDataProcessor((DataProcessor)chartArray[i].getDataProcessor().clone());
                VanChartScatterLegend vanChartScatterLegend = (VanChartScatterLegend)chart.getPlot().getLegend();
                if (VanChartAttrHelper.largeDataModel(chart)) {
                    vanChartScatterLegend.setLegendType(LegendType.GRADUAL);
                    continue;
                }
                vanChartScatterLegend.setLegendType(LegendType.ORDINARY);
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                FRLogger.getLogger().error("Error In ScatterChart");
            }
        }
    }

    protected String getPlotTypeID() {
        return "VanChartScatterPlot";
    }

    protected Plot getSelectedClonedPlot() {
        VanChartRectanglePlot vanChartRectanglePlot = null;
        Chart[] chartArray = ScatterIndependentVanChart.ScatterVanChartTypes;
        int n = chartArray.length;
        for (int i = 0; i < n; ++i) {
            if (!((ChartImagePane)this.typeDemo.get((int)i)).isPressing) continue;
            vanChartRectanglePlot = (VanChartScatterPlot)chartArray[i].getPlot();
        }
        Plot plot = null;
        try {
            plot = (Plot)vanChartRectanglePlot.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRLogger.getLogger().error("Error In ScatterChart");
        }
        return plot;
    }

    public Chart getDefaultChart() {
        return ScatterIndependentVanChart.ScatterVanChartTypes[0];
    }

    @Override
    protected void cloneOldConditionCollection(Plot plot, Plot plot2) throws CloneNotSupportedException {
        this.cloneOldDefaultAttrConditionCollection(plot, plot2);
    }

    @Override
    protected void cloneOldDefaultAttrConditionCollection(Plot plot, Plot plot2) throws CloneNotSupportedException {
        if (plot.getConditionCollection() != null) {
            ConditionCollection conditionCollection = new ConditionCollection();
            conditionCollection.setDefaultAttr((ConditionAttr)plot.getConditionCollection().getDefaultAttr().clone());
            plot2.setConditionCollection(conditionCollection);
            ConditionAttr conditionAttr = conditionCollection.getDefaultAttr();
            DataSeriesCondition dataSeriesCondition = conditionAttr.getExisted(VanChartAttrLine.class);
            if (dataSeriesCondition != null) {
                conditionAttr.remove(VanChartAttrLine.class);
            }
        }
    }
}

