/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.gauge.glyph;

import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.general.ComparatorUtils;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.base.AttrLabel;
import com.fr.plugin.chart.base.AttrLabelDetail;
import com.fr.plugin.chart.gauge.GaugeDetailStyle;
import com.fr.plugin.chart.gauge.glyph.GaugeGlyph;
import com.fr.plugin.chart.gauge.glyph.GaugeGlyphHelper;
import com.fr.plugin.chart.glyph.axis.VanChartGaugeAxisGlyph;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.text.Format;

public class PointerGaugeGlyph
extends GaugeGlyph {
    private static final long serialVersionUID = 1317272737007992913L;
    private static final double OUT = 0.95;
    private static final double HINGE_BACKGROUND = 0.16;
    private static final double HINGE = 0.07;
    private static final double ARROW_HEIGHT = 0.9;
    private static final double ARROW_WIDTH = 0.04;
    private static final double MAIN_TICK = 0.1;
    private static final double SEC_TICK = 0.05;
    private static final double AXIS_LABEL = 0.11;
    private static final double VALUE_LABEL_ROUND = 0.02;
    protected static final double VALUE_GAP = 0.5;
    private static final int START_ANGLE = 240;
    private static final int EXTENT = -300;
    private static final double ANGLE1 = 225.0;
    private static final double ANGLE2 = 180.0;
    private static final double ANGLE3 = 0.0;
    private static final double ANGLE4 = -45.0;
    protected static final double PROPORTION = 5.0;
    protected Rectangle2D bigBounds = new Rectangle();
    protected double oneLineHeight;

    public PointerGaugeGlyph(Rectangle2D rectangle2D, AttrLabel attrLabel, GaugeDetailStyle gaugeDetailStyle, VanChartGaugeAxisGlyph vanChartGaugeAxisGlyph) {
        super(rectangle2D, attrLabel, gaugeDetailStyle, vanChartGaugeAxisGlyph);
    }

    @Override
    protected void initStartAngleAndExtent() {
        this.startAngle = 240;
        this.extent = -300;
    }

    @Override
    protected void calculateRadiusAndCenterPoint(double d, double d2, double d3) {
        double d4 = d2 - d3 - 20.0;
        this.radius = Math.min(d, d4) / 2.0;
        double d5 = d / 2.0;
        double d6 = d2 / 2.0;
        if (this.attrLabel != null && this.attrLabel.isEnable()) {
            int n = this.attrLabel.getAttrLabelDetail().getPosition();
            if (n == 3) {
                double d7 = d3 + 20.0 + this.radius;
                if (d7 > d2 - d6) {
                    d6 = d2 - d7;
                }
            } else {
                double d8 = d3 + 20.0 + this.radius;
                if (d8 > d6) {
                    d6 = d8;
                }
            }
        }
        this.centerPoint = new Point2D.Double(d5, d6);
    }

    @Override
    protected void drawInfo(Graphics2D graphics2D, int n) {
        this.drawPaneBackground(graphics2D);
        this.drawHingeBackground(graphics2D);
        this.initBigBounds();
        this.drawTicksAndAxisLabel(graphics2D, n);
        this.drawValueLabel(graphics2D, n);
        this.drawArrow(graphics2D);
        this.drawHinge(graphics2D);
        this.drawCateOrPercentageLabel(graphics2D, n);
    }

    private void initBigBounds() {
        if (this.attrLabel != null && this.attrLabel.isEnable()) {
            AttrLabelDetail attrLabelDetail = this.attrLabel.getGaugeValueLabelDetail();
            TextAttr textAttr = attrLabelDetail.getTextAttr();
            this.oneLineHeight = GaugeGlyphHelper.calculateOneLineHeight(textAttr.getFRFont());
            this.setFirstBigBounds();
        }
    }

    protected void setFirstBigBounds() {
        double d = 0.16 * this.radius + this.oneLineHeight * 0.5;
        this.bigBounds.setFrame(this.centerPoint.getX() - this.radius, this.centerPoint.getY() + d, this.radius * 2.0, Math.sqrt(2.0) * this.radius / 2.0 - d);
    }

    private void drawHingeBackground(Graphics2D graphics2D) {
        GaugeGlyphHelper.drawCircle(graphics2D, this.centerPoint, this.getHingeBackgroundSize() * this.radius, this.gaugeDetailStyle.getHingeBackgroundColor());
    }

    protected double getHingeBackgroundSize() {
        return 0.16;
    }

    private void drawArrow(Graphics2D graphics2D) {
        for (Number number : this.valueList) {
            graphics2D.setColor(GaugeGlyphHelper.getColor(this.gaugeDetailStyle.getNeedleColor()));
            double d = this.gaugeAxisGlyph.getMinValue();
            double d2 = this.gaugeAxisGlyph.getMaxValue();
            double d3 = (double)this.startAngle + (double)this.extent / (d2 - d) * (number.doubleValue() - d);
            d3 = Math.max(d3, (double)(this.startAngle + this.extent));
            d3 = Math.min(d3, (double)this.startAngle);
            double d4 = this.centerPoint.getX() + this.radius * 0.9 * Math.cos(Math.PI * (d3 / 180.0));
            double d5 = this.centerPoint.getY() - this.radius * 0.9 * Math.sin(Math.PI * (d3 / 180.0));
            double d6 = this.centerPoint.getX() + this.radius * 0.04 / 2.0 * Math.cos(Math.PI * (d3 - 90.0) / 180.0);
            double d7 = this.centerPoint.getY() - this.radius * 0.04 / 2.0 * Math.sin(Math.PI * (d3 - 90.0) / 180.0);
            double d8 = this.centerPoint.getX() + this.radius * 0.04 / 2.0 * Math.cos(Math.PI * (d3 + 90.0) / 180.0);
            double d9 = this.centerPoint.getY() - this.radius * 0.04 / 2.0 * Math.sin(Math.PI * (d3 + 90.0) / 180.0);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(d4, d5);
            generalPath.lineTo(d6, d7);
            generalPath.lineTo(d8, d9);
            generalPath.lineTo(d4, d5);
            graphics2D.fill(generalPath);
        }
    }

    private void drawHinge(Graphics2D graphics2D) {
        GaugeGlyphHelper.drawCircle(graphics2D, this.centerPoint, this.getHingeSize() * this.radius, this.gaugeDetailStyle.getHingeColor());
    }

    protected double getHingeSize() {
        return 0.07;
    }

    private void drawTicksAndAxisLabel(Graphics2D graphics2D, int n) {
        Color color;
        double d;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double d2 = this.gaugeAxisGlyph.getMainUnit();
        double d3 = this.gaugeAxisGlyph.getSecUnit();
        double d4 = 0.1 * this.radius;
        double d5 = 0.05 * this.radius;
        double d6 = this.gaugeAxisGlyph.getMinValue();
        double d7 = this.gaugeAxisGlyph.getMaxValue();
        double d8 = (double)this.extent / (d7 - d6) * d2;
        double d9 = (double)this.extent / (d7 - d6) * d3;
        TextAttr textAttr = this.gaugeAxisGlyph.getTextAttr();
        Format format = this.gaugeAxisGlyph.getFormat();
        double d10 = this.startAngle;
        for (d = d6; d <= d7 + 1.0E-10; d += d2) {
            color = this.getValueColor(d, d6, d7);
            this.drawTickLine(graphics2D, d4, color, d10);
            this.drawTickLabel(graphics2D, d, textAttr, d10, format, n);
            d10 += d8;
        }
        d10 = this.startAngle;
        for (d = d6; d <= d7; d += d3) {
            color = this.getValueColor(d, d6, d7);
            this.drawTickLine(graphics2D, d5, color, d10);
            d10 += d9;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    private void drawTickLine(Graphics2D graphics2D, double d, Color color, double d2) {
        double d3 = this.centerPoint.getX() + this.radius * 0.95 * Math.cos(Math.PI * (d2 / 180.0));
        double d4 = this.centerPoint.getY() - this.radius * 0.95 * Math.sin(Math.PI * (d2 / 180.0));
        double d5 = this.centerPoint.getX() + (this.radius * 0.95 - d) * Math.cos(Math.PI * (d2 / 180.0));
        double d6 = this.centerPoint.getY() - (this.radius * 0.95 - d) * Math.sin(Math.PI * (d2 / 180.0));
        graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
        graphics2D.setColor(color);
        graphics2D.draw(new Line2D.Double(d5, d6, d3, d4));
    }

    private void drawTickLabel(Graphics2D graphics2D, double d, TextAttr textAttr, double d2, Format format, int n) {
        if (this.gaugeAxisGlyph.isShowAxisLabel()) {
            String string = GaugeGlyphHelper.value2String(d, format);
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)string, (TextAttr)textAttr, (int)n);
            double d3 = dimension2D.getHeight() / dimension2D.getWidth() < Math.abs(Math.tan(Math.PI * (d2 / 180.0))) ? dimension2D.getHeight() / (2.0 * Math.abs(Math.sin(Math.PI * (d2 / 180.0)))) : dimension2D.getWidth() / (2.0 * Math.abs(Math.cos(Math.PI * (d2 / 180.0))));
            double d4 = this.radius * 0.95 - this.radius * 0.11 - d3;
            double d5 = this.centerPoint.getX() + d4 * Math.cos(Math.PI * (d2 / 180.0));
            double d6 = this.centerPoint.getY() - d4 * Math.sin(Math.PI * (d2 / 180.0));
            Rectangle2D.Double double_ = new Rectangle2D.Double(d5 - dimension2D.getWidth() / 2.0, d6 - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
            GlyphUtils.drawStrings((Graphics)graphics2D, (String)string, (TextAttr)textAttr, (Rectangle2D)double_, (int)n);
            if (this.attrLabel != null && this.attrLabel.isEnable()) {
                this.calculateValueBackgroundBounds(double_, d2);
            }
        }
    }

    protected void calculateValueBackgroundBounds(Rectangle2D rectangle2D, double d) {
        double d2 = rectangle2D.getHeight() / 5.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() - d2, rectangle2D.getY() - d2, rectangle2D.getWidth() + d2 * 2.0, rectangle2D.getHeight() + d2 * 2.0);
        if (d >= 225.0 || d <= -45.0) {
            if (this.bigBounds.getMaxY() > ((RectangularShape)double_).getY()) {
                this.bigBounds.setFrame(this.bigBounds.getX(), this.bigBounds.getY(), this.bigBounds.getWidth(), ((RectangularShape)double_).getY() - this.bigBounds.getY());
            }
        } else if (d >= 180.0) {
            if (this.bigBounds.getX() < double_.getMaxX()) {
                this.bigBounds.setFrame(double_.getMaxX(), this.bigBounds.getY(), this.bigBounds.getWidth(), this.bigBounds.getHeight());
            }
        } else if (d <= 0.0 && this.bigBounds.getMaxX() > ((RectangularShape)double_).getX()) {
            this.bigBounds.setFrame(this.bigBounds.getX(), this.bigBounds.getY(), ((RectangularShape)double_).getX() - this.bigBounds.getX(), this.bigBounds.getHeight());
        }
    }

    @Override
    protected Rectangle2D getCateOrPercentLabelBounds(int n, Dimension2D dimension2D) {
        double d = this.centerPoint.getX() - dimension2D.getWidth() / 2.0;
        double d2 = n == 3 ? this.centerPoint.getY() + this.radius + 20.0 - dimension2D.getHeight() / 5.0 : this.centerPoint.getY() - this.radius - 20.0 - dimension2D.getHeight();
        return new Rectangle2D.Double(d, d2, dimension2D.getWidth(), dimension2D.getHeight());
    }

    @Override
    protected void drawValueLabel(Graphics2D graphics2D, int n) {
        if (this.attrLabel == null || !this.attrLabel.isEnable()) {
            return;
        }
        if (this.valueLabelString.isEmpty()) {
            return;
        }
        AttrLabelDetail attrLabelDetail = this.attrLabel.getGaugeValueLabelDetail();
        TextAttr textAttr = attrLabelDetail.getTextAttr();
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)this.valueLabelString, (TextAttr)textAttr, (int)n);
        double d = dimension2D.getWidth() + this.oneLineHeight * 0.5 * 2.0;
        double d2 = dimension2D.getHeight() + this.oneLineHeight * 0.5 * 2.0;
        double d3 = this.centerPoint.getX() - this.bigBounds.getX();
        double d4 = this.bigBounds.getMaxX() - this.centerPoint.getX();
        double d5 = Math.min(d3, d4);
        d = Math.min(d5 * 2.0, d);
        d2 = Math.min(d2, this.bigBounds.getHeight());
        double d6 = this.centerPoint.getX() - d / 2.0;
        double d7 = this.bigBounds.getY() + (this.bigBounds.getHeight() - d2) / 2.0;
        double d8 = 0.0;
        if (System.getProperties().getProperty("os.name").toUpperCase().contains("WINDOWS") && ComparatorUtils.equals((Object)textAttr.getFRFont().getFamily().toLowerCase(), (Object)"verdana")) {
            d8 = 8.0;
        }
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(d6, d7, d + d8, d2, this.radius * 0.02, this.radius * 0.02);
        graphics2D.setColor(GaugeGlyphHelper.getColor(attrLabelDetail.getBackgroundColor()));
        graphics2D.fill(double_);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d6 + this.oneLineHeight * 0.5, d7 + this.oneLineHeight * 0.5, d - this.oneLineHeight * 0.5 * 2.0, d2 - this.oneLineHeight * 0.5 * 2.0);
        Shape shape = graphics2D.getClip();
        graphics2D.clipRect((int)((RectangularShape)double_).getX(), (int)((RectangularShape)double_).getY(), (int)((RectangularShape)double_).getWidth(), (int)((RectangularShape)double_).getHeight());
        GaugeGlyphHelper.drawMultiLineText(graphics2D, this.valueLabelString, textAttr, double_2, n);
        graphics2D.setClip(shape);
    }

    @Override
    public String getCateOrPercentLabelWithDataPoint(DataPoint dataPoint) {
        return VanChartAttrHelper.getCategoryName(this.attrLabel.getAttrLabelDetail().getContent(), dataPoint);
    }

    @Override
    public String getValueLabelWithDataPoint(DataPoint dataPoint) {
        return VanChartAttrHelper.getLabelWithOutCategory(this.attrLabel.getGaugeValueLabelDetail().getContent(), dataPoint);
    }
}

