/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.designer.style.datasheet;

import com.fr.base.FRContext;
import com.fr.chart.chartattr.Chart;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartglyph.DataSheet;
import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.design.dialog.BasicScrollPane;
import com.fr.design.gui.icheckbox.UICheckBox;
import com.fr.design.gui.ilable.UILabel;
import com.fr.design.gui.style.FormatPane;
import com.fr.design.layout.TableLayoutHelper;
import com.fr.design.mainframe.chart.PaneTitleConstants;
import com.fr.design.mainframe.chart.gui.style.ChartTextAttrPane;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.attr.axis.AxisType;
import com.fr.plugin.chart.attr.plot.VanChartRectanglePlot;
import com.fr.plugin.chart.designer.component.border.VanChartBorderPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class VanChartDataSheetPane
extends BasicScrollPane<Chart> {
    private static final long serialVersionUID = 5547658195141361981L;
    private UICheckBox isShowDataSheet;
    private JPanel dataSheetPane;
    private ChartTextAttrPane textAttrPane;
    private FormatPane formatPane;
    private VanChartBorderPane borderPane;

    private void checkDataSheetPaneUse() {
        this.dataSheetPane.setVisible(this.isShowDataSheet.isSelected());
    }

    private JPanel createDataSheetPane() {
        this.textAttrPane = new ChartTextAttrPane();
        this.formatPane = new FormatPane();
        this.formatPane.setForDataSheet();
        this.borderPane = new VanChartBorderPane();
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{46.0, d2};
        double[] dArray2 = new double[]{d, d, d, d, d, d, d, d};
        Component[][] componentArray = new Component[][]{{new UILabel(Inter.getLocText((String)"FR-Designer-Widget_Style")), null}, {null, this.textAttrPane}, {new JSeparator(), null}, {new UILabel(Inter.getLocText((String)"Plugin-ChartF_DataType")), null}, {null, this.formatPane}, {new JSeparator(), null}, {this.borderPane, null}, {new JSeparator(), null}};
        return TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray2, (double[])dArray);
    }

    public String title4PopupWindow() {
        return PaneTitleConstants.CHART_STYLE_DATA_TITLE;
    }

    protected JPanel createContentPane() {
        return new ContentPane();
    }

    public void updateBean(Chart chart) {
        if (chart == null) {
            return;
        }
        Plot plot = chart.getPlot();
        if (plot == null) {
            return;
        }
        DataSheet dataSheet = plot.getDataSheet();
        if (dataSheet == null) {
            dataSheet = new DataSheet();
            dataSheet.setFormat((Format)VanChartAttrHelper.VALUE_FORMAT);
            plot.setDataSheet(dataSheet);
        }
        if (this.isShowDataSheet.isSelected()) {
            dataSheet.setVisible(true);
            dataSheet.setFont(this.textAttrPane.updateFRFont());
            dataSheet.setFormat(this.formatPane.update());
            this.borderPane.update((GeneralInfo)dataSheet);
        } else {
            dataSheet.setVisible(false);
        }
    }

    public void populateBean(Chart chart) {
        if (chart == null || chart.getPlot() == null) {
            return;
        }
        VanChartRectanglePlot vanChartRectanglePlot = (VanChartRectanglePlot)chart.getPlot();
        if (vanChartRectanglePlot.getXAxisList().size() == 1 && ComparatorUtils.equals((Object)((Object)vanChartRectanglePlot.getDefaultXAxis().getAxisType()), (Object)((Object)AxisType.AXIS_CATEGORY)) && vanChartRectanglePlot.getDefaultXAxis().getPosition() == 3) {
            this.isShowDataSheet.setEnabled(true);
            DataSheet dataSheet = chart.getPlot().getDataSheet();
            if (dataSheet != null) {
                this.isShowDataSheet.setSelected(dataSheet.isVisible());
                FRFont fRFont = FRContext.getDefaultValues().getFRFont() == null ? FRFont.getInstance() : FRContext.getDefaultValues().getFRFont();
                this.textAttrPane.populate(dataSheet.getFont() == null ? fRFont : dataSheet.getFont());
                this.formatPane.populateBean(dataSheet.getFormat());
                this.borderPane.populate((GeneralInfo)dataSheet);
            }
            this.checkDataSheetPaneUse();
            return;
        }
        this.isShowDataSheet.setSelected(false);
        this.isShowDataSheet.setEnabled(false);
        this.checkDataSheetPaneUse();
    }

    private class ContentPane
    extends JPanel {
        private static final long serialVersionUID = 5601169655874455336L;

        public ContentPane() {
            this.initComponents();
        }

        private void initComponents() {
            VanChartDataSheetPane.this.isShowDataSheet = new UICheckBox(Inter.getLocText((String)"Plugin-ChartF_Show_Data_Sheet"));
            VanChartDataSheetPane.this.dataSheetPane = VanChartDataSheetPane.this.createDataSheetPane();
            double d = -2.0;
            double d2 = -1.0;
            double[] dArray = new double[]{d2};
            double[] dArray2 = new double[]{d, d, d};
            Component[][] componentArray = new Component[][]{{VanChartDataSheetPane.this.isShowDataSheet}, {new JSeparator()}, {VanChartDataSheetPane.this.dataSheetPane}};
            JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray2, (double[])dArray);
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel, "Center");
            VanChartDataSheetPane.this.isShowDataSheet.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VanChartDataSheetPane.this.checkDataSheetPaneUse();
                }
            });
        }
    }
}

