/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.designer.component.background;

import com.fr.base.background.GradientBackground;
import com.fr.design.event.UIObserverListener;
import com.fr.design.gui.ibutton.UIButtonGroup;
import com.fr.design.gui.ilable.UILabel;
import com.fr.design.layout.TableLayoutHelper;
import com.fr.design.mainframe.backgroundpane.GradientBackgroundQuickPane;
import com.fr.general.Background;
import com.fr.general.Inter;
import com.fr.plugin.chart.designer.component.background.VanChartGradientBar;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VanChartGradientPane
extends GradientBackgroundQuickPane {
    protected static final int CHART_GRADIENT_WIDTH = 150;
    private static final long serialVersionUID = 256594362341221087L;
    private VanChartGradientBar gradientBar;
    private UIButtonGroup<Integer> directionPane;

    public VanChartGradientPane() {
        this.constructPane();
    }

    protected void constructPane() {
        String[] stringArray = new String[]{Inter.getLocText((String)"Utils-Left_to_Right"), Inter.getLocText((String)"Utils-Top_to_Bottom")};
        Object[] objectArray = new Integer[]{0, 1};
        this.directionPane = new UIButtonGroup(stringArray, objectArray);
        this.directionPane.setSelectedIndex(0);
        this.gradientBar = new VanChartGradientBar(4, 150);
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d, d2};
        double[] dArray2 = new double[]{d, d};
        Component[][] componentArray = new Component[][]{{this.gradientBar, null}, {new UILabel(Inter.getLocText((String)"Plugin-Chart_Gradient_Direction") + ":"), this.directionPane}};
        JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray2, (double[])dArray);
        this.setLayout(new BorderLayout());
        this.add(jPanel, "Center");
    }

    public void populateBean(Background background) {
        GradientBackground gradientBackground = (GradientBackground)background;
        this.gradientBar.getSelectColorPointBtnP1().setColorInner(gradientBackground.getStartColor());
        this.gradientBar.getSelectColorPointBtnP2().setColorInner(gradientBackground.getEndColor());
        this.directionPane.setSelectedItem((Object)gradientBackground.getDirection());
        this.gradientBar.repaint();
    }

    public GradientBackground updateBean() {
        GradientBackground gradientBackground = new GradientBackground(this.gradientBar.getSelectColorPointBtnP1().getColorInner(), this.gradientBar.getSelectColorPointBtnP2().getColorInner());
        gradientBackground.setDirection(((Integer)this.directionPane.getSelectedItem()).intValue());
        return gradientBackground;
    }

    public void registerChangeListener(final UIObserverListener uIObserverListener) {
        this.gradientBar.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                uIObserverListener.doChange();
            }
        });
        this.directionPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                uIObserverListener.doChange();
            }
        });
    }

    public boolean accept(Background background) {
        return background instanceof GradientBackground;
    }

    public String title4PopupWindow() {
        return Inter.getLocText((String)"Plugin-Chart_Gradient_Color");
    }
}

