/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.bubble;

import com.fr.base.Utils;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.ChartFunctionProcessor;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.chartattr.ChartXMLUtils;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartdata.BubbleChartData;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartdata.TopChartData;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.data.condition.Result;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.plugin.chart.base.AttrLabel;
import com.fr.plugin.chart.base.AttrLabelDetail;
import com.fr.plugin.chart.base.AttrTooltip;
import com.fr.plugin.chart.base.AttrTooltipContent;
import com.fr.plugin.chart.bubble.VanChartBubbleDataPoint;
import com.fr.plugin.chart.bubble.VanChartBubblePlotGlyph;
import com.fr.plugin.chart.bubble.attr.VanChartAttrBubble;
import com.fr.plugin.chart.glyph.VanChartDataPoint;
import com.fr.plugin.chart.glyph.VanChartDataSeries;
import com.fr.plugin.chart.scatter.VanChartScatterPlot;
import com.fr.plugin.chart.scatter.attr.ScatterAttrLabel;
import com.fr.plugin.chart.scatter.attr.ScatterAttrTooltip;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class VanChartBubblePlot
extends VanChartScatterPlot {
    public static final String VAN_CHART_BUBBLE_PLOT_ID = "VanChartBubblePlot";
    private boolean forceBubble = false;
    private static final String[][] X_VALUE = new String[][]{{"157.93", "134.56", "102.10", "179.98", "30.62", "80.94", "22.58", "62.90", "70.86", "78.06"}, {"36.37", "113.45", "110.07", "171.80", "146.70", "33.54", "57.55", "31.47", "35.29", "67.29"}};
    private static final String[][] Y_VALUE = new String[][]{{"160.68", "28.60", "96.92", "83.14", "129.47", "124.15", "32.36", "31.55", "71.36", "79.88"}, {"152.59", "140.72", "177.82", "170.27", "159.00", "162.55", "54.41", "67.04", "81.10", "147.19"}};
    private static final String[][] Z_VALUE = new String[][]{{"-34.66", "-93.93", "39.39", "77.58", "92.53", "-18.55", "-52.03", "71.72", "-1.67", "-83.00"}, {"5.20", "-26.66", "-46.43", "83.37", "64.34", "34.82", "-43.43", "89.76", "27.57", "6.09"}};
    private static final String[] X_ITEM = new String[]{"North", "South"};
    private static final Object[] CATEGORY_VALUE = new Object[]{"16", "51", "60", "52", "24", "49", "50", "54", "60", "39"};
    private static final Object[] BUBBLE_SERIES_NAME = new Object[]{Inter.getLocText((String)"FR-Chart-Data_Series") + "1", Inter.getLocText((String)"FR-Chart-Data_Series") + "2"};
    private static final Object[][] FORCE_BUBBLE_VALUE = new Object[][]{{"-7.96", "41.86", "-74.58", "12.24", "17.10", "-43.69", "36.81", "-1.03", "54.81", "-21.59"}, {"32.15", "-20.92", "65.04", "73.23", "2.86", "-41.71", "37.40", "-7.53", "15.14", "52.80"}};

    public boolean isForceBubble() {
        return this.forceBubble;
    }

    public void setForceBubble(boolean bl) {
        this.forceBubble = bl;
    }

    public VanChartBubblePlot() {
    }

    public VanChartBubblePlot(boolean bl) {
        this.forceBubble = bl;
    }

    @Override
    public PlotGlyph createPlotGlyph(ChartData chartData) {
        VanChartBubblePlotGlyph vanChartBubblePlotGlyph = new VanChartBubblePlotGlyph();
        vanChartBubblePlotGlyph.setForceBubble(this.isForceBubble());
        this.install4PlotGlyph(vanChartBubblePlotGlyph, chartData);
        this.installAxisGlyph(vanChartBubblePlotGlyph, chartData);
        return vanChartBubblePlotGlyph;
    }

    @Override
    protected void addSeries2PlotGlyph(PlotGlyph plotGlyph, ChartData chartData) {
        if (this.isForceBubble() && chartData instanceof BubbleChartData) {
            return;
        }
        NormalChartData normalChartData = this.isForceBubble() ? (NormalChartData)chartData : ChartXMLUtils.chartData4Bubble((ChartData)chartData);
        this.addSeriesByIndex(plotGlyph, (ChartData)normalChartData);
        this.dealDataSeriesAndPointOtherAttr(plotGlyph);
    }

    @Override
    protected void dealDataPointCustomCondition(VanChartDataPoint vanChartDataPoint, ConditionCollection conditionCollection, VanChartDataSeries vanChartDataSeries) {
        this.dealDataPointAttrBackgroundCustomCondition(vanChartDataPoint, conditionCollection, vanChartDataSeries);
        this.dealDataPointAttrLabelCustomCondition(vanChartDataPoint, conditionCollection);
        this.dealDataPointAttrTooltipCustomCondition(vanChartDataPoint, conditionCollection);
        this.dealDataPointAttrBubbleCustomCondition(vanChartDataPoint, conditionCollection, vanChartDataSeries);
        this.dealDataPointAttrAlphaCustomCondition(vanChartDataPoint, conditionCollection);
    }

    @Override
    protected void dealDataSeriesCustomCondition(VanChartDataSeries vanChartDataSeries, ConditionCollection conditionCollection) {
        this.dealDataSeriesAttrBackgroundCustomCondition(vanChartDataSeries, conditionCollection);
        this.dealDataSeriesAttrBubbleCustomCondition(vanChartDataSeries, conditionCollection);
        this.dealDataSeriesAttrAlphaCustomCondition(vanChartDataSeries, conditionCollection);
    }

    protected void addSeriesByIndex(PlotGlyph plotGlyph, ChartData chartData) {
        TopChartData topChartData = (TopChartData)chartData;
        int n = GeneralUtils.objectToNumber((Object)this.getDiffInfoFromChartData(chartData, Diff.SERIES_COUNT, -1, -1)).intValue();
        for (int i = 0; i < n; ++i) {
            DataSeries dataSeries = this.createDataSeries(i);
            Object object = this.getDiffInfoFromChartData(chartData, Diff.SERIES_PRESENT_LABEL, i, -1);
            dataSeries.setSeriesName(Utils.objectToString((Object)object));
            plotGlyph.addSeries(dataSeries);
            for (int j = 0; j < topChartData.getCategoryLabelCount(); ++j) {
                Object object2;
                VanChartBubbleDataPoint vanChartBubbleDataPoint = (VanChartBubbleDataPoint)this.createDataPoint();
                vanChartBubbleDataPoint.setCategoryIndex(j);
                vanChartBubbleDataPoint.setSeriesIndex(i);
                double d = 0.0;
                if (i < n && j < topChartData.getCategoryLabelCount()) {
                    object2 = (Number)this.getDiffInfoFromChartData(chartData, Diff.VALUE, i, j);
                    if (object2 != null) {
                        d = ((Number)object2).doubleValue();
                    } else {
                        vanChartBubbleDataPoint.setValueIsNull(true);
                        d = 0.0;
                    }
                    vanChartBubbleDataPoint.setValue(d);
                    if (!this.isForceBubble()) {
                        object2 = ((BubbleChartData)topChartData).getSize(i, j);
                        if (object2 != null) {
                            d = ((Number)object2).doubleValue();
                        } else {
                            vanChartBubbleDataPoint.setSizeIsNull(true);
                            d = 0.0;
                        }
                        vanChartBubbleDataPoint.setSizeValue(d);
                    }
                    vanChartBubbleDataPoint.setForceBubble(this.isForceBubble());
                }
                if (j < topChartData.getCategoryLabelCount()) {
                    object2 = this.getDiffInfoFromChartData(chartData, Diff.CATEGORY_PRESENT_LABEL, i, j);
                    vanChartBubbleDataPoint.setCategoryName(Utils.objectToString((Object)object2));
                    vanChartBubbleDataPoint.setCategoryOriginalName(Utils.objectToString((Object)object2));
                }
                if (i < n) {
                    vanChartBubbleDataPoint.setSeriesName(Utils.objectToString((Object)object));
                    vanChartBubbleDataPoint.setSeriesOriginalName(Utils.objectToString((Object)object));
                }
                dataSeries.addDataPoint((DataPoint)vanChartBubbleDataPoint);
            }
        }
    }

    private Object getDiffInfoFromChartData(ChartData chartData, Diff diff, int n, int n2) {
        switch (diff) {
            case SERIES_COUNT: {
                return this.isForceBubble() ? ((NormalChartData)chartData).getSeriesCount() : ((BubbleChartData)chartData).getItemCount();
            }
            case SERIES_PRESENT_LABEL: {
                return this.isForceBubble() ? ((NormalChartData)chartData).getSeriesPresentLabel(n) : ((BubbleChartData)chartData).getItems()[n];
            }
            case CATEGORY_PRESENT_LABEL: {
                return this.isForceBubble() ? chartData.getCategoryPresentLabel(n2) : ((BubbleChartData)chartData).getX(n, n2);
            }
            case VALUE: {
                return this.isForceBubble() ? (Number)((NormalChartData)chartData).getValueAt(n, n2) : (Number)((BubbleChartData)chartData).getY(n, n2);
            }
        }
        return null;
    }

    protected void dealDataSeriesAttrBubbleCustomCondition(VanChartDataSeries vanChartDataSeries, ConditionCollection conditionCollection) {
        VanChartAttrBubble vanChartAttrBubble = (VanChartAttrBubble)conditionCollection.getCustomDataSeriesCondition(VanChartAttrBubble.class, (Result)vanChartDataSeries);
        vanChartDataSeries.setAttrBubble(vanChartAttrBubble);
    }

    private void dealDataPointAttrBubbleCustomCondition(VanChartDataPoint vanChartDataPoint, ConditionCollection conditionCollection, VanChartDataSeries vanChartDataSeries) {
        VanChartBubbleDataPoint vanChartBubbleDataPoint = (VanChartBubbleDataPoint)vanChartDataPoint;
        VanChartAttrBubble vanChartAttrBubble = (VanChartAttrBubble)conditionCollection.getCustomDataSeriesCondition(VanChartAttrBubble.class, (Result)vanChartDataPoint);
        VanChartAttrBubble vanChartAttrBubble2 = vanChartDataSeries.getAttrBubble();
        if (vanChartAttrBubble != null && !ComparatorUtils.equals((Object)((Object)vanChartAttrBubble2), (Object)((Object)vanChartAttrBubble))) {
            vanChartBubbleDataPoint.setAttrBubble(vanChartAttrBubble);
        }
    }

    @Override
    public String getPlotID() {
        return VAN_CHART_BUBBLE_PLOT_ID;
    }

    @Override
    public boolean matchPlotType(Plot plot) {
        return plot instanceof VanChartBubblePlot;
    }

    @Override
    public FunctionProcessor getFunctionToRecord() {
        return ChartFunctionProcessor.BUBBLE_VAN_CHART;
    }

    @Override
    public String getPlotName() {
        return Inter.getLocText((String)"Plugin-ChartF_NewBubble");
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof VanChartBubblePlot && super.equals(object) && ComparatorUtils.equals((Object)((VanChartBubblePlot)object).isForceBubble(), (Object)this.isForceBubble());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        VanChartBubblePlot vanChartBubblePlot = (VanChartBubblePlot)super.clone();
        vanChartBubblePlot.setForceBubble(this.isForceBubble());
        return vanChartBubblePlot;
    }

    @Override
    protected void readPlotXML(XMLableReader xMLableReader) {
        String string;
        super.readPlotXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("VanChartBubblePlotAttr")) {
            this.setForceBubble(xMLableReader.getAttrAsBoolean("forceBubble", false));
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("VanChartBubblePlotAttr").attr("forceBubble", this.isForceBubble()).end();
    }

    @Override
    public DataSeriesCondition getAttrLabelFromConditionCollection() {
        ConditionAttr conditionAttr = this.getConditionCollection().getDefaultAttr();
        DataSeriesCondition dataSeriesCondition = this.isForceBubble() ? conditionAttr.getExisted(AttrLabel.class) : conditionAttr.getExisted(ScatterAttrLabel.class);
        return dataSeriesCondition;
    }

    @Override
    public DataSeriesCondition getAttrTooltipFromConditionCollection() {
        ConditionAttr conditionAttr = this.getConditionCollection().getDefaultAttr();
        DataSeriesCondition dataSeriesCondition = this.isForceBubble() ? conditionAttr.getExisted(AttrTooltip.class) : conditionAttr.getExisted(ScatterAttrTooltip.class);
        return dataSeriesCondition;
    }

    @Override
    protected void dealDataPointAttrLabelCustomCondition(VanChartDataPoint vanChartDataPoint, ConditionCollection conditionCollection) {
        AttrLabel attrLabel = this.isForceBubble() ? (AttrLabel)conditionCollection.getCustomDataSeriesCondition(AttrLabel.class, (Result)vanChartDataPoint) : (ScatterAttrLabel)conditionCollection.getCustomDataSeriesCondition(ScatterAttrLabel.class, (Result)vanChartDataPoint);
        vanChartDataPoint.setLabel(attrLabel);
    }

    @Override
    protected void dealDataPointAttrTooltipCustomCondition(VanChartDataPoint vanChartDataPoint, ConditionCollection conditionCollection) {
        AttrTooltip attrTooltip = this.isForceBubble() ? (AttrTooltip)conditionCollection.getCustomDataSeriesCondition(AttrTooltip.class, (Result)vanChartDataPoint) : (ScatterAttrTooltip)conditionCollection.getCustomDataSeriesCondition(ScatterAttrTooltip.class, (Result)vanChartDataPoint);
        vanChartDataPoint.setTooltip(attrTooltip);
    }

    @Override
    public boolean isSupportZoomCategoryAxis() {
        return !this.forceBubble;
    }

    @Override
    protected DataPoint createDataPoint() {
        return new VanChartBubbleDataPoint();
    }

    @Override
    public AttrTooltip getDefaultAttrTooltip() {
        if (this.isForceBubble()) {
            AttrTooltip attrTooltip = new AttrTooltip();
            AttrTooltipContent attrTooltipContent = attrTooltip.getContent();
            attrTooltipContent.getCategoryFormat().setEnable(true);
            attrTooltipContent.getValueFormat().setEnable(true);
            attrTooltipContent.getPercentFormat().setEnable(false);
            attrTooltipContent.getSeriesFormat().setEnable(true);
            return attrTooltip;
        }
        return super.getDefaultAttrTooltip();
    }

    @Override
    public AttrLabel getDefaultAttrLabel() {
        if (this.isForceBubble()) {
            AttrLabel attrLabel = new AttrLabel();
            AttrLabelDetail attrLabelDetail = attrLabel.getAttrLabelDetail();
            attrLabelDetail.getContent().getCategoryFormat().setEnable(false);
            attrLabelDetail.getContent().getValueFormat().setEnable(false);
            attrLabelDetail.getContent().getPercentFormat().setEnable(false);
            attrLabelDetail.getContent().getSeriesFormat().setEnable(true);
            return attrLabel;
        }
        return super.getDefaultAttrLabel();
    }

    public boolean isHaveAxis() {
        return !this.forceBubble;
    }

    @Override
    public ChartData defaultChartData() {
        return this.isForceBubble() ? new NormalChartData(CATEGORY_VALUE, BUBBLE_SERIES_NAME, FORCE_BUBBLE_VALUE) : new BubbleChartData((Object[])X_ITEM, (Object[][])X_VALUE, (Object[][])Y_VALUE, (Object[][])Z_VALUE);
    }

    private static enum Diff {
        SERIES_COUNT(0),
        SERIES_PRESENT_LABEL(1),
        CATEGORY_PRESENT_LABEL(2),
        VALUE(3);

        private int index;

        private Diff(int n2) {
            this.index = n2;
        }
    }
}

