/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.base;

import com.fr.base.background.ColorBackground;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class AttrAreaSeriesFillColorBackground
extends DataSeriesCondition {
    public static final String XML_TAG = "AttrAreaSeriesFillColorBackground";
    private static final long serialVersionUID = -2908359581313365154L;
    private ColorBackground colorBackground;
    private double alpha = 0.15;

    public void setAlpha(double d) {
        this.alpha = d;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setColorBackground(ColorBackground colorBackground) {
        this.colorBackground = colorBackground;
    }

    public ColorBackground getColorBackground() {
        return this.colorBackground;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("Attr")) {
            if (xMLableReader.getAttrAsColor("color", null) != null) {
                this.setColorBackground(ColorBackground.getInstance((Color)xMLableReader.getAttrAsColor("color", null)));
            }
            this.alpha = xMLableReader.getAttrAsDouble("alpha", 1.0);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("alpha", this.alpha);
        if (this.colorBackground != null && this.colorBackground.getColor() != null) {
            xMLPrintWriter.attr("color", this.colorBackground.getColor().getRGB());
        }
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof AttrAreaSeriesFillColorBackground && ComparatorUtils.equals((Object)((AttrAreaSeriesFillColorBackground)((Object)object)).getColorBackground(), (Object)this.getColorBackground()) && ComparatorUtils.equals((Object)((AttrAreaSeriesFillColorBackground)((Object)object)).getAlpha(), (Object)this.getAlpha());
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        this.addToJSONObject(jSONObject, null);
        return jSONObject;
    }

    public void addToJSONObject(JSONObject jSONObject, Color color) throws JSONException {
        if (this.colorBackground != null) {
            jSONObject.put("fillColor", (Object)StableUtils.javaColorToCSSColor((Color)this.colorBackground.getColor()));
        } else if (color != null) {
            jSONObject.put("fillColor", (Object)StableUtils.javaColorToCSSColor((Color)color));
        } else {
            jSONObject.put("fillColor", true);
        }
        jSONObject.put("fillColorOpacity", this.getAlpha());
    }

    public String getConditionType() {
        return XML_TAG;
    }
}

