/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.attr;

import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralUtils;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.List;

public class VanChartZoom
implements XMLable {
    public static final String XML_TAG = "VanChartZoom";
    private static final long serialVersionUID = 1891400392215463542L;
    private boolean zoomVisible = false;
    private boolean zoomResize = true;
    private Object from = "";
    private Object to = "";
    private String zoomType = "xy";

    public void setFrom(Object object) {
        this.from = object;
    }

    public void setTo(Object object) {
        this.to = object;
    }

    public void setZoomResize(boolean bl) {
        this.zoomResize = bl;
    }

    public void setZoomType(String string) {
        this.zoomType = string;
    }

    public void setZoomVisible(boolean bl) {
        this.zoomVisible = bl;
    }

    public String getZoomType() {
        return this.zoomType;
    }

    public Object getTo() {
        return this.to;
    }

    public Object getFrom() {
        return this.from;
    }

    public boolean isZoomVisible() {
        return this.zoomVisible;
    }

    public boolean isZoomResize() {
        return this.zoomResize;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("zoomAttr").attr("zoomVisible", this.zoomVisible).attr("zoomResize", this.zoomResize).attr("zoomType", this.zoomType).end();
        if (this.from != null) {
            GeneralXMLTools.writeObject((XMLPrintWriter)xMLPrintWriter, (Object)this.from, (String)"from");
        }
        if (this.to != null) {
            GeneralXMLTools.writeObject((XMLPrintWriter)xMLPrintWriter, (Object)this.to, (String)"to");
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("zoomAttr".equals(string)) {
                this.zoomVisible = xMLableReader.getAttrAsBoolean("zoomVisible", false);
                this.zoomResize = xMLableReader.getAttrAsBoolean("zoomResize", true);
                this.zoomType = xMLableReader.getAttrAsString("zoomType", "");
            } else if ("from".equals(string)) {
                this.from = GeneralXMLTools.readObject((XMLableReader)xMLableReader);
            } else if ("to".equals(string)) {
                this.to = GeneralXMLTools.readObject((XMLableReader)xMLableReader);
            }
        }
    }

    public void dealFormula(Calculator calculator) {
        Utils.dealFormulaValue((Object)this.from, (Calculator)calculator);
        Utils.dealFormulaValue((Object)this.to, (Calculator)calculator);
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        GeneralUtils.dealBuidExecuteSequence((Object)this.from, (List)list, (CalculatorProvider)calculator);
        GeneralUtils.dealBuidExecuteSequence((Object)this.to, (List)list, (CalculatorProvider)calculator);
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        mOD_COLUMN_ROW.mod_object(this.from);
        mOD_COLUMN_ROW.mod_object(this.to);
    }

    public boolean equals(Object object) {
        return object instanceof VanChartZoom && ComparatorUtils.equals((Object)((VanChartZoom)object).getFrom(), (Object)this.getFrom()) && ComparatorUtils.equals((Object)((VanChartZoom)object).getTo(), (Object)this.getTo()) && ComparatorUtils.equals((Object)((VanChartZoom)object).getZoomType(), (Object)this.getZoomType()) && ComparatorUtils.equals((Object)((VanChartZoom)object).isZoomResize(), (Object)this.isZoomResize()) && ComparatorUtils.equals((Object)((VanChartZoom)object).isZoomVisible(), (Object)this.isZoomVisible());
    }

    public Object clone() throws CloneNotSupportedException {
        VanChartZoom vanChartZoom = (VanChartZoom)super.clone();
        vanChartZoom.setFrom(this.getFrom());
        vanChartZoom.setTo(this.getTo());
        vanChartZoom.setZoomResize(this.isZoomResize());
        vanChartZoom.setZoomType(this.getZoomType());
        vanChartZoom.setZoomVisible(this.isZoomVisible());
        return vanChartZoom;
    }

    public JSONObject toJSONObject() throws JSONException {
        Formula formula;
        Object object;
        JSONObject jSONObject = new JSONObject();
        if (!this.zoomVisible && !ComparatorUtils.equals((Object)this.zoomType, (Object)"none")) {
            jSONObject.put("zoomType", (Object)this.zoomType);
        }
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("visible", this.zoomVisible);
        String string = Utils.objectToString((Object)this.from);
        if (this.from instanceof Formula && (object = (Formula)this.from).getResult() != null) {
            string = Utils.objectToString((Object)object.getResult());
        }
        jSONObject2.put("from", (Object)string);
        object = Utils.objectToString((Object)this.to);
        if (this.to instanceof Formula && (formula = (Formula)this.to).getResult() != null) {
            object = Utils.objectToString((Object)formula.getResult());
        }
        jSONObject2.put("to", object);
        jSONObject2.put("resize", this.zoomResize);
        jSONObject.put("zoomTool", (Object)jSONObject2);
        return jSONObject;
    }
}

