/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.resources.rawcert;

import cn.com.infosec.netsign.frame.util.CertificateUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.resources.FileResource;
import cn.com.infosec.netsign.resources.Resource;
import cn.com.infosec.netsign.resources.ResourceDeleter;
import cn.com.infosec.netsign.resources.ResourceException;
import cn.com.infosec.netsign.resources.ResourceFilter;
import cn.com.infosec.netsign.resources.ResourceSetter;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResource;
import cn.com.infosec.netsign.resources.rawcert.RAWCertResource;
import cn.com.infosec.netsign.resources.rawcert.RAWCertResourceList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public class PBCRAWCertResourceList
extends ArrayList
implements RAWCertResourceList,
Serializable,
Cloneable {
    private static final long serialVersionUID = -4128940704229200143L;
    private String path;
    private String detailFile;
    private String name;
    private transient Logger logger;
    private boolean inited = false;
    private HashMap bankCodeCertMap = new HashMap();
    private HashMap dnCertMap = new HashMap();

    public Logger getLogger() {
        return this.logger;
    }

    public PBCRAWCertResource get(String DNorBankCode) {
        PBCRAWCertResource cert = (PBCRAWCertResource)this.bankCodeCertMap.get(DNorBankCode);
        if (cert == null) {
            DNorBankCode = CertificateUtil.trimDN(DNorBankCode);
            cert = (PBCRAWCertResource)this.dnCertMap.get(DNorBankCode);
        }
        if (cert == null) {
            cert = (PBCRAWCertResource)this.dnCertMap.get(CertificateUtil.turnDN(DNorBankCode));
        }
        return cert;
    }

    public String getPath() {
        return this.path;
    }

    public HashMap getBankCodeCertMap() {
        return this.bankCodeCertMap;
    }

    public HashMap getDnCertMap() {
        return this.dnCertMap;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Resource getResource(int index) {
        return (Resource)super.get(index);
    }

    public RAWCertResource getRAWCertResource(int index) {
        return (RAWCertResource)super.get(index);
    }

    public boolean add(PBCRAWCertResource cert) {
        this.bankCodeCertMap.put(cert.getBankCode(), cert);
        if (cert.getCertDN() != null && !cert.getCertDN().equals("")) {
            this.dnCertMap.put(cert.getCertDN(), cert);
        }
        return super.add(cert);
    }

    public void add(int index, PBCRAWCertResource cert) {
        this.bankCodeCertMap.put(cert.getBankCode(), cert);
        if (cert.getCertDN() != null && !cert.getCertDN().equals("")) {
            this.dnCertMap.put(cert.getCertDN(), cert);
        }
        super.add(index, cert);
    }

    public void add(int index, Object o) {
        if (o instanceof PBCRAWCertResource) {
            PBCRAWCertResource cert = (PBCRAWCertResource)o;
            this.bankCodeCertMap.put(cert.getBankCode(), cert);
            if (cert.getCertDN() != null && !cert.getCertDN().equals("")) {
                this.dnCertMap.put(cert.getCertDN(), cert);
            }
        } else {
            throw new RuntimeException("Input must be a PBCRAWCertResource");
        }
        super.add(index, o);
    }

    public boolean add(Object o) {
        if (o instanceof PBCRAWCertResource) {
            PBCRAWCertResource cert = (PBCRAWCertResource)o;
            this.bankCodeCertMap.put(cert.getBankCode(), cert);
            if (cert.getCertDN() != null && !cert.getCertDN().equals("")) {
                this.dnCertMap.put(cert.getCertDN(), cert);
            }
            return super.add(o);
        }
        throw new RuntimeException("Input must be a PBCRAWCertResource");
    }

    public List getResource(ResourceFilter rf) {
        if (rf == null) {
            return null;
        }
        return rf.filtrateResource(this);
    }

    public boolean setResource(ResourceSetter rs) throws ResourceException {
        if (rs == null) {
            return false;
        }
        return rs.set(this);
    }

    public boolean deleteResource(ResourceDeleter rd) throws ResourceException {
        if (rd == null) {
            return false;
        }
        return rd.delete(this);
    }

    void deletePBCRAWCert(PBCRAWCertResource cert) {
        super.remove(cert);
        this.bankCodeCertMap.remove(cert.getBankCode());
        if (cert.getCertDN() != null && !cert.getCertDN().equals("")) {
            this.dnCertMap.remove(cert.getCertDN());
        }
    }

    public void load(Properties ps) throws ResourceException {
        if (this.inited) {
            return;
        }
        this.path = ps.getProperty("path");
        if (this.path == null) {
            throw new ResourceException("Parameter missing : path");
        }
        this.detailFile = ps.getProperty("detailfile");
        if (this.detailFile == null) {
            this.detailFile = String.valueOf(this.path) + "/detail.conf";
        }
        this.initLogger(ps);
        this.initRawCerts();
    }

    private void initRawCerts() {
        FileInputStream in = null;
        File f = new File(this.detailFile);
        if (f.exists() && f.length() > 0L) {
            try {
                try {
                    in = new FileInputStream(this.detailFile);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    Properties ps = new Properties();
                    ps.setProperty("path", this.path);
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).equals("")) continue;
                        ps.setProperty(PBCRAWCert.KEY_DETAIL, line);
                        PBCRAWCert cert = new PBCRAWCert();
                        try {
                            cert.load(ps);
                            this.add(cert);
                        }
                        catch (Exception e) {
                            ConsoleLogger.logException(e);
                        }
                    }
                    this.log(String.valueOf(this.name) + " load " + this.size() + " records");
                }
                catch (Exception e) {
                    ConsoleLogger.logException(e);
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private void initLogger(Properties ps) throws ResourceException {
        String logfile = ps.getProperty("logfile");
        String logSize = ps.getProperty("logsize", "10MB");
        String logIndex = ps.getProperty("logmaxindex", "10");
        try {
            this.logger = Logger.getLogger((String)logfile);
            PatternLayout patten = new PatternLayout("%d{yyyy-MM-dd HH:mm:ss} %m%n");
            RollingFileAppender appender = new RollingFileAppender((Layout)patten, logfile, true);
            appender.setMaxFileSize(logSize);
            appender.setMaxBackupIndex(Integer.parseInt(logIndex));
            this.logger.addAppender((Appender)appender);
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            throw new ResourceException("Create logger failed:" + logfile);
        }
    }

    public void reload() throws ResourceException {
        if (this.logger != null) {
            this.logger.info((Object)("Reloading resource " + this.name));
        }
        this.clear();
        this.initRawCerts();
    }

    public void saveDetail() throws ResourceException {
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(this.detailFile);
                String detail = this.describe();
                out.write(detail.getBytes("GBK"));
                out.flush();
            }
            catch (Exception e) {
                ConsoleLogger.logException(e);
                throw new ResourceException(e);
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void saveAll() throws ResourceException {
        this.saveDetail();
        int i = 0;
        int size = this.size();
        while (i < size) {
            ((FileResource)this.get(i)).save();
            ++i;
        }
    }

    public String describe() {
        if (this.size() > 0) {
            StringBuilder sbul = new StringBuilder();
            int i = 0;
            int size = this.size();
            while (i < size) {
                sbul.append(((Resource)this.get(i)).describe()).append("\n");
                ++i;
            }
            return sbul.toString();
        }
        return "";
    }

    public void log(String msg) {
        if (this.logger != null) {
            this.logger.info((Object)msg);
        }
    }

    public String getDetailFile() {
        return this.detailFile;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof PBCRAWCertResourceList) {
            PBCRAWCertResourceList prcrl = (PBCRAWCertResourceList)o;
            if (this.size() != prcrl.size()) {
                return false;
            }
            if (this.size() == 0) {
                return true;
            }
            int i = 0;
            int size = this.size();
            while (i < size) {
                PBCRAWCert cert1 = (PBCRAWCert)this.get(i);
                if (cert1 != null) {
                    PBCRAWCert cert2 = (PBCRAWCert)prcrl.get(cert1.getBankCode());
                    if (cert2 == null) {
                        return false;
                    }
                    if (cert1.getCertDN() != null && !cert1.getCertDN().equals(cert2.getCertDN()) || cert1.getCertDN() == null && cert2.getCertDN() != null) {
                        return false;
                    }
                    int ms1 = cert1.getModifyTimes().size();
                    int ms2 = cert2.getModifyTimes().size();
                    if (ms1 == 0 && ms2 != 0 || ms1 != 0 && ms2 == 0) {
                        return false;
                    }
                    if (!(ms1 == 0 && ms2 == 0 || cert1.getModifyTimes().get(ms1 - 1).equals(cert2.getModifyTimes().get(ms2 - 1)))) {
                        return false;
                    }
                } else {
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean isequals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof PBCRAWCertResourceList) {
            PBCRAWCertResourceList prcrl = (PBCRAWCertResourceList)o;
            if (this.size() != prcrl.size()) {
                return false;
            }
            if (this.size() == 0) {
                return true;
            }
            int i = 0;
            int size = this.size();
            while (i < size) {
                PBCRAWCert cert1 = (PBCRAWCert)this.get(i);
                if (cert1 != null) {
                    PBCRAWCert cert2 = (PBCRAWCert)prcrl.get(cert1.getBankCode());
                    if (cert2 == null) {
                        return false;
                    }
                    if (cert1.getCertDN() != null && !cert1.getCertDN().equals(cert2.getCertDN()) || cert1.getCertDN() == null && cert2.getCertDN() != null) {
                        return false;
                    }
                    long notbefore1 = cert1.getNotBeforeLong();
                    long notbefore2 = cert2.getNotBeforeLong();
                    if (notbefore1 == 0L && notbefore2 != 0L || notbefore1 != 0L && notbefore2 == 0L) {
                        return false;
                    }
                    if (notbefore1 == notbefore2) {
                        // empty if block
                    }
                } else {
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    public Object clone() {
        PBCRAWCertResourceList o = null;
        try {
            o = (PBCRAWCertResourceList)super.clone();
            o.bankCodeCertMap = (HashMap)o.bankCodeCertMap.clone();
            o.dnCertMap = (HashMap)o.dnCertMap.clone();
        }
        catch (Exception e) {
            return null;
        }
        return o;
    }
}

