/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.resources.rawcert;

import cn.com.infosec.asn1.x509.X509Extensions;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import cn.com.infosec.netsign.frame.util.CertificateUtil;
import cn.com.infosec.netsign.frame.util.PBCUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.resources.ResourceException;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResource;
import cn.com.infosec.oscca.sm2.SM2Certificate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class PBCRAWCert
implements PBCRAWCertResource,
Serializable {
    public static String KEY_PATH = "path";
    public static String KEY_DETAIL = "detail";
    public static String KEY_X509CERTIFICATE = "x509cert";
    private String fileName;
    private String certDN;
    private String turnedCertDN;
    private String issuerDN;
    private String serialNumber;
    private long notBefore;
    private long notAfter;
    private transient PublicKey pubk = null;
    private transient X509Certificate cert = null;
    private ArrayList crldp = null;
    private byte[] digest = null;
    private String bankName;
    private String bankID;
    private byte[] certEncode = null;
    private boolean inBlack = false;
    private ArrayList updateTimes = new ArrayList();
    private String path;
    private String bankCatalog;
    private String bankType;
    private String pbcCode;
    private String ccpc;
    private String drecCode;
    private String agentSettBank;
    private String suprList;
    private String sbstitnbk;
    private String debtorCity;
    private String sysCode;
    private String tel;
    private String effectDate;
    private String expDate;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof PBCRAWCert) {
            PBCRAWCert cert = (PBCRAWCert)o;
            if (this.bankID != cert.bankID && (this.bankID == null || cert.bankID == null)) {
                return false;
            }
            if (this.bankID != null && !this.bankID.equals(cert.bankID)) {
                return false;
            }
            if (this.certDN != cert.certDN && (this.certDN == null || cert.certDN == null)) {
                return false;
            }
            return this.certDN == null || this.certDN.equals(cert.certDN);
        }
        return false;
    }

    public void load(Properties ps) {
        this.path = ps.getProperty(KEY_PATH);
        String detail = ps.getProperty(KEY_DETAIL);
        if (detail != null && !detail.equals("")) {
            this.parseDetail(detail);
        }
        this.cert = (X509Certificate)ps.get(KEY_X509CERTIFICATE);
        if (this.cert == null && this.fileName != null && !this.fileName.equals("")) {
            this.cert = CertificateUtil.generateCertificate(this.fileName);
        }
        if (this.cert != null) {
            this.initCert();
        }
    }

    private void initCert() {
        this.certDN = this.cert.getSubjectDN().getName();
        this.certDN = CryptoUtil.trimDN((String)this.certDN);
        if (this.bankID == null || "".equals(this.bankID)) {
            this.bankID = PBCUtil.getBankID(this.certDN);
        }
        this.turnedCertDN = CryptoUtil.turnDN((String)this.certDN);
        this.issuerDN = this.cert.getIssuerDN().getName();
        this.issuerDN = CryptoUtil.trimDN((String)this.issuerDN);
        this.serialNumber = this.cert.getSerialNumber().toString(16);
        this.notAfter = this.cert.getNotAfter().getTime();
        this.notBefore = this.cert.getNotBefore().getTime();
        try {
            this.certEncode = this.cert.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        try {
            this.crldp = CryptoUtil.getcrldp((byte[])this.cert.getExtensionValue(X509Extensions.CRLDistributionPoints.getId()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            this.digest = md.digest(this.cert.getTBSCertificate());
        }
        catch (Exception md) {
            // empty catch block
        }
        try {
            this.pubk = this.cert.getPublicKey();
        }
        catch (Exception e) {
            try {
                this.cert = new SM2Certificate(this.cert, this.cert.getEncoded(), this.cert.getTBSCertificate());
                this.pubk = this.cert.getPublicKey();
            }
            catch (CertificateEncodingException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void parseDetail(String detail) {
        if (detail != null && !detail.equals("")) {
            String fzo = null;
            String certInfo = null;
            if (detail.contains("]|")) {
                int dateIndex = detail.lastIndexOf("]");
                fzo = detail.substring(dateIndex + 2);
                certInfo = detail.substring(0, dateIndex);
            } else {
                certInfo = detail;
            }
            String[] pieces = certInfo.split("\\|");
            this.bankName = pieces[0];
            this.bankID = pieces[1];
            boolean bl = this.inBlack = pieces[2].equals("") ? false : Boolean.parseBoolean(pieces[2]);
            if (pieces.length > 3) {
                if (pieces[3] != null && !pieces[3].equals("")) {
                    this.certDN = pieces[3];
                    this.fileName = String.valueOf(this.path) + "/" + this.certDN + ".cer";
                }
                if (pieces.length > 4 && !pieces[4].equals("")) {
                    int i = 4;
                    while (i < pieces.length) {
                        pieces[i] = pieces[i].replaceAll("\\[", "");
                        pieces[i] = pieces[i].replaceAll("\\]", "");
                        this.addModifyTime(pieces[i]);
                        ++i;
                    }
                }
            }
            if (fzo != null && fzo.length() == 13) {
                String[] row = fzo.split("\\|");
                this.bankCatalog = row[0];
                this.bankType = row[1];
                this.pbcCode = row[2];
                this.ccpc = row[3];
                this.drecCode = row[4];
                this.agentSettBank = row[5];
                this.suprList = row[6];
                this.sbstitnbk = row[7];
                this.debtorCity = row[8];
                this.sysCode = row[9];
                this.tel = row[10];
                this.effectDate = row[11];
                this.expDate = row[12];
            }
        }
    }

    public void reload(Properties ps) {
        this.load(ps);
    }

    public int compareTo(Object o) {
        if (o == null) {
            return Integer.MAX_VALUE;
        }
        if (o instanceof PBCRAWCert) {
            PBCRAWCert bi = (PBCRAWCert)o;
            String bnO = bi.getBankName();
            bnO = bnO == null ? "" : bnO;
            String thisBN = this.bankName == null ? "" : this.bankName;
            return thisBN.compareTo(bnO);
        }
        throw new ClassCastException();
    }

    public boolean save() throws ResourceException {
        if (this.cert == null) {
            return false;
        }
        if (this.fileName == null) {
            if (this.path == null) {
                return false;
            }
            this.fileName = String.valueOf(this.path) + "/" + this.getCertDN() + ".cer";
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.fileName);
            out.write(this.cert.getEncoded());
            out.flush();
            return true;
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            throw new ResourceException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean delete() throws ResourceException {
        File f;
        if (this.fileName == null) {
            if (this.path == null) {
                return false;
            }
            this.fileName = String.valueOf(this.path) + "/" + this.getCertDN() + ".cer";
        }
        if ((f = new File(this.fileName)).exists()) {
            try {
                f.delete();
                return true;
            }
            catch (Exception e) {
                ConsoleLogger.logException(e);
                throw new ResourceException(e);
            }
        }
        return true;
    }

    public boolean deleteAndSaveAs() throws ResourceException {
        File f;
        if (this.fileName == null) {
            if (this.path == null) {
                return false;
            }
            this.fileName = String.valueOf(this.path) + "/" + this.getCertDN() + ".cer";
        }
        if ((f = new File(this.fileName)).exists()) {
            String fileNamebak = String.valueOf(this.path) + "/deletedCerts/" + this.getCertDN() + ".cer";
            FileInputStream fi = null;
            FileOutputStream fo = null;
            AbstractInterruptibleChannel in = null;
            AbstractInterruptibleChannel out = null;
            try {
                fi = new FileInputStream(f);
                fo = new FileOutputStream(fileNamebak);
                in = fi.getChannel();
                out = fo.getChannel();
                ((FileChannel)in).transferTo(0L, ((FileChannel)in).size(), (WritableByteChannel)((Object)out));
                f.delete();
                return true;
            }
            catch (Exception e) {
                ConsoleLogger.logException(e);
                throw new ResourceException(e);
            }
            finally {
                try {
                    fi.close();
                    fo.close();
                    in.close();
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public String describe() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.bankName == null ? "" : this.bankName).append("|");
        buf.append(this.bankID == null ? "" : this.bankID).append("|");
        buf.append(this.inBlack).append("|");
        buf.append(this.certDN == null ? "" : this.certDN);
        Object[] times = this.updateTimes.toArray(new String[0]);
        Arrays.sort(times);
        int i = 0;
        int length = times.length;
        while (i < length) {
            buf.append("|");
            if (i == 0) {
                buf.append("[");
            }
            buf.append((String)times[i]);
            ++i;
        }
        buf.append("]|");
        buf.append(this.bankCatalog == null ? "" : this.bankCatalog).append("|");
        buf.append(this.bankType == null ? "" : this.bankType).append("|");
        buf.append(this.pbcCode == null ? "" : this.pbcCode).append("|");
        buf.append(this.ccpc == null ? "" : this.ccpc).append("|");
        buf.append(this.drecCode == null ? "" : this.drecCode).append("|");
        buf.append(this.agentSettBank == null ? "" : this.agentSettBank).append("|");
        buf.append(this.suprList == null ? "" : this.suprList).append("|");
        buf.append(this.sbstitnbk == null ? "" : this.sbstitnbk).append("|");
        buf.append(this.debtorCity == null ? "" : this.debtorCity).append("|");
        buf.append(this.sysCode == null ? "" : this.sysCode).append("|");
        buf.append(this.tel == null ? "" : this.tel).append("|");
        buf.append(this.effectDate == null ? "" : this.effectDate).append("|");
        buf.append(this.expDate == null ? "" : this.expDate);
        return buf.toString();
    }

    public void clearCertificateInfo() {
        this.fileName = null;
        this.certDN = null;
        this.turnedCertDN = null;
        this.issuerDN = null;
        this.serialNumber = null;
        this.notBefore = 0L;
        this.notAfter = 0L;
        this.pubk = null;
        this.cert = null;
        this.crldp = null;
        this.digest = null;
        this.certEncode = null;
        this.bankCatalog = null;
        this.bankType = null;
        this.pbcCode = null;
        this.ccpc = null;
        this.drecCode = null;
        this.agentSettBank = null;
        this.suprList = null;
        this.sbstitnbk = null;
        this.debtorCity = null;
        this.sysCode = null;
        this.tel = null;
        this.effectDate = null;
        this.expDate = null;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getCertDN() {
        return this.certDN;
    }

    public void setCertDN(String certDN) {
        this.certDN = certDN;
    }

    public String getTurnedCertDN() {
        return this.turnedCertDN;
    }

    public void setTurnedCertDN(String turnedCertDN) {
        this.turnedCertDN = turnedCertDN;
    }

    public String getIssuerDN() {
        return this.issuerDN;
    }

    public void setIssuerDN(String issuerDN) {
        this.issuerDN = issuerDN;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getNotBefore() {
        return String.valueOf(this.notBefore);
    }

    public long getNotBeforeLong() {
        return this.notBefore;
    }

    public void setNotBefore(long notBefore) {
        this.notBefore = notBefore;
    }

    public String getNotAfter() {
        return String.valueOf(this.notAfter);
    }

    public long getNotAfterLong() {
        return this.notAfter;
    }

    public void setNotAfter(long notAfter) {
        this.notAfter = notAfter;
    }

    public PublicKey getPublicKey() {
        return this.pubk;
    }

    public void setPublicKey(PublicKey pubk) {
        this.pubk = pubk;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public void setCert(X509Certificate cert) {
        this.cert = cert;
        if (cert != null) {
            this.initCert();
        }
    }

    public ArrayList getCrldp() {
        return this.crldp;
    }

    public void setCrldp(ArrayList crldp) {
        this.crldp = crldp;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public void setDigest(byte[] digest) {
        this.digest = digest;
    }

    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBankCode() {
        return this.bankID;
    }

    public void setBankCode(String bankCode) {
        this.bankID = bankCode;
    }

    public byte[] getCertEncoded() {
        return this.certEncode;
    }

    public void setCertEncoded(byte[] certEncode) {
        this.certEncode = certEncode;
    }

    public boolean isInBlackList() {
        return this.inBlack;
    }

    public void setBlackList(boolean inBlack) {
        this.inBlack = inBlack;
    }

    public List getModifyTimes() {
        return this.updateTimes;
    }

    public void setUpdateTimes(ArrayList updateTimes) {
        this.updateTimes = updateTimes;
    }

    public void addModifyTime() {
        this.updateTimes.add(PBCUtil.dateFormat.format(PBCUtil.getDate()));
    }

    public void addModifyTime(String time) {
        this.updateTimes.add(time);
    }

    public String getBankCatalog() {
        return this.bankCatalog;
    }

    public void setBankCatalog(String bankCatalog) {
        this.bankCatalog = bankCatalog;
    }

    public String getBankType() {
        return this.bankType;
    }

    public void setBankType(String bankType) {
        this.bankType = bankType;
    }

    public String getPbcCode() {
        return this.pbcCode;
    }

    public void setPbcCode(String pbcCode) {
        this.pbcCode = pbcCode;
    }

    public String getCcpc() {
        return this.ccpc;
    }

    public void setCcpc(String ccpc) {
        this.ccpc = ccpc;
    }

    public String getDrecCode() {
        return this.drecCode;
    }

    public void setDrecCode(String drecCode) {
        this.drecCode = drecCode;
    }

    public String getAgentSettBank() {
        return this.agentSettBank;
    }

    public void setAgentSettBank(String agentSettBank) {
        this.agentSettBank = agentSettBank;
    }

    public String getSuprList() {
        return this.suprList;
    }

    public void setSuprList(String suprList) {
        this.suprList = suprList;
    }

    public String getSbstitnbk() {
        return this.sbstitnbk;
    }

    public void setSbstitnbk(String sbstitnbk) {
        this.sbstitnbk = sbstitnbk;
    }

    public String getDebtorCity() {
        return this.debtorCity;
    }

    public void setDebtorCity(String debtorCity) {
        this.debtorCity = debtorCity;
    }

    public String getSysCode() {
        return this.sysCode;
    }

    public void setSysCode(String sysCode) {
        this.sysCode = sysCode;
    }

    public String getTel() {
        return this.tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public String getEffectDate() {
        return this.effectDate;
    }

    public void setEffectDate(String effectDate) {
        this.effectDate = effectDate;
    }

    public String getExpDate() {
        return this.expDate;
    }

    public void setExpDate(String expDate) {
        this.expDate = expDate;
    }
}

