/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.resources;

import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.frame.config.ResourceConfig;
import cn.com.infosec.netsign.frame.config.ResourcesConfig;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.resources.ResourceList;
import cn.com.infosec.netsign.resources.ResourcePool;
import cn.com.infosec.netsign.resources.ResourceReloader;
import java.util.Iterator;
import java.util.Map;

public class ResourceManager {
    private static ResourcePool allresources;
    private static boolean loaded;

    static {
        loaded = false;
    }

    public static void load(ResourcesConfig rsc) {
        if (!loaded) {
            System.out.println("Loading resources...");
            allresources = new ResourcePool();
            if (rsc.size() > 0) {
                int i = 0;
                int size = rsc.size();
                while (i < size) {
                    ResourceConfig rc = rsc.get(i);
                    ResourceList rl = null;
                    try {
                        System.out.println("Loading resource " + rc.getName() + " using " + rc.getClassName());
                        Class<?> c = Class.forName(rc.getClassName());
                        rl = (ResourceList)c.newInstance();
                        rl.setName(rc.getName());
                        rl.load(rc.getPs());
                    }
                    catch (Exception e) {
                        ConsoleLogger.logException(e);
                    }
                    if (rl != null) {
                        allresources.put(rc.getName(), rl);
                    }
                    ++i;
                }
                if (ExtendedConfig.isAutoReloadResources()) {
                    Thread t = new Thread(new ResourceReloader());
                    t.start();
                }
            }
            loaded = true;
        }
    }

    public static void reloadAllResourceList() {
        ConsoleLogger.logStringForce("Reloading resources...");
        if (allresources == null || allresources.size() == 0) {
            return;
        }
        if (allresources.entrySet().isEmpty()) {
            return;
        }
        Iterator is = allresources.entrySet().iterator();
        while (is.hasNext()) {
            Map.Entry entry = is.next();
            ResourceList rl = (ResourceList)entry.getValue();
            ConsoleLogger.logStringForce("Reloading resource " + rl.getName());
            try {
                rl.log("Reloading resource...");
                ConsoleLogger.logString("Reloading resource " + rl.getName());
                rl.reload();
                ConsoleLogger.logString("Resource " + rl.getName() + " reloaded");
                rl.log("Resources reloaded.");
            }
            catch (Exception e) {
                ConsoleLogger.logException(e);
            }
        }
        ConsoleLogger.logStringForce("Reloading resources finished");
    }

    public static ResourcePool getAllResourceList() {
        return allresources;
    }
}

