/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.pbc;

import cn.com.infosec.netsign.frame.util.XMLUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.pbc.PartnerRowInfo;
import cn.com.infosec.xmlparser.BinaryXMLParser;
import cn.com.infosec.xmlparser.BinaryXMLParserFactory;
import cn.com.infosec.xmlparser.ParserUtil;
import java.io.EOFException;
import java.io.FileInputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PartnerRowInfoFile {
    private ArrayList parttenerRows = new ArrayList();
    private int bankRowRecordCount;

    private PartnerRowInfoFile() {
    }

    public int size() {
        if (this.parttenerRows == null) {
            return 0;
        }
        return this.parttenerRows.size();
    }

    public PartnerRowInfo get(int i) {
        return (PartnerRowInfo)this.parttenerRows.get(i);
    }

    public static PartnerRowInfoFile parse(String file, Logger logger) throws Exception {
        FileInputStream in = null;
        PartnerRowInfoFile pbif = null;
        try {
            in = new FileInputStream(file);
            byte[] fileContent = new byte[in.available()];
            in.read(fileContent);
            BinaryXMLParser parser = BinaryXMLParserFactory.getInstance((String)"Infosec");
            parser.setXML(fileContent);
            int totalBankCode = 0;
            try {
                byte[] bs = ParserUtil.getInnerText((BinaryXMLParser)parser, (byte[])"BANKCODE_COUNT".getBytes());
                totalBankCode = Integer.parseInt(new String(bs).trim());
                logger.info((Object)("Get BANKCODE_COUNT:" + totalBankCode));
            }
            catch (Exception e) {
                ConsoleLogger.logException(e);
                logger.info((Object)("Bad format CCMSZDT0401 file: Parse BANKCODE_COUNT failed " + e.toString()));
                logger.info((Object)"Parse CCMSZDT0401 file failed");
                pbif = null;
            }
            int totaltmp = 0;
            try {
                pbif = new PartnerRowInfoFile();
                while (true) {
                    byte[] bs2;
                    byte[] rowbs = ParserUtil.getInnerText((BinaryXMLParser)parser, (byte[])"ROW".getBytes());
                    logger.info((Object)(String.valueOf(++totaltmp) + " ROWs detected ..."));
                    BinaryXMLParser tmpParser = ParserUtil.initDefaultParser((byte[])rowbs);
                    PartnerRowInfo pbi = new PartnerRowInfo();
                    try {
                        bs2 = ParserUtil.getInnerText((BinaryXMLParser)tmpParser, (byte[])"BANKCODE".getBytes());
                        pbi.setBankCode(new String(bs2));
                    }
                    catch (EOFException bs2) {
                        // empty catch block
                    }
                    tmpParser.setLocation(0);
                    try {
                        bs2 = ParserUtil.getInnerText((BinaryXMLParser)tmpParser, (byte[])"BANKNAME".getBytes());
                        pbi.setBankName(new String(bs2, "UTF-8"));
                    }
                    catch (EOFException eOFException) {
                        // empty catch block
                    }
                    if (pbi.getBankCode() != null && pbi.getBankName() != null) {
                        pbif.parttenerRows.add(pbi);
                        logger.info((Object)("Bank " + pbi.getBankName() + "(" + pbi.getBankCode() + ") detected"));
                        continue;
                    }
                    logger.info((Object)"No useful infomation in the ROW");
                }
            }
            catch (EOFException eOFException) {
                if (totaltmp == 0) {
                    logger.info((Object)"Bad format CCMSZDT0401 file: No ROW element detected");
                    logger.info((Object)"Parse CCMSZDT0401 file failed");
                    pbif = null;
                }
                if (totaltmp != totalBankCode) {
                    logger.info((Object)("WARNING: Count of ROW element(" + totaltmp + ") is not match BANKCODE_COUNT(" + totalBankCode + ")"));
                }
            }
        }
        finally {
            try {
                if (in == null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        logger.info((Object)"PartnerRowInfoFile Parse CCMSZDT0401 file finished");
        return pbif;
    }

    public static PartnerRowInfoFile parsebak(String file, Logger logger) throws Exception {
        PartnerRowInfoFile pbif;
        block15: {
            FileInputStream in = null;
            pbif = null;
            try {
                in = new FileInputStream(file);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(in);
                Element root = dom.getDocumentElement();
                NodeList nl = root.getElementsByTagName("BANKCODE_COUNT");
                if (nl != null && nl.getLength() >= 0) {
                    pbif = new PartnerRowInfoFile();
                    pbif.bankRowRecordCount = XMLUtil.getIntValue((Element)nl.item(0), 0);
                    logger.info((Object)("PartnerRowInfoFile Parse CCMSZDT0401 BANKCODE_COUNT: " + pbif.bankRowRecordCount));
                    nl = root.getElementsByTagName("ROW");
                    if (nl != null && nl.getLength() >= 0) {
                        if (nl.getLength() != pbif.bankRowRecordCount) {
                            logger.info((Object)("PartnerRowInfoFile Parse CCMSZDT0401 Count of ROW element is " + nl.getLength() + " but BANKCODE_COUNT is " + pbif.bankRowRecordCount));
                            logger.info((Object)"PartnerRowInfoFile Parse CCMSZDT0401 file failed");
                            pbif = null;
                            break block15;
                        }
                        int i = 0;
                        int size = nl.getLength();
                        while (i < size) {
                            Element e = (Element)nl.item(i);
                            try {
                                PartnerRowInfo pbi = PartnerRowInfo.parse(e);
                                if (pbi != null) {
                                    pbif.parttenerRows.add(pbi);
                                }
                            }
                            catch (Exception ex) {
                                ConsoleLogger.logException(ex);
                            }
                            ++i;
                        }
                        break block15;
                    }
                    logger.info((Object)"PartnerRowInfoFile Bad format CCMSZDT0401 file: No ROW element");
                    logger.info((Object)"PartnerRowInfoFile Parse CCMSZDT0401 file failed");
                    pbif = null;
                    break block15;
                }
                logger.info((Object)"PartnerRowInfoFile Bad format CCMSZDT0401 file: No BANKCODE_COUNT element");
                logger.info((Object)"PartnerRowInfoFile Parse CCMSZDT0401 file failed");
                pbif = null;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        logger.info((Object)"PartnerRowInfoFile Parse CCMSZDT0401 file finished");
        return pbif;
    }

    public static void main(String[] args) throws Exception {
    }
}

