/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.pbc;

import cn.com.infosec.netsign.frame.util.XMLUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.pbc.PartnerBankInfo;
import java.io.FileInputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PartnerBankInfoFile {
    private ArrayList parttenerBanks = new ArrayList();
    private int bankInfoRecordCount;

    private PartnerBankInfoFile() {
    }

    public int size() {
        if (this.parttenerBanks == null) {
            return 0;
        }
        return this.parttenerBanks.size();
    }

    public PartnerBankInfo get(int i) {
        return (PartnerBankInfo)this.parttenerBanks.get(i);
    }

    public static PartnerBankInfoFile parse(String file, Logger logger) throws Exception {
        PartnerBankInfoFile pbif;
        block15: {
            FileInputStream in = null;
            pbif = null;
            try {
                in = new FileInputStream(file);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(in);
                Element root = dom.getDocumentElement();
                Element element = (Element)root.getElementsByTagName("IBPS_BANK_DATA").item(0);
                NodeList nl = element.getElementsByTagName("IBPS_BANK_COUNT");
                if (nl != null && nl.getLength() >= 0) {
                    pbif = new PartnerBankInfoFile();
                    pbif.bankInfoRecordCount = XMLUtil.getIntValue((Element)nl.item(0), 0);
                    logger.info((Object)("PartnerBankInfoFile Parse IBPSODT0402 IBPS_BANK_COUNT: " + pbif.bankInfoRecordCount));
                    nl = element.getElementsByTagName("BANK");
                    if (nl != null && nl.getLength() >= 0) {
                        if (nl.getLength() != pbif.bankInfoRecordCount) {
                            logger.info((Object)("PartnerBankInfoFile Parse IBPSODT0402 Count of BANK element is " + nl.getLength() + " but IBPS_BANK_COUNT is " + pbif.bankInfoRecordCount));
                            logger.info((Object)"PartnerBankInfoFile Parse IBPSODT0402  file failed");
                            pbif = null;
                            break block15;
                        }
                        int i = 0;
                        int size = nl.getLength();
                        while (i < size) {
                            Element e = (Element)nl.item(i);
                            try {
                                PartnerBankInfo pbi = PartnerBankInfo.parse(e);
                                if (pbi != null) {
                                    pbif.parttenerBanks.add(pbi);
                                }
                            }
                            catch (Exception ex) {
                                ConsoleLogger.logException(ex);
                            }
                            ++i;
                        }
                        break block15;
                    }
                    logger.info((Object)"PartnerBankInfoFile Bad format IBPSODT0402 file: No BANK element");
                    logger.info((Object)"PartnerBankInfoFile Parse IBPSODT0402 file failed");
                    pbif = null;
                    break block15;
                }
                logger.info((Object)"PartnerBankInfoFile Bad format IBPSODT0402 file: No IBPS_BANK_COUNT element");
                logger.info((Object)"PartnerBankInfoFile Parse IBPSODT0402 file failed");
                pbif = null;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        logger.info((Object)"PartnerBankInfoFile Parse Parse IBPSODT0402 file finished");
        return pbif;
    }

    public static void main(String[] args) throws Exception {
    }
}

