/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class PackageUtil {
    private static String[] CLASS_PATH_PROP = new String[]{"java.class.path", "java.ext.dirs", "sun.boot.class.path"};
    private static List CLASS_PATH_ARRAY = PackageUtil.getClassPath();

    private static List getClassPath() {
        ArrayList<File> ret = new ArrayList<File>();
        String delim = ":";
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            delim = ";";
        }
        int i = 0;
        int propSize = CLASS_PATH_PROP.length;
        while (i < propSize) {
            String[] pathes = System.getProperty(CLASS_PATH_PROP[i]).split(delim);
            int j = 0;
            int pathSize = pathes.length;
            while (j < pathSize) {
                ret.add(new File(pathes[j]));
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static List getClassInPackage(String pkgName) {
        ArrayList<String> ret = new ArrayList<String>();
        String rPath = String.valueOf(pkgName.replace('.', '/')) + "/";
        try {
            int i = 0;
            int pathSize = CLASS_PATH_ARRAY.size();
            while (i < pathSize) {
                File classPath = (File)CLASS_PATH_ARRAY.get(i);
                if (classPath.exists()) {
                    if (classPath.isDirectory()) {
                        File dir = new File(classPath, rPath);
                        if (dir.exists()) {
                            File[] files = dir.listFiles();
                            int j = 0;
                            int dirLength = files.length;
                            while (j < dirLength) {
                                if (files[j].isFile()) {
                                    String clsName = files[j].getName();
                                    clsName = String.valueOf(pkgName) + "." + clsName.substring(0, clsName.length() - 6);
                                    ret.add(clsName);
                                }
                                ++j;
                            }
                        }
                    } else {
                        FileInputStream fis = new FileInputStream(classPath);
                        JarInputStream jis = new JarInputStream((InputStream)fis, false);
                        JarEntry e = null;
                        while ((e = jis.getNextJarEntry()) != null) {
                            String eName = e.getName();
                            if (eName.startsWith(rPath) && !eName.endsWith("/")) {
                                ret.add(eName.replace('/', '.').substring(0, eName.length() - 6));
                            }
                            jis.closeEntry();
                        }
                        jis.close();
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public static void main(String[] args) throws IOException {
    }
}

