/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.util;

import cn.com.infosec.asn1.ASN1Set;
import cn.com.infosec.asn1.DERConstructedSequence;
import cn.com.infosec.asn1.DERInputStream;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.pkcs.ContentInfo;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.pkcs.SignedData;
import cn.com.infosec.asn1.x509.X509CertificateStructure;
import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.jce.provider.JCESM2PrivateKey;
import cn.com.infosec.jce.provider.JCESM2PublicKey;
import cn.com.infosec.jce.provider.X509CertificateObject;
import cn.com.infosec.netsign.crypto.exception.CryptoException;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import cn.com.infosec.netsign.crypto.util.HardCryptoImpl;
import cn.com.infosec.netsign.crypto.util.PKCS10CertificationRequest;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.frame.util.CertificateUtil;
import cn.com.infosec.netsign.frame.util.JKSFile;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.webui.mode.WebUICFG;
import cn.com.infosec.oscca.sm2.SM2PrivateKey;
import cn.com.infosec.oscca.sm2.SM2PublicKey;
import cn.com.infosec.swxa.SWXAUtil;
import cn.com.infosec.util.encoders.Base64;
import cn.com.infosec.x509.X509V1CertificateGenerator;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;

public class PKCS10Utils {
    public static String genP10(String subject, String keyLable, int keySize, JKSFile jks, HardCryptoImpl hard) {
        if (ExtendedConfig.getAlgMode().equals("soft")) {
            KeyPair kp;
            block6: {
                try {
                    kp = PKCS10Utils.generateKeyPair(keySize);
                    if (kp != null) break block6;
                    ConsoleLogger.logStringForce("Generate keypair failed");
                    return null;
                }
                catch (Exception e) {
                    ConsoleLogger.logException(e);
                    return null;
                }
            }
            X509Certificate cert = PKCS10Utils.generateCert(subject, kp.getPublic(), kp.getPrivate(), "SHA1withRSA");
            Certificate[] certs = new X509Certificate[]{cert};
            jks.prepareP10(kp.getPrivate(), keyLable, certs);
            PKCS10CertificationRequest p10reqest = new PKCS10CertificationRequest(new X509Name(subject), kp.getPublic(), null, kp.getPrivate(), "INFOSEC");
            return CryptoUtil.createbase64csr((PKCS10CertificationRequest)p10reqest);
        }
        try {
            return hard.generatePKCS10CSR(subject, keySize, keyLable.getBytes());
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            return null;
        }
    }

    public static String genP10(String subject, String keyLable, int keySize, JKSFile jks, HardCryptoImpl hard, String pro) {
        if ("INFOSEC".equals(pro)) {
            return PKCS10Utils.genP10(subject, keyLable, keySize, jks, hard);
        }
        if ("SwxaJCE".equals(pro)) {
            return PKCS10Utils.genP10inHsm(subject, keyLable, jks, pro);
        }
        return null;
    }

    private static String genP10inHsm(String subject, String keyLable, JKSFile jks, String pro) {
        if (ExtendedConfig.getAlgMode().equals("soft")) {
            try {
                KeyPair kp = SWXAUtil.getHsmKeyPair((String)keyLable, (String)pro);
                X509Certificate cert = PKCS10Utils.generateCert(subject, kp.getPublic(), kp.getPrivate(), "SHA1withRSA");
                Certificate[] certs = new X509Certificate[]{cert};
                jks.prepareP10(kp.getPrivate(), keyLable, certs);
                PKCS10CertificationRequest p10reqest = new PKCS10CertificationRequest(new X509Name(subject), kp.getPublic(), null, kp.getPrivate(), pro);
                return CryptoUtil.createbase64csr((PKCS10CertificationRequest)p10reqest);
            }
            catch (Exception e) {
                ConsoleLogger.logException(e);
                return null;
            }
        }
        return null;
    }

    public static String[] importP10(X509Certificate cert, String keyLable, JKSFile jks, String pro) {
        if ("INFOSEC".equals(pro)) {
            return PKCS10Utils.importP10(cert, keyLable, jks);
        }
        if ("SwxaJCE".equals(pro)) {
            return PKCS10Utils.importP10forHsm(cert, keyLable, pro);
        }
        return null;
    }

    public static String[] importP10(String p7b, String keyLable, JKSFile jks, String pro) {
        if ("INFOSEC".equals(pro)) {
            return PKCS10Utils.importP10(p7b, keyLable, jks);
        }
        if ("SwxaJCE".equals(pro)) {
            return PKCS10Utils.importP10forHsm(p7b, keyLable, pro);
        }
        return null;
    }

    private static String[] importP10forHsm(X509Certificate cert, String keyLable, String pro) {
        if (!PKCS10Utils.isSameModulus(cert, keyLable, pro)) {
            ConsoleLogger.logStringForce("Import p10 cert failed public key doesn't match ");
            return null;
        }
        PKCS10Utils.writeKeyToFile(cert, String.valueOf(WebUICFG.getServerHome()) + "/cert/tokencert/" + keyLable + ".cer");
        String[] tmp = new String[]{keyLable};
        return tmp;
    }

    private static String[] importP10forHsm(String p7b, String keyLable, String pro) {
        Certificate[] certs = null;
        try {
            certs = PKCS10Utils.getCertChain(Base64.decode((String)p7b));
        }
        catch (CertificateParsingException e) {
            e.printStackTrace();
        }
        catch (CryptoException e) {
            e.printStackTrace();
        }
        if (certs == null) {
            System.out.println("certs is null.");
        }
        RSAPublicKey existSKey = (RSAPublicKey)SWXAUtil.getHsmKeyPair((String)keyLable, (String)pro).getPublic();
        X509Certificate cert = null;
        int i = 0;
        while (i < certs.length) {
            RSAPublicKey uploadKey = (RSAPublicKey)certs[i].getPublicKey();
            if (existSKey.getModulus().equals(uploadKey.getModulus())) {
                PKCS10Utils.writeKeyToFile(certs[i], String.valueOf(WebUICFG.getServerHome()) + "/cert/tokencert/" + keyLable + ".cer");
                cert = (X509Certificate)certs[i];
                break;
            }
            ++i;
        }
        if (cert == null) {
            ConsoleLogger.logStringForce("Import p10 p7b failed public key doesn't match ");
            return null;
        }
        String[] results = new String[]{PKCS10Utils.genAlias(cert.getSubjectDN().getName(), cert.getPublicKey()), "Cert"};
        return results;
    }

    private static void writeKeyToFile(Certificate cert, String file) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(cert.getEncoded());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isSameModulus(X509Certificate cert, String keyLable, String pro) {
        RSAPublicKey uploadKey = (RSAPublicKey)cert.getPublicKey();
        RSAPublicKey existSKey = (RSAPublicKey)SWXAUtil.getHsmKeyPair((String)keyLable, (String)pro).getPublic();
        return uploadKey.getModulus().equals(existSKey.getModulus());
    }

    public static String genP10(String subject, PublicKey pubk, PrivateKey prik) {
        try {
            PKCS10CertificationRequest p10request;
            if (pubk instanceof JCESM2PublicKey) {
                JCESM2PublicKey tmpPubk = (JCESM2PublicKey)pubk;
                byte[] x = tmpPubk.getX();
                byte[] y = tmpPubk.getY();
                pubk = new SM2PublicKey();
                ((SM2PublicKey)pubk).setX(x);
                ((SM2PublicKey)pubk).setY(y);
                JCESM2PrivateKey tmpPrik = (JCESM2PrivateKey)prik;
                byte[] d = tmpPrik.getD();
                prik = new SM2PrivateKey();
                ((SM2PrivateKey)prik).setD(d);
            }
            if (pubk instanceof SM2PublicKey) {
                p10request = new PKCS10CertificationRequest(ExtendedConfig.getDefaultSM2P10Alg(), new X509Name(subject), (SM2PublicKey)pubk, (SM2PrivateKey)prik, ExtendedConfig.getSm3P10Puid());
                return CryptoUtil.createbase64csr((PKCS10CertificationRequest)p10request);
            }
            if (pubk instanceof RSAPublicKey) {
                p10request = new PKCS10CertificationRequest(new X509Name(subject), pubk, null, prik, "INFOSEC");
                return CryptoUtil.createbase64csr((PKCS10CertificationRequest)p10request);
            }
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
        }
        return null;
    }

    private static X509Certificate generateCert(String subject, PublicKey publicKey, PrivateKey privateKey, String signatureType) throws Exception {
        X509Name dn = new X509Name(subject);
        int iValidity = 365;
        X509V1CertificateGenerator certGen = new X509V1CertificateGenerator();
        certGen.setIssuerDN(dn);
        certGen.setNotBefore(new Date(System.currentTimeMillis()));
        certGen.setNotAfter(new Date(System.currentTimeMillis() + (long)iValidity * 24L * 60L * 60L * 1000L));
        certGen.setSubjectDN(dn);
        certGen.setPublicKey(publicKey);
        certGen.setSignatureAlgorithm(signatureType.toString());
        certGen.setSerialNumber(BigInteger.ONE);
        X509Certificate cert = certGen.generateX509Certificate(privateKey);
        return cert;
    }

    private static KeyPair generateKeyPair(int keySize) {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "INFOSEC");
            SecureRandom ran = SecureRandom.getInstance("SHA1PRNG");
            kpg.initialize(keySize, ran);
            return kpg.generateKeyPair();
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            return null;
        }
    }

    public static String[] importP10(X509Certificate cert, String keyLable, JKSFile jks) {
        try {
            String[] results = new String[2];
            if (ExtendedConfig.getAlgMode().equals("hard")) {
                results = jks.importCert(cert);
                if (results[0] == null) {
                    ConsoleLogger.logStringForce("Import p10 cert failed");
                }
            } else {
                Certificate[] certs = new X509Certificate[]{cert};
                results = jks.importP10(keyLable, certs);
                if (results == null) {
                    ConsoleLogger.logStringForce("Import p10 cert failed");
                }
            }
            return results;
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            return null;
        }
    }

    public static String[] importP10(String p7b, String keyLable, JKSFile jks) {
        try {
            Certificate[] certs = PKCS10Utils.getCertChain(Base64.decode((String)p7b));
            if (certs == null) {
                System.out.println("certs is null.");
            }
            String[] results = new String[2];
            if (ExtendedConfig.getAlgMode().equals("hard")) {
                results = jks.importCert(certs);
                if (results[0] == null) {
                    ConsoleLogger.logStringForce("Import p10 cert failed");
                }
            } else {
                results = jks.importP10(keyLable, certs);
                if (results == null) {
                    ConsoleLogger.logStringForce("Import p10 cert failed");
                }
            }
            return results;
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            return null;
        }
    }

    public static Certificate[] getCertChain(byte[] in) throws CryptoException, CertificateParsingException {
        DERObject pkcs;
        DERInputStream din = new DERInputStream((InputStream)new ByteArrayInputStream(in));
        try {
            pkcs = din.readObject();
        }
        catch (IOException e) {
            throw new CryptoException("can't decode PKCS7SignedData object");
        }
        if (!(pkcs instanceof DERConstructedSequence)) {
            throw new CryptoException("Not a valid PKCS#7 object - not a sequence");
        }
        ContentInfo content = ContentInfo.getInstance((Object)pkcs);
        if (!content.getContentType().equals((Object)PKCSObjectIdentifiers.signedData)) {
            throw new CryptoException("Not a valid PKCS#7 signed-data object - wrong header " + content.getContentType().getId());
        }
        SignedData data = SignedData.getInstance((Object)content.getContent());
        ArrayList<X509CertificateObject> certs = new ArrayList<X509CertificateObject>();
        if (data.getCertificates() != null) {
            Enumeration ec = ASN1Set.getInstance((Object)data.getCertificates()).getObjects();
            while (ec.hasMoreElements()) {
                certs.add(new X509CertificateObject(X509CertificateStructure.getInstance(ec.nextElement())));
            }
        }
        return certs.toArray(new X509Certificate[0]);
    }

    public static Certificate getCertificateByPubk(Certificate[] certs, PublicKey pubk) throws CertificateEncodingException {
        byte[] destPubk = pubk.getEncoded();
        int i = 0;
        int length = certs.length;
        while (i < length) {
            byte[] srcPubk = CertificateUtil.getPublicKey(certs[i].getEncoded());
            if (Arrays.equals(destPubk, srcPubk)) {
                return certs[i];
            }
            ++i;
        }
        return null;
    }

    public static String genAlias(String subject, PublicKey pubk) {
        String alias = "";
        try {
            alias = subject;
            alias = alias.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
            alias = String.valueOf(alias) + ":" + CertificateUtil.getSubjectKid(pubk);
        }
        catch (Exception e) {
            return null;
        }
        return alias;
    }

    public static void main(String[] args) throws Exception {
        String p7 = "MIIDVQYJKoZIhvcNAQcCoIIDRjCCA0ICAQExADALBgkqhkiG9w0BBwGgggMqMIIDJjCCAg6gAwIBAgIFey7gaXowDQYJKoZIhvcNAQEFBQAwNTELMAkGA1UEBhMCY24xFDASBgNVBAoMC3N5bjIwMTQwMTE1MRAwDgYDVQQDDAdSU0EyMDQ4MB4XDTE0MDkxMDA3Mzg0MVoXDTE1MDkxMDA3Mzg0MVowRTELMAkGA1UEBhMCY24xITAfBgNVBAoMGElORk9TRUMgVGVjaG5vbG9naWVzIFJTQTETMBEGA1UEAwwKcnNhXzNfMTAyNDCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAgTwDsX1Z00xaVjhZWiGADr9n2s/jbRhBK/Dn07Qi94LNjwAewXNQcRBEt0r2cWS/17IeFc6/rFpcg7MtapPrQwr9tuMFE3n1qACn1ohZVyw9KS8VJzvCezye6bkyW4jbYGyOScuUxB4onUTyC8ipo5EijCFW9ZiExvDkOl0yJqkCAwEAAaOBsDCBrTAfBgNVHSMEGDAWgBS9N30/zRzu1/DX2S81GjQ3gu7l4zAJBgNVHRMEAjAAMFMGA1UdHwRMMEowSKBGoESkQjBAMQ0wCwYDVQQDDARjcmwxMQwwCgYDVQQLDANjcmwxFDASBgNVBAoMC3N5bjIwMTQwMTE1MQswCQYDVQQGEwJjbjALBgNVHQ8EBAMCB4AwHQYDVR0OBBYEFNTQWG8zZsnekxLImA6baso0PvgXMA0GCSqGSIb3DQEBBQUAA4IBAQA4bnlEK4Jiu8sCW3L3dkxJtfEX0hx/2XBWjgd1oOxPwuiHg+/4unXIfynYwqCMSYF43wMGWoQ0JziFtHLM5bkAaT50pfa1Cegha7kIKca1RAQ/FBmkzD3SG37aBpLjYlKZndjPIHIJm/Zpy+rzhfYJ7Ao0LAqym+MkuJUdKeAj3ECJenRoYaSIoQa937i6ccZ4yRNebDmzFhI9WXVq4A/3hSAnK31hcr7c58rXl4Ak0cSnumKPznT1Gcuq9eVZUFyd9PMnys5nNdapZf6MtjYenAR3cTyAO5Z/j82XwuLUOC8duG6vVwn9JCsXCEXyLx+Z9/KzUtss/Y5bYnJPGXyWMQA=";
        X509Certificate cert = CertificateUtil.generateCertificate(p7.getBytes());
        System.out.println(cert == null);
        Certificate[] certs = PKCS10Utils.getCertChain(Base64.decode((String)p7));
        byte[] pubk = CertificateUtil.getPublicKey(certs[0].getEncoded());
        ConsoleLogger.logBinary("pubk", pubk);
    }
}

