/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.util;

import cn.com.infosec.jce.provider.JCESM2PrivateKey;
import cn.com.infosec.jce.provider.JCESM2PublicKey;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.frame.util.CertificateUtil;
import cn.com.infosec.netsign.frame.util.PrivateKeyUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.oscca.sm2.SM2;
import cn.com.infosec.util.encoders.Base64;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Enumeration;

public class JKSFile {
    private String file;
    private String storePwd;
    private KeyStore keyStore;
    private JKSFile jks;
    private String provider = "INFOSEC";

    private JKSFile() {
    }

    public JKSFile(String file, String storePwd, String provider) throws Exception {
        this.provider = provider;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.keyStore = KeyStore.getInstance("JKS");
            if (storePwd != null) {
                this.keyStore.load(in, storePwd.toCharArray());
            } else {
                this.keyStore.load(in, null);
            }
            this.file = file;
            this.storePwd = storePwd;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public JKSFile(String file, String storePwd) throws Exception {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.keyStore = KeyStore.getInstance("JKS");
            if (storePwd != null) {
                this.keyStore.load(in, storePwd.toCharArray());
            } else {
                this.keyStore.load(in, null);
            }
            this.file = file;
            this.storePwd = storePwd;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String[] listAliases() throws KeyStoreException {
        Enumeration<String> aliases = this.keyStore.aliases();
        if (aliases != null) {
            ArrayList<String> list = new ArrayList<String>();
            while (aliases.hasMoreElements()) {
                list.add(aliases.nextElement());
            }
            return list.toArray(new String[0]);
        }
        return null;
    }

    public boolean remove(String alias) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.file);
            this.keyStore.deleteEntry(alias);
            if (this.storePwd != null) {
                this.keyStore.store(out, this.storePwd.toCharArray());
            } else {
                this.keyStore.store(out, null);
            }
            return true;
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            return false;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] importPFX(String pfxFile, String pwd) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            KeyStore pfx = KeyStore.getInstance("PKCS12", this.provider);
            in = new FileInputStream(pfxFile);
            pfx.load(in, pwd.toCharArray());
            Enumeration<String> aliases = pfx.aliases();
            String keyAlias = null;
            String certAlias = null;
            while (true) {
                if (!aliases.hasMoreElements()) {
                    if (keyAlias != null) break;
                    ConsoleLogger.logStringForce("No key entry in the pfx file: " + pfxFile);
                    return null;
                }
                String alias = aliases.nextElement();
                if (pfx.isCertificateEntry(alias)) {
                    certAlias = alias;
                }
                if (!pfx.isKeyEntry(alias)) continue;
                keyAlias = alias;
            }
            Key k = pfx.getKey(keyAlias, "".toCharArray());
            X509Certificate cert = (X509Certificate)pfx.getCertificate(keyAlias);
            if (cert == null) {
                if (certAlias != null) {
                    cert = (X509Certificate)pfx.getCertificate(certAlias);
                }
                if (cert == null) {
                    ConsoleLogger.logStringForce("No certificate found in the pfx file: " + pfxFile);
                    return null;
                }
            }
            if (!this.testCertbySunJce(cert)) {
                return null;
            }
            Certificate[] certChain = pfx.getCertificateChain(keyAlias);
            if (certChain == null) {
                certChain = pfx.getCertificateChain(certAlias);
            }
            if (certChain == null) {
                ConsoleLogger.logStringForce("No certificate chain found in the pfx file: " + pfxFile);
                return null;
            }
            PublicKey pubk = cert.getPublicKey();
            String[] result = new String[5];
            result[0] = this.genAlias(cert);
            if (pubk instanceof RSAPublicKey) {
                this.compareKey((RSAPrivateKey)k, (RSAPublicKey)pubk, result[0]);
            } else if (pubk instanceof JCESM2PublicKey) {
                this.compareKey((JCESM2PrivateKey)k, (JCESM2PublicKey)pubk, result[0]);
            }
            if (result[0] == null) return null;
            if ("".equals(result[0])) {
                return null;
            }
            result[1] = this.genPassword(result[0]);
            if (pubk instanceof JCESM2PublicKey) {
                JCESM2PrivateKey prik = (JCESM2PrivateKey)k;
                result[1] = result[0];
                result[2] = PrivateKeyUtil.encryptPrivateKey(prik.getD(), result[0]);
            } else {
                if (!this.keyStore.containsAlias(result[0])) {
                    this.keyStore.setKeyEntry(result[0], k, result[1].toCharArray(), certChain);
                } else {
                    RSAPrivateKey priK = (RSAPrivateKey)k;
                    RSAPublicKey pubK = (RSAPublicKey)cert.getPublicKey();
                    try {
                        this.compareKey(priK, pubK, result[0]);
                        this.keyStore.deleteEntry(result[0]);
                        this.keyStore.setKeyEntry(result[0], k, result[1].toCharArray(), certChain);
                    }
                    catch (Exception e) {
                        ConsoleLogger.logException(e);
                    }
                }
                out = new FileOutputStream(this.file);
                if (this.storePwd != null) {
                    this.keyStore.store(out, this.storePwd.toCharArray());
                } else {
                    this.keyStore.store(out, null);
                }
            }
            result[3] = new String(Base64.encode((byte[])cert.getEncoded()));
            result[4] = pubk instanceof JCESM2PublicKey ? "SM2" : "RSA";
            String[] stringArray = result;
            return stringArray;
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            return null;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static X509Certificate getCert(Key k, Certificate[] certs) {
        if (certs == null) {
            return null;
        }
        if (k != null) {
            RSAKey priK = (RSAKey)((Object)k);
            BigInteger priM = priK.getModulus();
            int i = 0;
            int length = certs.length;
            while (i < length) {
                X509Certificate cert = (X509Certificate)certs[i];
                RSAKey pubK = (RSAKey)((Object)cert.getPublicKey());
                if (priM.equals(pubK.getModulus())) {
                    return cert;
                }
                ++i;
            }
        } else {
            if (certs.length == 1) {
                return (X509Certificate)certs[0];
            }
            int i = 0;
            int lengthi = certs.length;
            while (i < lengthi) {
                X509Certificate certi = (X509Certificate)certs[i];
                boolean find = true;
                int j = 0;
                int lengthj = certs.length;
                while (i < lengthj) {
                    X509Certificate certj = (X509Certificate)certs[j];
                    if (certi.getSubjectDN().equals(certj.getIssuerDN())) {
                        find = false;
                        break;
                    }
                    ++i;
                }
                if (find) {
                    return certi;
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String[] importP10(String keyLable, Certificate[] certs) throws Exception {
        FileOutputStream out = null;
        try {
            String pwd = this.genPassword(keyLable);
            Key k = this.keyStore.getKey(keyLable, pwd.toCharArray());
            if (k == null) {
                return null;
            }
            String[] results = new String[2];
            X509Certificate cert = JKSFile.getCert(k, certs);
            if (cert == null) {
                ConsoleLogger.logStringForce("Can not find certificate by the private key.");
                return null;
            }
            if (!this.testCertbySunJce(cert)) {
                return null;
            }
            results[0] = this.genAlias(cert);
            results[1] = this.genPassword(results[0]);
            this.keyStore.deleteEntry(keyLable);
            this.keyStore.setKeyEntry(results[0], k, results[1].toCharArray(), certs);
            out = new FileOutputStream(this.file);
            if (this.storePwd != null) {
                this.keyStore.store(out, this.storePwd.toCharArray());
            } else {
                this.keyStore.store(out, null);
            }
            String[] stringArray = results;
            return stringArray;
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            return null;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    String prepareP10(Key key, String keyLable, Certificate[] certs) throws Exception {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.file);
            String pwd = this.genPassword(keyLable);
            this.keyStore.setKeyEntry(keyLable, key, pwd.toCharArray(), certs);
            if (this.storePwd != null) {
                this.keyStore.store(out, this.storePwd.toCharArray());
            } else {
                this.keyStore.store(out, null);
            }
            String string = pwd;
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String[][] importJKS(JKSFile jks, String[][] aliasAndPwd) throws NoSuchMethodException {
        throw new NoSuchMethodException();
    }

    public String[] importCert(String certFile) {
        X509Certificate cert;
        block3: {
            try {
                cert = CertificateUtil.generateCertificate(certFile);
                if (cert != null) break block3;
                return null;
            }
            catch (Exception e) {
                ConsoleLogger.logException(e);
                return null;
            }
        }
        return this.importCert(cert);
    }

    public String[] importCert(Certificate[] certs) {
        X509Certificate cert = JKSFile.getCert(null, certs);
        return this.importCert(cert);
    }

    private void compareKey(RSAPrivateKey prik, RSAPublicKey pubk, String alias) throws SecurityException {
        if (!prik.getModulus().equals(pubk.getModulus())) {
            throw new SecurityException("The publickey of certificate is not for the privatekey,the alias of the certificate is :" + alias);
        }
    }

    private void compareKey(JCESM2PrivateKey prik, JCESM2PublicKey pubk, String alias) throws SecurityException {
        if (!SM2.checkKeyPair((byte[])prik.getD(), (byte[])pubk.getX(), (byte[])pubk.getY())) {
            throw new SecurityException("The publickey of certificate is not for the privatekey,the alias of the certificate is :" + alias);
        }
    }

    private boolean testCertbySunJce(Certificate cert) {
        if (cert.getPublicKey() instanceof JCESM2PublicKey) {
            return true;
        }
        try {
            byte[] bs = cert.getEncoded();
            ByteArrayInputStream in = new ByteArrayInputStream(bs);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate c = cf.generateCertificate(in);
            if (c == null) {
                ConsoleLogger.logStringForce("Parse certificate by sun jce failed");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] importCert(X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        if (!this.testCertbySunJce(cert)) {
            return null;
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            String alias = this.genAlias(cert);
            if (alias == null) return null;
            if ("".equals(alias)) {
                return null;
            }
            if (cert.getPublicKey() instanceof RSAPublicKey) {
                out = new FileOutputStream(this.file);
                String entryType = "cert";
                if (this.keyStore.containsAlias(alias)) {
                    if (this.keyStore.isCertificateEntry(alias)) {
                        this.keyStore.setCertificateEntry(alias, cert);
                    } else {
                        entryType = "key";
                        String keypasswd = this.genPassword(alias);
                        Key k = this.keyStore.getKey(alias, keypasswd.toCharArray());
                        RSAPrivateKey priK = (RSAPrivateKey)k;
                        RSAPublicKey pubK = (RSAPublicKey)cert.getPublicKey();
                        try {
                            this.compareKey(priK, pubK, alias);
                            this.keyStore.deleteEntry(alias);
                            this.keyStore.setKeyEntry(alias, k, keypasswd.toCharArray(), new Certificate[]{cert});
                        }
                        catch (Exception e) {
                            ConsoleLogger.logException(e);
                        }
                    }
                } else {
                    this.keyStore.setCertificateEntry(alias, cert);
                }
                if (this.storePwd != null) {
                    this.keyStore.store(out, this.storePwd.toCharArray());
                } else {
                    this.keyStore.store(out, null);
                }
                String[] stringArray = new String[4];
                stringArray[0] = alias;
                stringArray[1] = entryType;
                stringArray[3] = "RSA";
                String[] stringArray2 = stringArray;
                return stringArray2;
            }
            if (!(cert.getPublicKey() instanceof JCESM2PublicKey)) return null;
            String[] results = new String[]{alias, "cert", new String(Base64.encode((byte[])cert.getEncoded())), "SM2"};
            String[] stringArray = results;
            return stringArray;
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            return null;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String importPrivateKey(String keylable, Key key) {
        if (keylable == null || key == null) {
            return null;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.file);
            String pwd = this.genPassword(keylable);
            this.keyStore.setKeyEntry(keylable, key, pwd.toCharArray(), null);
            if (this.storePwd != null) {
                this.keyStore.store(out, this.storePwd.toCharArray());
            } else {
                this.keyStore.store(out, null);
            }
            String string = pwd;
            return string;
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            return null;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String genAlias(X509Certificate cert) {
        String alias = "";
        try {
            alias = cert.getSubjectDN().getName();
            alias = alias.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
            alias = String.valueOf(alias) + ":" + CertificateUtil.getSubjectKid(cert);
        }
        catch (Exception e) {
            return null;
        }
        return alias;
    }

    private String genPassword(String alias) {
        byte[] digest = null;
        try {
            MessageDigest dig = MessageDigest.getInstance("SHA1");
            digest = dig.digest(alias.getBytes(ExtendedConfig.getEncoding()));
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
        }
        return new String(Base64.encode((byte[])digest));
    }

    public RSAPrivateKey getPrivateKey(String alias, String pwd) {
        if (alias == null) {
            return null;
        }
        try {
            if (this.keyStore.containsAlias(alias) && this.keyStore.isKeyEntry(alias)) {
                if (pwd == null) {
                    pwd = this.genPassword(alias);
                }
                return (RSAPrivateKey)this.keyStore.getKey(alias, pwd.toCharArray());
            }
            return null;
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            return null;
        }
    }

    public X509Certificate getCertificate(String alias) {
        if (alias == null) {
            return null;
        }
        try {
            if (this.keyStore.containsAlias(alias)) {
                return (X509Certificate)this.keyStore.getCertificate(alias);
            }
            return null;
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            return null;
        }
    }

    public Certificate[] getCertChain(String alias) {
        if (alias == null) {
            return null;
        }
        try {
            if (this.keyStore.containsAlias(alias)) {
                return this.keyStore.getCertificateChain(alias);
            }
            return null;
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            return null;
        }
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public String getStorePwd() {
        return this.storePwd;
    }

    public void setStorePwd(String storePwd) {
        this.storePwd = storePwd;
    }

    public static void main(String[] args) {
        JKSFile f = new JKSFile();
        System.out.println(f.genPassword("gtja_chinaclear"));
    }
}

