/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.util;

import cn.com.infosec.netsign.frame.config.Config;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ConfigUtil {
    public static Element getRootElement(String file) throws IOException, ParserConfigurationException, SAXException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(in);
            Element element = doc.getDocumentElement();
            return element;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String input2XMLString(String str) {
        return str.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String xmlString2Input(String str) {
        return str.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
    }

    public static boolean save(String file, Config config) {
        FileOutputStream out = null;
        FileOutputStream tmp = null;
        try {
            out = new FileOutputStream(file);
            out.write(config.toXML().getBytes("GBK"));
            out.flush();
            String fileName = file.substring(file.lastIndexOf("/") + 1, file.lastIndexOf("."));
            SimpleDateFormat defaultFormatter = new SimpleDateFormat("yyyyMMddHHmmss");
            File bakfile = new File("/tmp/configbak/" + fileName + "_" + defaultFormatter.format(new Date()) + ".xml");
            if (!bakfile.getParentFile().exists()) {
                bakfile.getParentFile().mkdirs();
            }
            tmp = new FileOutputStream(bakfile);
            tmp.write(config.toXML().getBytes("GBK"));
            tmp.flush();
            return true;
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            return false;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (tmp != null) {
                    tmp.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static Element getElement(Element e, String name) {
        NodeList nl = e.getElementsByTagName(name);
        if (nl != null && nl.getLength() > 0) {
            return (Element)nl.item(0);
        }
        return null;
    }

    public static String getAttributeValue(Element e, String attrName, String str) {
        return e.getAttribute(attrName);
    }

    public static String getNodeText(Element e, String nodeName, String str) {
        Text tn;
        Node n;
        String value = str;
        NodeList nl = e.getElementsByTagName(nodeName);
        if (nl != null && nl.getLength() > 0 && (nl = (n = nl.item(0)).getChildNodes()) != null && (tn = (Text)nl.item(0)) != null) {
            value = tn.getNodeValue();
        }
        return value;
    }

    public static int getNodeInt(Element e, String nodeName, int num) {
        int value = num;
        String str = ConfigUtil.getNodeText(e, nodeName, null);
        try {
            value = Integer.parseInt(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static long getNodeLong(Element e, String nodeName, long num) {
        long value = num;
        String str = ConfigUtil.getNodeText(e, nodeName, null);
        try {
            value = Long.parseLong(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static boolean getNodeBoolean(Element e, String nodeName, boolean b) {
        String str = ConfigUtil.getNodeText(e, nodeName, null);
        if (str != null) {
            if (str.equalsIgnoreCase("true")) {
                return true;
            }
            if (str.equalsIgnoreCase("false")) {
                return false;
            }
        }
        return b;
    }

    public static float getNodeFloat(Element e, String nodeName, float f) {
        String str = ConfigUtil.getNodeText(e, nodeName, null);
        if (str != null) {
            try {
                return Float.parseFloat(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return f;
    }

    public static int getNodeInt(Element e, String nodeName, int num, int radix) {
        int value = num;
        String str = ConfigUtil.getNodeText(e, nodeName, null);
        try {
            value = Integer.parseInt(str, radix);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }
}

