/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.config;

import cn.com.infosec.netsign.frame.config.Config;
import cn.com.infosec.netsign.frame.config.TrustField;
import cn.com.infosec.netsign.frame.util.ConfigUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TrustConfig
implements Config,
Serializable {
    private String path;
    private HashMap trustFields = new HashMap();

    public TrustField[] getTrustConfigs() {
        return this.trustFields.values().toArray(new TrustField[0]);
    }

    public void addTrustField(TrustField tc) {
        this.trustFields.put(tc.getName(), tc);
    }

    public TrustField removeTrustField(String name) {
        return (TrustField)this.trustFields.remove(name);
    }

    public TrustField getTrustField(String trustName) {
        return (TrustField)this.trustFields.get(trustName);
    }

    public static TrustConfig parse(String file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(in);
            Element root = doc.getDocumentElement();
            TrustConfig t = new TrustConfig();
            t.setPath(ConfigUtil.getNodeText(root, "path", "cert/rootcert/"));
            NodeList nl = root.getElementsByTagName("trustfield");
            if (nl != null) {
                int i = 0;
                int length = nl.getLength();
                while (i < length) {
                    TrustField tf = TrustField.parse((Element)nl.item(i));
                    if (tf != null) {
                        t.addTrustField(tf);
                    } else {
                        System.out.println("Parse trustfield failed, please check trustfiled.xml");
                    }
                    ++i;
                }
            }
            TrustConfig trustConfig = t;
            return trustConfig;
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"GBK\"?>\n");
        buf.append("<trust-config>\n");
        buf.append("\t<path>").append(this.path).append("</path>\n");
        if (this.trustFields != null) {
            TrustField[] ts = this.trustFields.values().toArray(new TrustField[0]);
            int i = 0;
            int size = ts.length;
            while (i < size) {
                buf.append(ts[i].toXML());
                ++i;
            }
        }
        buf.append("</trust-config>\n");
        return buf.toString();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public HashMap getTrustFields() {
        return this.trustFields;
    }

    public void setTrustFields(HashMap trustFields) {
        this.trustFields = trustFields;
    }
}

