/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.config;

import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.frame.config.Config;
import cn.com.infosec.netsign.frame.config.PDFSignConfig;
import cn.com.infosec.netsign.frame.util.ConfigUtil;
import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Service
implements Config,
Serializable,
Cloneable {
    private static final long serialVersionUID = 3218860624725976043L;
    private String name;
    private String ip = "*";
    private int port = 40000;
    private String portHEX;
    private int timeout = 300000;
    private String communiteStoreAlias;
    private String verifyDigestAlg = "SHA1";
    private String verifySM2DigestAlg = "SM3";
    private String verifySignatureAlg = "RSA";
    private String verifySM2SignatureAlg = "SM2";
    private boolean checkValidity = true;
    private ArrayList trustFields = new ArrayList();
    private String sigDigestAlg = "SHA1";
    private String sigSM2DigestAlg = "SM3";
    private String sigSignatureAlg = "RSA";
    private String sigSM2SignatureAlg = "SM2";
    private ArrayList signCertAlias = new ArrayList();
    private String symmetricalAlg = "RC4";
    private ArrayList encryptCertAlias = new ArrayList();
    private String logLevel = "INFO";
    private String remoteLogIP;
    private String remoteLogDevice;
    private boolean clientAuthEnabled = false;
    private ArrayList clientAuth = new ArrayList();
    private boolean verifySignCert = true;
    private PDFSignConfig pdfSignConfig;
    private byte[] passwd;
    private ArrayList resourceNames = new ArrayList();
    private String certType;
    private boolean checkService = false;

    public static Service parse(Element e) {
        Service s = new Service();
        String str = ConfigUtil.getAttributeValue(e, "name", null);
        if (str == null || str.equals("")) {
            System.out.println("Service name: null");
            return null;
        }
        String apipasswd = ConfigUtil.getAttributeValue(e, "passwd", null);
        if (apipasswd != null && !apipasswd.equals("")) {
            s.passwd = Base64.decode((String)apipasswd);
        }
        s.name = str;
        s.ip = ConfigUtil.getNodeText(e, "ip", "*");
        s.port = ConfigUtil.getNodeInt(e, "port", 40000);
        s.checkService = ConfigUtil.getNodeBoolean(e, "checkService", false);
        Element ctTmp = ConfigUtil.getElement(e, "resource");
        if (ctTmp != null) {
            s.certType = ConfigUtil.getAttributeValue(ctTmp, "name", null);
        }
        s.portHEX = Integer.toHexString(s.port);
        s.portHEX = s.portHEX.length() % 2 == 0 ? s.portHEX : "0" + s.portHEX;
        s.timeout = ConfigUtil.getNodeInt(e, "timeout", 300) * 1000;
        Element eTmp = ConfigUtil.getElement(e, "communicate-store");
        if (eTmp != null) {
            s.communiteStoreAlias = ConfigUtil.getAttributeValue(eTmp, "alias", null);
        }
        if (s.communiteStoreAlias != null) {
            s.communiteStoreAlias = s.communiteStoreAlias.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        }
        if ((eTmp = ConfigUtil.getElement(e, "verify-config")) != null && !Service.parseVerifyConfig(eTmp, s)) {
            System.out.println("Parse verify config failed");
        }
        if ((eTmp = ConfigUtil.getElement(e, "signature-config")) != null && !Service.parseSignatureConfig(eTmp, s)) {
            System.out.println("Parse signature config failed");
        }
        if ((eTmp = ConfigUtil.getElement(e, "pdf-sign-config")) != null) {
            s.pdfSignConfig = PDFSignConfig.parse(e);
        }
        if ((eTmp = ConfigUtil.getElement(e, "encryption-config")) != null && !Service.parseEncryptionConfig(eTmp, s)) {
            System.out.println("Parse encryption config failed");
        }
        if ((eTmp = ConfigUtil.getElement(e, "client-auth-policy")) != null) {
            Service.parseClientAuthPolicy(eTmp, s);
        }
        if ((eTmp = ConfigUtil.getElement(e, "log-config")) != null && !Service.parseLogConfig(eTmp, s)) {
            System.out.println("Parse log config failed");
        }
        if ((eTmp = ConfigUtil.getElement(e, "resources")) != null) {
            Service.parseResourcesConfig(eTmp, s);
        }
        return s;
    }

    private static boolean parseResourcesConfig(Element e, Service s) {
        NodeList nl = e.getElementsByTagName("resource");
        if (nl != null && nl.getLength() > 0) {
            int i = 0;
            while (i < nl.getLength()) {
                Element re = (Element)nl.item(i);
                String rName = ConfigUtil.getAttributeValue(re, "name", null);
                if (rName != null && !rName.equals("")) {
                    s.resourceNames.add(rName);
                }
                ++i;
            }
        }
        return true;
    }

    private static boolean parseVerifyConfig(Element e, Service s) {
        NodeList algL = e.getElementsByTagName("algorithm");
        if (algL != null) {
            Element alg = (Element)algL.item(0);
            s.verifyDigestAlg = ConfigUtil.getAttributeValue(alg, "digest", "SHA1");
            s.verifySM2DigestAlg = ConfigUtil.getAttributeValue(alg, "sm2digest", "SM3");
            s.verifySignatureAlg = ConfigUtil.getAttributeValue(alg, "signature", "RSA");
            s.verifySM2SignatureAlg = ConfigUtil.getAttributeValue(alg, "sm2signature", "SM2");
        }
        s.checkValidity = ConfigUtil.getNodeBoolean(e, "check-validity", true);
        s.verifySignCert = ConfigUtil.getNodeBoolean(e, "verify-sign-cert", true);
        NodeList tfs = e.getElementsByTagName("trustfield");
        if (tfs == null || tfs.getLength() < 1) {
            System.out.println("Trust field: null");
            return false;
        }
        int i = 0;
        int length = tfs.getLength();
        while (i < length) {
            Element tf = (Element)tfs.item(i);
            String name = ConfigUtil.getAttributeValue(tf, "name", null);
            if (name != null) {
                s.addTrustField(name);
            }
            ++i;
        }
        return true;
    }

    private static boolean parseSignatureConfig(Element e, Service s) {
        NodeList certs;
        NodeList algL = e.getElementsByTagName("algorithm");
        if (algL != null) {
            Element alg = (Element)algL.item(0);
            s.sigDigestAlg = ConfigUtil.getAttributeValue(alg, "digest", "SHA1");
            s.sigSignatureAlg = ConfigUtil.getAttributeValue(alg, "signature", "RSA");
            s.sigSM2DigestAlg = ConfigUtil.getAttributeValue(alg, "sm2digest", "SM3");
            s.sigSM2SignatureAlg = ConfigUtil.getAttributeValue(alg, "sm2signature", "SM2");
        }
        if ((certs = e.getElementsByTagName("sign-cert")) == null || certs.getLength() < 1) {
            System.out.println("Signature certs: null");
            return false;
        }
        int i = 0;
        int length = certs.getLength();
        while (i < length) {
            Element cert = (Element)certs.item(i);
            String alias = ConfigUtil.getAttributeValue(cert, "alias", null);
            if (alias != null) {
                s.addSignCertAlias(alias);
            }
            ++i;
        }
        return true;
    }

    private static boolean parseEncryptionConfig(Element e, Service s) {
        NodeList nl = e.getElementsByTagName("algorithm");
        if (nl != null && nl.getLength() > 0) {
            Element n = (Element)nl.item(0);
            s.symmetricalAlg = ConfigUtil.getAttributeValue(n, "symmetrical", "RC4");
        }
        if ((nl = e.getElementsByTagName("encrypt-cert")) != null && nl.getLength() > 0) {
            int i = 0;
            int length = nl.getLength();
            while (i < length) {
                Element n = (Element)nl.item(i);
                String alias = ConfigUtil.getAttributeValue(n, "alias", null);
                if (alias != null) {
                    s.encryptCertAlias.add(alias);
                }
                ++i;
            }
        } else {
            System.out.println("Encrypt certs: null");
            return false;
        }
        return true;
    }

    private static void parseClientAuthPolicy(Element e, Service s) {
        String enable = ConfigUtil.getAttributeValue(e, "enabled", "false");
        try {
            s.clientAuthEnabled = Boolean.parseBoolean(enable);
        }
        catch (Exception exception) {
            // empty catch block
        }
        NodeList nl = e.getElementsByTagName("client");
        if (nl != null && nl.getLength() > 0) {
            int i = 0;
            int length = nl.getLength();
            while (i < length) {
                Element n = (Element)nl.item(i);
                String str = ConfigUtil.getAttributeValue(n, "value", null);
                if (str != null) {
                    s.clientAuth.add(str);
                }
                ++i;
            }
        }
    }

    private static boolean parseLogConfig(Element e, Service s) {
        s.logLevel = ConfigUtil.getNodeText(e, "level", "INFO");
        Element rl = ConfigUtil.getElement(e, "remote-log");
        if (rl != null) {
            String ip = ConfigUtil.getAttributeValue(rl, "ip", null);
            if (ip == null || ip.equals("")) {
                System.out.println("Remote log ip: null");
                return false;
            }
            s.setRemoteLogIP(ConfigUtil.xmlString2Input(ip));
            String device = ConfigUtil.getAttributeValue(rl, "device", "local1");
            s.setRemoteLogDevice(device);
        }
        return true;
    }

    public String toXML() {
        int size;
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append("\t<service name=\"").append(this.name).append("\" ");
        if (this.passwd != null) {
            buf.append("passwd=\"" + Base64.encode((byte[])this.passwd) + "\"");
        }
        buf.append(">\n");
        buf.append("\t\t<!--\u652f\u6301\u7528*\u6216\u4e0d\u914d\u7f6e\u6b64\u9879\u8868\u793a\u7ed1\u5b9a\u5230\u6240\u6709ip-->\n");
        buf.append("\t\t<ip>").append(this.ip).append("</ip>\n");
        buf.append("\t\t<port>").append(this.port).append("</port>\n");
        buf.append("\t\t<checkService>").append(this.checkService).append("</checkService>\n");
        if (this.certType != null) {
            buf.append("\t\t<resources>\n");
            buf.append("\t\t\t<resource name=\"").append(this.certType).append("\"/>\n");
            buf.append("\t\t</resources>\n");
        }
        buf.append("\t\t<!--\u8d85\u65f6\u65f6\u95f4\uff0c\u79d2\u4e3a\u5355\u4f4d\uff0c\u53ef\u9009\uff0c\u9ed8\u8ba4\u4e3a120-->\n");
        buf.append("\t\t<timeout>").append(this.timeout / 1000).append("</timeout>\n");
        if (this.communiteStoreAlias != null && !this.communiteStoreAlias.equals("")) {
            buf.append("\t\t<!--\u901a\u4fe1\u52a0\u5bc6\u8bc1\u4e66\uff0c\u53ef\u9009-->\n");
            buf.append("\t\t<communicate-store alias=\"").append(this.communiteStoreAlias).append("\"/>\n");
        }
        if (this.trustFields != null && this.trustFields.size() > 0) {
            buf.append("\t\t<verify-config>\n");
            buf.append("\t\t\t<!--\u7b97\u6cd5\u914d\u7f6e\uff0c\u53ef\u9009\uff0c\u4e0d\u914d\u7f6e\u65f6\u9ed8\u8ba4\u4f7f\u7528SHA1\u548cRSA-->\n");
            buf.append("\t\t\t<algorithm digest=\"").append(this.verifyDigestAlg).append("\" signature=\"").append(this.verifySignatureAlg).append("\" sm2digest=\"").append(this.verifySM2DigestAlg).append("\" sm2signature=\"").append(this.verifySM2SignatureAlg).append("\" opttype=\"sigverify\"/>\n");
            buf.append("\t\t\t<!--\u662f\u5426\u68c0\u67e5\u8bc1\u4e66\u7684\u8fc7\u671f\u65f6\u95f4\uff0c\u53ef\u9009\uff0c\u9ed8\u8ba4\u4e3atrue-->\n");
            buf.append("\t\t\t<check-validity>").append(this.checkValidity).append("</check-validity>\n");
            buf.append("\t\t\t<!--\u4fe1\u4efb\u57df\uff0c\u9a8c\u7b7e\u540d\u65f6\u9700\u8981\u914d\u7f6e\uff0c\u53ef\u9009\uff0c\u4e0d\u914d\u7f6e\u65f6\u4e0d\u80fd\u505a\u9a8c\u7b7e\u540d\uff08\u4f46\u662f\u53ef\u4ee5\u652f\u6301\u7528\u516c\u94a5\u9a8cRAW\u7684\u65b9\u5f0f\uff09-->\n");
            buf.append("\t\t\t<!--\u662f\u5426\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66-->\n");
            buf.append("\t\t\t<verify-sign-cert>true</verify-sign-cert>\n");
            i = 0;
            size = this.trustFields.size();
            while (i < size) {
                buf.append("\t\t\t<trustfield name=\"").append(this.trustFields.get(i)).append("\"/>\n");
                ++i;
            }
            buf.append("\t\t</verify-config>\n");
        }
        if (this.signCertAlias != null && this.signCertAlias.size() > 0) {
            buf.append("\t\t<!--\u7b7e\u540d\u76f8\u5173\u914d\u7f6e\uff0c\u53ef\u9009\uff0c\u4e0d\u914d\u7f6e\u65f6\u4e0d\u80fd\u505a\u7b7e\u540d-->\n");
            buf.append("\t\t<signature-config>\n");
            buf.append("\t\t\t<!--\u7b97\u6cd5\u914d\u7f6e\uff0c\u53ef\u9009\uff0c\u4e0d\u914d\u7f6e\u65f6\u9ed8\u8ba4\u4f7f\u7528SHA1\u548cRSA-->\n");
            buf.append("\t\t\t<algorithm digest=\"").append(this.sigDigestAlg).append("\" signature=\"").append(this.sigSignatureAlg).append("\" sm2digest=\"").append(this.sigSM2DigestAlg).append("\" sm2signature=\"").append(this.sigSM2SignatureAlg).append("\" opttype=\"sig\"/>\n");
            buf.append("\t\t\t<!--\u7b7e\u540d\u8bc1\u4e66\uff0c\u5fc5\u987b-->\n");
            i = 0;
            size = this.signCertAlias.size();
            while (i < size) {
                buf.append("\t\t\t<sign-cert alias=\"").append((String)this.signCertAlias.get(i)).append("\"/>\n");
                ++i;
            }
            buf.append("\t\t</signature-config>\n");
        }
        if (this.pdfSignConfig != null) {
            buf.append(this.pdfSignConfig.toXML());
        }
        if (this.encryptCertAlias != null && this.encryptCertAlias.size() > 0) {
            buf.append("\t\t<!--\u52a0\u5bc6\u76f8\u5173\u914d\u7f6e\uff0c\u53ef\u9009\uff0c\u4e0d\u914d\u7f6e\u4e0d\u80fd\u89e3\u5bc6-->\n");
            buf.append("\t\t<encryption-config>\n");
            buf.append("\t\t\t<!--\u7b97\u6cd5\u914d\u7f6e\uff0c\u53ef\u9009\uff0c\u4e0d\u914d\u7f6e\u65f6\u9ed8\u8ba4\u4f7f\u7528RC4-->\n");
            buf.append("\t\t\t<algorithm symmetrical=\"").append(this.symmetricalAlg).append("\"/>\n");
            buf.append("\t\t\t<!--\u52a0\u3001\u89e3\u5bc6\u8bc1\u4e66\uff0c\u5982\u4e0d\u914d\u7f6e\u53ea\u7528\u7528\u5ba2\u6237\u7aef\u8bc1\u4e66\u8fdb\u884c\u52a0\u5bc6-->\n");
            i = 0;
            size = this.encryptCertAlias.size();
            while (i < size) {
                buf.append("\t\t\t<encrypt-cert alias=\"").append((String)this.encryptCertAlias.get(i)).append("\"/>\n");
                ++i;
            }
            buf.append("\t\t</encryption-config>\n");
        }
        if (this.clientAuth != null && this.clientAuth.size() > 0) {
            buf.append("\t\t<!--\u7528\u6237IP\u8ba4\u8bc1-->\n");
            buf.append("\t\t<client-auth-policy enabled=\"").append(this.clientAuthEnabled).append("\">\n");
            i = 0;
            size = this.clientAuth.size();
            while (i < size) {
                buf.append("\t\t\t<client value=\"").append(this.clientAuth.get(i)).append("\"/>\n");
                ++i;
            }
            buf.append("\t\t</client-auth-policy>\n");
        }
        buf.append("\t\t<!--\u65e5\u5fd7\u914d\u7f6e\uff0c\u53ef\u9009\uff0c\u9ed8\u8ba4\u4e3aInfo\u7ea7-->\n");
        buf.append("\t\t<log-config>\n");
        buf.append("\t\t\t<!--\u65e5\u5fd7\u7ea7\u522b\uff0cinfo\u3001error\u3001detail\uff0c\u53ef\u9009\uff0c\u9ed8\u8ba4\u4e3aInfo\u7ea7-->\n");
        buf.append("\t\t\t<level>").append(this.logLevel).append("</level>\n");
        if (this.remoteLogIP != null && !this.remoteLogIP.equals("")) {
            String tmp = ConfigUtil.input2XMLString(this.remoteLogIP);
            buf.append("\t\t\t<!--\u8fdc\u7a0b\u65e5\u5fd7\u914d\u7f6e\uff0c\u53ef\u9009-->\n");
            buf.append("\t\t\t<remote-log ip=\"").append(tmp).append("\" device=\"").append(this.remoteLogDevice).append("\"/>\n");
        }
        buf.append("\t\t</log-config>\n");
        buf.append("\t</service>\n");
        return buf.toString();
    }

    public ArrayList getResourceNames() {
        return this.resourceNames;
    }

    public void setResourceNames(ArrayList resourceNames) {
        this.resourceNames = resourceNames;
    }

    public void setPasswd(byte[] passwd) {
        this.passwd = passwd;
    }

    public byte[] getPasswd() {
        return this.passwd;
    }

    public boolean isVerifyCert() {
        return this.verifySignCert;
    }

    public boolean isCheckValidity() {
        return this.checkValidity;
    }

    public void setCheckValidity(boolean checkValidity) {
        this.checkValidity = checkValidity;
    }

    public String getCommuniteStoreAlias() {
        return this.communiteStoreAlias;
    }

    public void setCommuniteStoreAlias(String communiteStoreAlias) {
        this.communiteStoreAlias = communiteStoreAlias;
    }

    public String getSigDigestAlg(String sigAlg) {
        if (sigAlg.toUpperCase().equals("SM2")) {
            return this.sigSM2DigestAlg;
        }
        return this.sigDigestAlg;
    }

    public void setSigDigestAlg(String digestAlg) {
        this.sigDigestAlg = digestAlg;
    }

    public ArrayList getEncryptCertAlias() {
        return this.encryptCertAlias;
    }

    public void setEncryptCertAlias(ArrayList enctryptCertAlias) {
        this.encryptCertAlias = enctryptCertAlias;
    }

    public int encryptCertAliasSize() {
        return this.signCertAlias.size();
    }

    public void addEncryptCertAlias(String alias) {
        this.encryptCertAlias.add(alias);
    }

    public void removeEncryptCertAlias(String alias) {
        this.encryptCertAlias.remove(alias);
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPortHEX() {
        return this.portHEX;
    }

    public void setPortHEX(String portHEX) {
        this.portHEX = portHEX;
    }

    public String getRemoteLogDevice() {
        return this.remoteLogDevice;
    }

    public void setRemoteLogDevice(String remoteLogDevice) {
        this.remoteLogDevice = remoteLogDevice;
    }

    public String getRemoteLogIP() {
        return this.remoteLogIP;
    }

    public void setRemoteLogIP(String remoteLogIP) {
        this.remoteLogIP = remoteLogIP;
    }

    public String getSigSignatureAlg() {
        return this.sigSignatureAlg;
    }

    public void setSigSignatureAlg(String signatureAlg) {
        this.sigSignatureAlg = signatureAlg;
    }

    public ArrayList getSignCertAlias() {
        return this.signCertAlias;
    }

    public void setSignCertAlias(ArrayList signCertAlias) {
        this.signCertAlias = signCertAlias;
    }

    public int signCertAliasSize() {
        return this.signCertAlias.size();
    }

    public void addSignCertAlias(String alias) {
        this.signCertAlias.add(alias);
    }

    public void removeSignCertAlias(String alias) {
        this.signCertAlias.remove(alias);
    }

    public String getSymmetricalAlg() {
        return this.symmetricalAlg;
    }

    public void setSymmetricalAlg(String symmetricalAlg) {
        this.symmetricalAlg = symmetricalAlg;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public ArrayList getTrustFields() {
        return this.trustFields;
    }

    public void setTrustFields(ArrayList trustFields) {
        this.trustFields = trustFields;
    }

    public int trustFieldSize() {
        return this.trustFields.size();
    }

    public String getTrustField(int i) {
        return (String)this.trustFields.get(i);
    }

    public void addTrustField(String name) {
        this.trustFields.add(name);
    }

    public void removeTrustField(String name) {
        this.trustFields.remove(name);
    }

    public ArrayList getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(ArrayList clientAuth) {
        this.clientAuth = clientAuth;
    }

    public int clientAuthSize() {
        return this.clientAuth.size();
    }

    public void addClientAuth(String ip) {
        this.clientAuth.add(ip);
    }

    public void removeClientAuth(String ip) {
        this.clientAuth.remove(ip);
    }

    public boolean isClientAuthEnabled() {
        return this.clientAuthEnabled;
    }

    public void setClientAuthEnabled(boolean clientAuthEnabled) {
        this.clientAuthEnabled = clientAuthEnabled;
    }

    public String getVerifyDigestAlg(String sigAlg) {
        if (sigAlg.equals("SM2")) {
            return this.verifySM2DigestAlg;
        }
        return this.verifyDigestAlg;
    }

    public void setVerifyDigestAlg(String verifyDigestAlg) {
        this.verifyDigestAlg = verifyDigestAlg;
    }

    public String getVerifySignatureAlg() {
        return this.verifySignatureAlg;
    }

    public void setVerifySignatureAlg(String verifySignatureAlg) {
        this.verifySignatureAlg = verifySignatureAlg;
    }

    public PDFSignConfig getPdfSignConfig() {
        return this.pdfSignConfig;
    }

    public void setPdfSignConfig(PDFSignConfig pdfSignConfig) {
        this.pdfSignConfig = pdfSignConfig;
    }

    public Object clone() throws CloneNotSupportedException {
        Service s = new Service();
        s.setCheckValidity(this.checkValidity);
        if (this.clientAuth != null) {
            s.setClientAuth(new ArrayList(this.clientAuth));
        } else {
            s.setClientAuth(null);
        }
        s.setClientAuthEnabled(this.clientAuthEnabled);
        s.setCommuniteStoreAlias(this.communiteStoreAlias);
        if (this.encryptCertAlias != null) {
            s.setEncryptCertAlias(new ArrayList(this.encryptCertAlias));
        } else {
            s.setEncryptCertAlias(null);
        }
        s.setIp(this.ip);
        s.setLogLevel(this.logLevel);
        s.setName(this.name);
        s.setPort(this.port);
        s.setCheckService(this.checkService);
        s.setCertType(this.certType);
        s.setPortHEX(this.portHEX);
        s.setRemoteLogDevice(this.remoteLogDevice);
        s.setRemoteLogIP(this.remoteLogIP);
        s.setSigDigestAlg(this.sigDigestAlg);
        s.setSigSM2DigestAlg(this.sigSM2DigestAlg);
        s.setVerifySM2DigestAlg(this.verifySM2DigestAlg);
        if (this.signCertAlias != null) {
            s.setSignCertAlias(new ArrayList(this.signCertAlias));
        } else {
            s.setSignCertAlias(null);
        }
        s.setSigSignatureAlg(this.sigSignatureAlg);
        s.setSymmetricalAlg(this.symmetricalAlg);
        s.setTimeout(this.timeout);
        if (this.trustFields != null) {
            s.setTrustFields(new ArrayList(this.trustFields));
        } else {
            s.setTrustFields(null);
        }
        s.setVerifyDigestAlg(this.verifyDigestAlg);
        s.setVerifySignatureAlg(this.verifySignatureAlg);
        s.setPdfSignConfig(this.pdfSignConfig);
        s.setPasswd(this.passwd);
        s.setResourceNames(new ArrayList(this.resourceNames));
        return s;
    }

    public String getVerifySM2DigestAlg() {
        return this.verifySM2DigestAlg;
    }

    public void setVerifySM2DigestAlg(String verifySM2DigestAlg) {
        this.verifySM2DigestAlg = verifySM2DigestAlg;
    }

    public String getVerifySM2SignatureAlg() {
        return this.verifySM2SignatureAlg;
    }

    public void setVerifySM2SignatureAlg(String verifySM2SignatureAlg) {
        this.verifySM2SignatureAlg = verifySM2SignatureAlg;
    }

    public String getSigSM2DigestAlg() {
        return this.sigSM2DigestAlg;
    }

    public void setSigSM2DigestAlg(String sigSM2DigestAlg) {
        this.sigSM2DigestAlg = sigSM2DigestAlg;
    }

    public String getSigSM2SignatureAlg() {
        return this.sigSM2SignatureAlg;
    }

    public void setSigSM2SignatureAlg(String sigSM2SignatureAlg) {
        this.sigSM2SignatureAlg = sigSM2SignatureAlg;
    }

    public String getCertType() {
        return this.certType;
    }

    public void setCertType(String certType) {
        this.certType = certType;
    }

    public boolean isCheckService() {
        return this.checkService;
    }

    public void setCheckService(boolean checkService) {
        this.checkService = checkService;
    }

    private static String xmlSpec(String ctn) {
        if (ctn == null) {
            return ctn;
        }
        return ctn.replace("<", "&lt;").replace(">", "&gt;").replace("'", "&apos;").replace("&", "&amp;").replace("\"", "&quot;");
    }
}

