/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.config;

import cn.com.infosec.netsign.frame.config.Config;
import cn.com.infosec.netsign.frame.util.ConfigUtil;
import java.io.Serializable;
import org.w3c.dom.Element;

public class PDFSignConfig
implements Config,
Serializable,
Cloneable {
    private String userDesc;
    private String stamp;
    private boolean printSubject = false;
    private boolean printIssuerSubject = false;
    private boolean printSerialNumber = false;
    private boolean printExpireDate = false;
    private String fontName = "STSong-Light";
    private String fontEncoding = "UniGB-UCS2-H";
    private float fontSize = 0.0f;
    private int fontColorRGB = 0;

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public String getFontEncoding() {
        return this.fontEncoding;
    }

    public void setFontEncoding(String fontEncoding) {
        this.fontEncoding = fontEncoding;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public int getFontColorRGB() {
        return this.fontColorRGB;
    }

    public void setFontColorRGB(int fontColorRGB) {
        this.fontColorRGB = fontColorRGB;
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("\t\t<!--pdf\u7b7e\u540d\u914d\u7f6e-->\n");
        buf.append("\t\t<pdf-sign-config>\n");
        if (this.userDesc != null && !this.userDesc.equals("")) {
            String tmp = this.userDesc.replaceAll("<", "&lt;");
            tmp = tmp.replaceAll(">", "&gt;");
            buf.append("\t\t\t<user-desc>").append(tmp).append("</user-desc>\n");
        }
        if (this.stamp != null && !this.stamp.equals("")) {
            buf.append("\t\t\t<pdf-stamp>").append(this.stamp).append("</pdf-stamp>\n");
        }
        buf.append("\t\t\t<print-subject>").append(this.printSubject).append("</print-subject>\n");
        buf.append("\t\t\t<print-issuer-subject>").append(this.printIssuerSubject).append("</print-issuer-subject>\n");
        buf.append("\t\t\t<print-serial-number>").append(this.printSerialNumber).append("</print-serial-number>\n");
        buf.append("\t\t\t<print-expire-date>").append(this.printExpireDate).append("</print-expire-date>\n");
        buf.append("\t\t\t<font-name>").append(this.fontName).append("</font-name>\n");
        buf.append("\t\t\t<font-encoding>").append(this.fontEncoding).append("</font-encoding>\n");
        buf.append("\t\t\t<font-size>").append(this.fontSize).append("</font-size>\n");
        buf.append("\t\t\t<font-color>").append(Integer.toHexString(this.fontColorRGB & 0xFFFFFF)).append("</font-color>\n");
        buf.append("\t\t</pdf-sign-config>\n");
        return buf.toString();
    }

    public static PDFSignConfig parse(Element e) {
        PDFSignConfig c = new PDFSignConfig();
        c.userDesc = ConfigUtil.getNodeText(e, "user-desc", null);
        if (c.userDesc != null) {
            c.userDesc = c.userDesc.replaceAll("&lt;", "<");
            c.userDesc = c.userDesc.replaceAll("&gt;", ">");
        }
        c.stamp = ConfigUtil.getNodeText(e, "pdf-stamp", null);
        c.printSubject = ConfigUtil.getNodeBoolean(e, "print-subject", true);
        c.printIssuerSubject = ConfigUtil.getNodeBoolean(e, "print-issuer-subject", true);
        c.printSerialNumber = ConfigUtil.getNodeBoolean(e, "print-serial-number", true);
        c.printExpireDate = ConfigUtil.getNodeBoolean(e, "print-expire-date", true);
        c.fontName = ConfigUtil.getNodeText(e, "font-name", c.fontName);
        c.fontEncoding = ConfigUtil.getNodeText(e, "font-encoding", c.fontEncoding);
        c.fontSize = ConfigUtil.getNodeFloat(e, "font-size", c.fontSize);
        c.fontColorRGB = ConfigUtil.getNodeInt(e, "font-color", c.fontColorRGB, 16);
        c.fontColorRGB &= 0xFFFFFF;
        return c;
    }

    public String getUserDesc() {
        return this.userDesc;
    }

    public void setUserDesc(String userText) {
        this.userDesc = userText;
    }

    public String getStamp() {
        return this.stamp;
    }

    public void setStamp(String stamp) {
        this.stamp = stamp;
    }

    public boolean isPrintSubject() {
        return this.printSubject;
    }

    public void setPrintSubject(boolean printSubject) {
        this.printSubject = printSubject;
    }

    public boolean isPrintIssuerSubject() {
        return this.printIssuerSubject;
    }

    public void setPrintIssuerSubject(boolean printIssuerSubject) {
        this.printIssuerSubject = printIssuerSubject;
    }

    public boolean isPrintSerialNumber() {
        return this.printSerialNumber;
    }

    public void setPrintSerialNumber(boolean printSerialNumber) {
        this.printSerialNumber = printSerialNumber;
    }

    public boolean isPrintExpireDate() {
        return this.printExpireDate;
    }

    public void setPrintExpireDate(boolean printExpireDate) {
        this.printExpireDate = printExpireDate;
    }
}

