/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.config;

import cn.com.infosec.netsign.frame.config.Config;
import cn.com.infosec.netsign.frame.config.Key;
import cn.com.infosec.netsign.frame.util.ConfigUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class KeyStoreConfig
implements Config,
Serializable {
    private static final long serialVersionUID = 4536166912445680696L;
    private String storePwd;
    private String storeFile;
    private HashMap keyList = new HashMap();

    public Key[] getKeysByUsage(String usage) {
        Key[] ks = this.getKeys();
        ArrayList<Key> tmp = new ArrayList<Key>();
        int i = 0;
        int length = ks.length;
        while (i < length) {
            if (ks[i].getUsage().equals(usage) || ks[i].getUsage().equals("both")) {
                tmp.add(ks[i]);
            }
            ++i;
        }
        return tmp.toArray(new Key[0]);
    }

    public Key[] getKeys() {
        return this.keyList.values().toArray(new Key[0]);
    }

    public void addKey(Key key) {
        if (key.getAlias() != null) {
            this.keyList.put(key.getAlias(), key);
        } else {
            this.keyList.put(key.getKeylable(), key);
        }
    }

    public Key getKey(String alias) {
        return (Key)this.keyList.get(alias);
    }

    public Key remove(String alias) {
        return (Key)this.keyList.remove(alias);
    }

    public static KeyStoreConfig parse(String file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(in);
            KeyStoreConfig k = new KeyStoreConfig();
            Element root = doc.getDocumentElement();
            k.storeFile = ConfigUtil.getNodeText(root, "store-file", "nsstore.jks");
            k.storePwd = ConfigUtil.getNodeText(root, "store-pwd", null);
            NodeList nl = root.getElementsByTagName("key");
            if (nl != null) {
                int i = 0;
                int size = nl.getLength();
                while (i < size) {
                    Element ke = (Element)nl.item(i);
                    k.addKey(Key.parse(ke));
                    ++i;
                }
            }
            KeyStoreConfig keyStoreConfig = k;
            return keyStoreConfig;
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            return null;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"GBK\"?>\n");
        buf.append("<keystore-config>\n");
        buf.append("\t<store-file>").append(this.storeFile).append("</store-file>\n");
        if (this.storePwd != null) {
            buf.append("\t<!--\u5bc6\u94a5\u5e93\u53e3\u4ee4-->\n");
            buf.append("\t<store-pwd>").append(this.storePwd).append("</store-pwd>\n");
        }
        if (this.keyList != null) {
            Key[] ks = this.getKeys();
            int i = 0;
            int length = ks.length;
            while (i < length) {
                buf.append(ks[i].toXML());
                ++i;
            }
        }
        buf.append("</keystore-config>\n");
        return buf.toString();
    }

    public HashMap getKeyList() {
        return this.keyList;
    }

    public void setKeyList(HashMap keyList) {
        this.keyList = keyList;
    }

    public String getStoreFile() {
        return this.storeFile;
    }

    public void setStoreFile(String storeFile) {
        this.storeFile = storeFile;
    }

    public String getStorePwd() {
        return this.storePwd;
    }

    public void setStorePwd(String storePwd) {
        this.storePwd = storePwd;
    }
}

