/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.config;

import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.netsign.frame.config.Config;
import cn.com.infosec.netsign.frame.util.ConfigUtil;
import java.io.FileInputStream;
import java.io.Serializable;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.w3c.dom.Element;

public class Key
implements Config,
Serializable {
    private static final long serialVersionUID = -1763077069755815646L;
    public static final String USAGE_SIGN = "sign";
    public static final String USAGE_ENCRYPT = "encrypt";
    public static final String USAGE_BOTH = "both";
    public static final String MODE_SOFT = "soft";
    public static final String MODE_HARD_SM2 = "hard.sm2";
    public static final String MODE_HARD_STORE = "hard.store";
    private String mode;
    private String alias;
    private String pwd;
    private String subject;
    private String issuer;
    private long notBefore = 0L;
    private long notAfter = 0L;
    private int keySize = 0;
    private String usage;
    private String keylable;
    private String keytype;
    private String prikey;
    private String pubkey;
    private String cert;
    private String privateKeyAlg = null;

    public static Key parse(Element e) {
        String tmp;
        Key k = new Key();
        k.mode = ConfigUtil.getAttributeValue(e, "mode", MODE_SOFT);
        k.keytype = ConfigUtil.getNodeText(e, "keytype", "RSA");
        k.keylable = ConfigUtil.getNodeText(e, "keylable", null);
        k.alias = ConfigUtil.getNodeText(e, "alias", null);
        if (k.alias != null) {
            k.alias = Key.xmlSpec(k.alias);
        }
        k.pwd = ConfigUtil.getNodeText(e, "pwd", null);
        k.subject = ConfigUtil.getNodeText(e, "subject", null);
        if (k.subject != null) {
            k.subject = Key.xmlSpec(k.subject);
        }
        k.issuer = ConfigUtil.getNodeText(e, "issuer", null);
        if (k.issuer != null) {
            k.issuer = Key.xmlSpec(k.issuer);
        }
        if ((tmp = ConfigUtil.getNodeText(e, "not-before", null)) != null) {
            k.notBefore = Long.parseLong(tmp);
        }
        if ((tmp = ConfigUtil.getNodeText(e, "not-after", null)) != null) {
            k.notAfter = Long.parseLong(tmp);
        }
        if ((tmp = ConfigUtil.getNodeText(e, "keysize", null)) != null) {
            k.keySize = Integer.parseInt(tmp);
        }
        k.usage = ConfigUtil.getNodeText(e, "usage", USAGE_BOTH);
        k.prikey = ConfigUtil.getNodeText(e, "prikey", null);
        k.pubkey = ConfigUtil.getNodeText(e, "pubkey", null);
        k.cert = ConfigUtil.getNodeText(e, "cert", null);
        k.privateKeyAlg = ConfigUtil.getNodeText(e, "privatekeyalg", null);
        return k;
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("\t<key mode=\"").append(this.mode).append("\">\n");
        if (this.alias != null) {
            this.alias = Key.xmlSpec(this.alias);
            buf.append("\t\t<!--JKS\u4e2d\u8bc1\u4e66\u7684\u522b\u540d\uff0c\u53ef\u4ee5\u4f7f\u7528DN+Kid-->\n");
            buf.append("\t\t<alias>").append(this.alias).append("</alias>\n");
        }
        if (this.keytype != null) {
            buf.append("\t\t<!--\u5bc6\u94a5\u7c7b\u578b-->\n");
            buf.append("\t\t<keytype>").append(this.keytype).append("</keytype>\n");
        }
        if (this.prikey != null) {
            buf.append("\t\t<!--\u79c1\u94a5-->\n");
            buf.append("\t\t<prikey>").append(this.prikey).append("</prikey>\n");
        }
        if (this.pubkey != null) {
            buf.append("\t\t<!--\u516c\u94a5-->\n");
            buf.append("\t\t<pubkey>").append(this.pubkey).append("</pubkey>\n");
        }
        if (this.cert != null) {
            buf.append("\t\t<!--\u8bc1\u4e66-->\n");
            buf.append("\t\t<cert>").append(this.cert).append("</cert>\n");
        }
        if (this.keylable != null) {
            buf.append("\t\t<!--\u786c\u4ef6\u4e2d\u5bc6\u94a5\u7684\u522b\u540d\uff0c\u6216\u751f\u6210P10\u8bf7\u6c42\u65f6\u7684\u4e34\u65f6\u522b\u540d\uff0c\u53ef\u4ee5\u4f7f\u7528'KEY:'DN';'Kid-->\n");
            buf.append("\t\t<keylable>").append(this.keylable).append("</keylable>\n");
        }
        if (this.privateKeyAlg != null) {
            buf.append("\t\t<!--\u662f\u5426\u5728\u4f7f\u7528\u52a0\u5bc6\u673a-->\n");
            buf.append("\t\t<privatekeyalg>").append(this.privateKeyAlg).append("</privatekeyalg>\n");
        }
        if (this.pwd != null) {
            buf.append("\t\t<!--\u53e3\u4ee4-->\n");
            buf.append("\t\t<pwd>").append(this.pwd).append("</pwd>\n");
        }
        if (this.subject != null) {
            this.subject = Key.xmlSpec(this.subject);
            buf.append("\t\t<!--\u8bc1\u4e66\u4e3b\u9898-->\n");
            buf.append("\t\t<subject>").append(this.subject).append("</subject>\n");
        }
        if (this.issuer != null) {
            this.issuer = Key.xmlSpec(this.issuer);
            buf.append("\t\t<!--\u8bc1\u4e66\u9881\u53d1\u8005\u4e3b\u9898-->\n");
            buf.append("\t\t<issuer>").append(this.issuer).append("</issuer>\n");
        }
        if (this.notBefore > 0L) {
            buf.append("\t\t<!--\u8bc1\u4e66\u751f\u6548\u65e5\u671f-->\n");
            buf.append("\t\t<not-before>").append(this.notBefore).append("</not-before>\n");
        }
        if (this.notAfter > 0L) {
            buf.append("\t\t<!--\u8bc1\u4e66\u5931\u6548\u65e5\u671f-->\n");
            buf.append("\t\t<not-after>").append(this.notAfter).append("</not-after>\n");
        }
        if (this.keySize > 0) {
            buf.append("\t\t<!--\u5bc6\u94a5\u957f\u5ea6-->\n");
            buf.append("\t\t<keysize>").append(this.keySize).append("</keysize>\n");
        }
        buf.append("\t\t<!--\u7528\u6cd5\uff0csign:\u7b7e\u540d\uff0cencrypt\uff1a\u52a0\u89e3\u5bc6\uff0cboth\uff1a\u7b7e\u540d\u52a0\u5bc6\u7686\u53ef-->\n");
        buf.append("\t\t<usage>").append(this.usage).append("</usage>\n");
        buf.append("\t</key>\n");
        return buf.toString();
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getKeylable() {
        return this.keylable;
    }

    public void setKeylable(String keylable) {
        this.keylable = keylable;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getPwd() {
        return this.pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public long getNotAfter() {
        return this.notAfter;
    }

    public void setNotAfter(long notAfter) {
        this.notAfter = notAfter;
    }

    public long getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(long notBefore) {
        this.notBefore = notBefore;
    }

    public String getKeytype() {
        return this.keytype;
    }

    public void setKeytype(String keytype) {
        this.keytype = keytype;
    }

    public String getPrikey() {
        return this.prikey;
    }

    public void setPrikey(String prikey) {
        this.prikey = prikey;
    }

    public String getPubkey() {
        return this.pubkey;
    }

    public void setPubkey(String pubkey) {
        this.pubkey = pubkey;
    }

    public String getCert() {
        return this.cert;
    }

    public void setCert(String cert) {
        this.cert = cert;
    }

    public String getPrivateKeyAlg() {
        return this.privateKeyAlg;
    }

    public void setPrivateKeyAlg(String privateKeyAlg) {
        this.privateKeyAlg = privateKeyAlg;
    }

    private static String xmlSpec(String ctn) {
        if (ctn == null) {
            return ctn;
        }
        return ctn.replace("<", "&lt;").replace(">", "&gt;").replace("&", "&amp;").replace("'", "&apos;").replace("\"", "&quot;");
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new InfosecProvider());
        FileInputStream in = new FileInputStream("D:\\3.cer.4netsign.cer");
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "INFOSEC");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(in);
        System.out.println(cert.getSubjectDN().toString());
        System.out.println(cert.getIssuerDN().toString());
        System.out.println(cert.getSigAlgName());
        System.out.println(cert.getSerialNumber());
    }
}

